/*
 * Decompiled with CFR 0.152.
 */
package com.bilolib.bobshop.adminmenu;

import com.bilolib.bobshop.BOBShop;
import com.bilolib.bobshop.manager.LangManager;
import com.bilolib.bobshop.market.Market;
import com.bilolib.bobshop.market.MarketDatabase;
import com.bilolib.bobshop.market.MarketMode;
import com.bilolib.bobshop.market.MarketOlusturma;
import com.bilolib.bobshop.menu.marketmenueventlist.ChangeItemMenu;
import com.bilolib.bobshop.menu.marketmenueventlist.DescriptionManager;
import com.bilolib.bobshop.menu.marketmenueventlist.PriceChangeManager;
import com.bilolib.bobshop.shopholo.ShopItemHolo;
import com.bilolib.bobshop.tabela.TabelaUpdate;
import com.bilolib.bobshop.util.MarketmodeKt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/bilolib/bobshop/adminmenu/AdminMenuEvent;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "waitingForItemSelection", "", "Ljava/util/UUID;", "Lcom/bilolib/bobshop/market/Market;", "onInventoryClick", "", "e", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "toggleMarketMode", "player", "Lorg/bukkit/entity/Player;", "market", "Companion", "BOBSHOP"})
public final class AdminMenuEvent
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UUID, Market> waitingForItemSelection = new LinkedHashMap();
    @NotNull
    private static final Map<UUID, Market> openAdminMenus = new LinkedHashMap();

    @EventHandler
    public final void onInventoryClick(@NotNull InventoryClickEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        HumanEntity humanEntity = e.getWhoClicked();
        Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        Market market = openAdminMenus.get(player2.getUniqueId());
        if (market == null) {
            return;
        }
        Market market2 = market;
        String string = LangManager.INSTANCE.getMessage("admin-menu-title");
        String string2 = player2.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        String string3 = ChatColor.translateAlternateColorCodes((char)'&', (String)StringsKt.replace$default(string, "{owner}", string2, false, 4, null));
        Intrinsics.checkNotNullExpressionValue(string3, "translateAlternateColorCodes(...)");
        String expectedTitle = string3;
        if (!Intrinsics.areEqual(e.getView().getTitle(), expectedTitle)) {
            return;
        }
        e.setCancelled(true);
        ItemStack itemStack = e.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        ItemStack clickedItem = itemStack;
        switch (WhenMappings.$EnumSwitchMapping$0[clickedItem.getType().ordinal()]) {
            case 1: {
                MarketDatabase.INSTANCE.removeMarket(market2);
                MarketOlusturma.Companion.getMarkets().removeIf(arg_0 -> AdminMenuEvent.onInventoryClick$lambda$1(arg_0 -> AdminMenuEvent.onInventoryClick$lambda$0(market2, arg_0), arg_0));
                ShopItemHolo.INSTANCE.removeHologram(market2.getChestLocation());
                player2.sendMessage(LangManager.INSTANCE.getMessage("market-removed"));
                player2.closeInventory();
                break;
            }
            case 2: {
                openAdminMenus.remove(player2.getUniqueId());
                PriceChangeManager.INSTANCE.requestPriceChange(player2, market2);
                break;
            }
            case 3: {
                openAdminMenus.remove(player2.getUniqueId());
                UUID uUID = player2.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                DescriptionManager.INSTANCE.requestDescription(uUID, market2);
                break;
            }
            case 4: 
            case 5: {
                openAdminMenus.remove(player2.getUniqueId());
                this.toggleMarketMode(player2, market2);
                TabelaUpdate.INSTANCE.update(market2);
                break;
            }
            case 6: {
                this.waitingForItemSelection.put(player2.getUniqueId(), market2);
                openAdminMenus.remove(player2.getUniqueId());
                player2.closeInventory();
                ChangeItemMenu.INSTANCE.openPlayerInventoryMenu(player2, market2);
                break;
            }
            default: {
                return;
            }
        }
    }

    private final void toggleMarketMode(Player player, Market market) {
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask((Plugin)BOBShop.Companion.getInstance(), () -> AdminMenuEvent.toggleMarketMode$lambda$0(this, player, market));
            return;
        }
        MarketMode before = market.getMode();
        market.setMode(before == MarketMode.BUY ? MarketMode.SELL : MarketMode.BUY);
        MarketDatabase.INSTANCE.saveOrUpdateMarket(market);
        TabelaUpdate.INSTANCE.update(market);
        ShopItemHolo.INSTANCE.spawnOrUpdateHologram(BOBShop.Companion.getInstance(), market.getChestLocation(), market.getItemStack(), market.getDescription());
        player.sendMessage(StringsKt.replace$default(LangManager.INSTANCE.getMessage("market-mode-changed"), "{mode}", MarketmodeKt.displayMode(market.getMode()), false, 4, null));
        player.closeInventory();
    }

    private static final boolean onInventoryClick$lambda$0(Market $market, Market it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getChestLocation(), $market.getChestLocation());
    }

    private static final boolean onInventoryClick$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void toggleMarketMode$lambda$0(AdminMenuEvent this$0, Player $player, Market $market) {
        this$0.toggleMarketMode($player, $market);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/bilolib/bobshop/adminmenu/AdminMenuEvent$Companion;", "", "<init>", "()V", "openAdminMenus", "", "Ljava/util/UUID;", "Lcom/bilolib/bobshop/market/Market;", "getOpenAdminMenus", "()Ljava/util/Map;", "BOBSHOP"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<UUID, Market> getOpenAdminMenus() {
            return openAdminMenus;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Material.values().length];
            try {
                nArray[Material.BARRIER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.NAME_TAG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.PAINTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.EMERALD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.REDSTONE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.BUNDLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

