/*
 * Decompiled with CFR 0.152.
 */
package com.bilolib.bobshop.eco;

import com.bilolib.bobshop.BOBShop;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001,B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\rJ\u001e\u0010!\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\rJ\u001e\u0010\"\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020#2\u0006\u0010 \u001a\u00020\rJ\u001e\u0010$\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020#2\u0006\u0010 \u001a\u00020\rJ\u0016\u0010%\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\rJ\u0016\u0010&\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\rJ\u0016\u0010'\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010(\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010+\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\rR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006-"}, d2={"Lcom/bilolib/bobshop/eco/EconomyBridge;", "", "<init>", "()V", "plugin", "Lcom/bilolib/bobshop/BOBShop;", "getPlugin", "()Lcom/bilolib/bobshop/BOBShop;", "eco", "Lnet/milkbowl/vault/economy/Economy;", "cfg", "Lcom/bilolib/bobshop/eco/EconomyBridge$Cfg;", "roundTo", "", "v", "digits", "", "clampAndRoundPrice", "raw", "format", "", "amount", "chargeCreationPrice", "", "p", "Lorg/bukkit/entity/Player;", "refundOnRemove", "", "permissionTaxFactor", "settleBuy", "buyer", "seller", "priceRaw", "settleSell", "settleBuyOffline", "Lorg/bukkit/OfflinePlayer;", "settleSellOffline", "settleAdminBuy", "settleAdminSell", "deposit", "withdraw", "depositPlayer", "withdrawPlayer", "has", "Cfg", "BOBSHOP"})
@SourceDebugExtension(value={"SMAP\nEconomyBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EconomyBridge.kt\ncom/bilolib/bobshop/eco/EconomyBridge\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,255:1\n1869#2,2:256\n216#3,2:258\n*S KotlinDebug\n*F\n+ 1 EconomyBridge.kt\ncom/bilolib/bobshop/eco/EconomyBridge\n*L\n52#1:256,2\n127#1:258,2\n*E\n"})
public final class EconomyBridge {
    @NotNull
    public static final EconomyBridge INSTANCE = new EconomyBridge();

    private EconomyBridge() {
    }

    private final BOBShop getPlugin() {
        return BOBShop.Companion.getInstance();
    }

    private final Economy eco() {
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
        return registeredServiceProvider != null ? (Economy)registeredServiceProvider.getProvider() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Cfg cfg() {
        Set set;
        String string;
        String[] stringArray;
        Object tag;
        Object parts;
        String string2;
        FileConfiguration fileConfiguration = this.getPlugin().getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        FileConfiguration c = fileConfiguration;
        EconomyBridge $this$cfg_u24lambda_u240 = this;
        boolean bl = false;
        String string3 = c.getString("economy.format.locale", "en_US");
        if (string3 == null) {
            string3 = "en_US";
        }
        if ((string2 = (String)CollectionsKt.getOrNull(parts = StringsKt.split$default((CharSequence)(tag = string3), stringArray = new String[]{"_"}, false, 0, 6, null), 0)) == null) {
            string2 = "en";
        }
        if ((string = (String)CollectionsKt.getOrNull(parts, 1)) == null) {
            string = "US";
        }
        Locale loc = new Locale(string2, string);
        Map permMap = new LinkedHashMap();
        $this$cfg_u24lambda_u240 = c.getConfigurationSection("economy.multipliers.tax_by_permission");
        if ($this$cfg_u24lambda_u240 != null && (set = $this$cfg_u24lambda_u240.getKeys(false)) != null) {
            void $this$forEach$iv;
            tag = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String key = (String)element$iv;
                boolean bl2 = false;
                permMap.put(key, c.getDouble("economy.multipliers.tax_by_permission." + key));
            }
        }
        double normalBuy = c.getDouble("economy.tax.buy_percent", 0.0);
        double normalSell = c.getDouble("economy.tax.sell_percent", 0.0);
        double adminBuy = c.getDouble("economy.admin_tax.buy_percent", normalBuy);
        double adminSell = c.getDouble("economy.admin_tax.sell_percent", normalSell);
        boolean bl3 = c.getBoolean("economy.enabled", true);
        double d = c.getDouble("economy.creation_price", 10.0);
        double d2 = c.getDouble("economy.remove_refund", 0.0);
        double d3 = c.getDouble("economy.price.min", 0.01);
        double d4 = c.getDouble("economy.price.max", 1000000.0);
        int n = c.getInt("economy.price.round", 2);
        boolean bl4 = c.getBoolean("economy.tax.sink_to_server", true);
        String string4 = c.getString("economy.format.currency_symbol", "$");
        if (string4 == null) {
            string4 = "$";
        }
        return new Cfg(bl3, d, d2, d3, d4, n, normalBuy, normalSell, bl4, string4, loc, permMap, c.getBoolean("economy.format.prefix", true), adminBuy, adminSell);
    }

    private final double roundTo(double v, int digits) {
        double p = Math.pow(10.0, digits);
        return Math.rint(v * p) / p;
    }

    public final double clampAndRoundPrice(double raw) {
        Cfg cf = this.cfg();
        double clamped = RangesKt.coerceIn(raw, cf.getMinPrice(), cf.getMaxPrice());
        return this.roundTo(clamped, cf.getRoundDigits());
    }

    @NotNull
    public final String format(double amount) {
        String string;
        NumberFormat numberFormat;
        Cfg cf = this.cfg();
        NumberFormat $this$format_u24lambda_u240 = numberFormat = NumberFormat.getNumberInstance(cf.getLocale());
        boolean bl = false;
        $this$format_u24lambda_u240.setMaximumFractionDigits(cf.getRoundDigits());
        $this$format_u24lambda_u240.setMinimumFractionDigits(cf.getRoundDigits());
        NumberFormat nf = numberFormat;
        String formatted = nf.format(amount);
        if (cf.getPrefix()) {
            var6_4 = ChatColor.translateAlternateColorCodes((char)'&', (String)(cf.getCurrencySymbol() + formatted));
            Intrinsics.checkNotNull(var6_4);
            string = var6_4;
        } else {
            var6_4 = ChatColor.translateAlternateColorCodes((char)'&', (String)(formatted + cf.getCurrencySymbol()));
            Intrinsics.checkNotNull(var6_4);
            string = var6_4;
        }
        return string;
    }

    public final boolean chargeCreationPrice(@NotNull Player p) {
        Intrinsics.checkNotNullParameter(p, "p");
        Cfg cf = this.cfg();
        if (!cf.getEnabled()) {
            return true;
        }
        if (cf.getCreationprice() <= 0.0) {
            return true;
        }
        Economy economy = this.eco();
        if (economy == null) {
            return false;
        }
        Economy e = economy;
        if (!e.has((OfflinePlayer)p, cf.getCreationprice())) {
            return false;
        }
        return e.withdrawPlayer((OfflinePlayer)p, cf.getCreationprice()).transactionSuccess();
    }

    public final void refundOnRemove(@NotNull Player p) {
        block2: {
            Intrinsics.checkNotNullParameter(p, "p");
            Cfg cf = this.cfg();
            if (!cf.getEnabled()) {
                return;
            }
            if (!(cf.getRemoveRefund() > 0.0)) break block2;
            Economy economy = this.eco();
            if (economy != null) {
                economy.depositPlayer((OfflinePlayer)p, cf.getRemoveRefund());
            }
        }
    }

    private final double permissionTaxFactor(Player p) {
        Map<String, Double> map = this.cfg().getPermTaxFactors();
        if (map.isEmpty()) {
            return 1.0;
        }
        double best = 0.0;
        best = 1.0;
        Map<String, Double> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Double>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Double> element$iv;
            Map.Entry<String, Double> entry = element$iv = iterator2.next();
            boolean bl = false;
            String perm = entry.getKey();
            double factor = ((Number)entry.getValue()).doubleValue();
            if (!p.hasPermission(perm)) continue;
            best = Math.min(best, factor);
        }
        return best;
    }

    public final boolean settleBuy(@NotNull Player buyer, @NotNull Player seller, double priceRaw) {
        Intrinsics.checkNotNullParameter(buyer, "buyer");
        Intrinsics.checkNotNullParameter(seller, "seller");
        Economy economy = this.eco();
        if (economy == null) {
            return false;
        }
        Economy e = economy;
        Cfg cf = this.cfg();
        double price = this.clampAndRoundPrice(priceRaw);
        if (!cf.getEnabled()) {
            return true;
        }
        if (!e.has((OfflinePlayer)buyer, price)) {
            return false;
        }
        double sellerTaxFactor = this.permissionTaxFactor(seller);
        double tax = this.roundTo(price * (cf.getBuyTax() / 100.0) * sellerTaxFactor, cf.getRoundDigits());
        if (!e.withdrawPlayer((OfflinePlayer)buyer, price).transactionSuccess()) {
            return false;
        }
        double sellerGain = RangesKt.coerceAtLeast(price - (cf.getSinkToServer() ? tax : 0.0), 0.0);
        e.depositPlayer((OfflinePlayer)seller, sellerGain);
        return true;
    }

    public final boolean settleSell(@NotNull Player buyer, @NotNull Player seller, double priceRaw) {
        Intrinsics.checkNotNullParameter(buyer, "buyer");
        Intrinsics.checkNotNullParameter(seller, "seller");
        Economy economy = this.eco();
        if (economy == null) {
            return false;
        }
        Economy e = economy;
        Cfg cf = this.cfg();
        double price = this.clampAndRoundPrice(priceRaw);
        if (!cf.getEnabled()) {
            return true;
        }
        if (!e.has((OfflinePlayer)buyer, price)) {
            return false;
        }
        double sellerTaxFactor = this.permissionTaxFactor(seller);
        double tax = this.roundTo(price * (cf.getSellTax() / 100.0) * sellerTaxFactor, cf.getRoundDigits());
        if (!e.withdrawPlayer((OfflinePlayer)buyer, price).transactionSuccess()) {
            return false;
        }
        double sellerGain = RangesKt.coerceAtLeast(price - (cf.getSinkToServer() ? tax : 0.0), 0.0);
        e.depositPlayer((OfflinePlayer)seller, sellerGain);
        return true;
    }

    public final boolean settleBuyOffline(@NotNull Player buyer, @NotNull OfflinePlayer seller, double priceRaw) {
        Intrinsics.checkNotNullParameter(buyer, "buyer");
        Intrinsics.checkNotNullParameter(seller, "seller");
        Economy economy = this.eco();
        if (economy == null) {
            return false;
        }
        Economy e = economy;
        Cfg cf = this.cfg();
        double price = this.clampAndRoundPrice(priceRaw);
        if (!cf.getEnabled()) {
            return true;
        }
        if (!e.has((OfflinePlayer)buyer, price)) {
            return false;
        }
        double tax = this.roundTo(price * (cf.getBuyTax() / 100.0), cf.getRoundDigits());
        EconomyResponse w = e.withdrawPlayer((OfflinePlayer)buyer, price);
        if (!w.transactionSuccess()) {
            return false;
        }
        double sellerGain = RangesKt.coerceAtLeast(price - (cf.getSinkToServer() ? tax : 0.0), 0.0);
        EconomyResponse d = e.depositPlayer(seller, sellerGain);
        if (!d.transactionSuccess()) {
            e.depositPlayer((OfflinePlayer)buyer, price);
            return false;
        }
        return true;
    }

    public final boolean settleSellOffline(@NotNull Player buyer, @NotNull OfflinePlayer seller, double priceRaw) {
        Intrinsics.checkNotNullParameter(buyer, "buyer");
        Intrinsics.checkNotNullParameter(seller, "seller");
        Economy economy = this.eco();
        if (economy == null) {
            return false;
        }
        Economy e = economy;
        Cfg cf = this.cfg();
        double price = this.clampAndRoundPrice(priceRaw);
        if (!cf.getEnabled()) {
            return true;
        }
        if (!e.has((OfflinePlayer)buyer, price)) {
            return false;
        }
        double tax = this.roundTo(price * (cf.getSellTax() / 100.0), cf.getRoundDigits());
        EconomyResponse w = e.withdrawPlayer((OfflinePlayer)buyer, price);
        if (!w.transactionSuccess()) {
            return false;
        }
        double sellerGain = RangesKt.coerceAtLeast(price - (cf.getSinkToServer() ? tax : 0.0), 0.0);
        EconomyResponse d = e.depositPlayer(seller, sellerGain);
        if (!d.transactionSuccess()) {
            e.depositPlayer((OfflinePlayer)buyer, price);
            return false;
        }
        return true;
    }

    public final boolean settleAdminBuy(@NotNull Player buyer, double priceRaw) {
        Intrinsics.checkNotNullParameter(buyer, "buyer");
        Economy economy = this.eco();
        if (economy == null) {
            return false;
        }
        Economy e = economy;
        Cfg cf = this.cfg();
        double price = this.clampAndRoundPrice(priceRaw);
        if (!cf.getEnabled()) {
            return true;
        }
        if (!e.has((OfflinePlayer)buyer, price)) {
            return false;
        }
        double tax = this.roundTo(price * (cf.getAdminBuyTax() / 100.0), cf.getRoundDigits());
        EconomyResponse w = e.withdrawPlayer((OfflinePlayer)buyer, price);
        return w.transactionSuccess();
    }

    public final boolean settleAdminSell(@NotNull Player seller, double priceRaw) {
        Intrinsics.checkNotNullParameter(seller, "seller");
        Economy economy = this.eco();
        if (economy == null) {
            return false;
        }
        Economy e = economy;
        Cfg cf = this.cfg();
        double price = this.clampAndRoundPrice(priceRaw);
        if (!cf.getEnabled()) {
            return true;
        }
        double tax = this.roundTo(price * (cf.getAdminSellTax() / 100.0), cf.getRoundDigits());
        double gain = RangesKt.coerceAtLeast(price - tax, 0.0);
        return e.depositPlayer((OfflinePlayer)seller, gain).transactionSuccess();
    }

    public final boolean deposit(@NotNull Player p, double amount) {
        Intrinsics.checkNotNullParameter(p, "p");
        Economy economy = this.eco();
        return economy != null && (economy = economy.depositPlayer((OfflinePlayer)p, amount)) != null ? economy.transactionSuccess() : false;
    }

    public final boolean withdraw(@NotNull Player p, double amount) {
        Intrinsics.checkNotNullParameter(p, "p");
        Economy economy = this.eco();
        return economy != null && (economy = economy.withdrawPlayer((OfflinePlayer)p, amount)) != null ? economy.transactionSuccess() : false;
    }

    public final boolean depositPlayer(@NotNull Player p, double amount) {
        Intrinsics.checkNotNullParameter(p, "p");
        return this.deposit(p, amount);
    }

    public final boolean withdrawPlayer(@NotNull Player p, double amount) {
        Intrinsics.checkNotNullParameter(p, "p");
        return this.withdraw(p, amount);
    }

    public final boolean has(@NotNull OfflinePlayer p, double amount) {
        Intrinsics.checkNotNullParameter(p, "p");
        Economy economy = this.eco();
        if (economy == null) {
            return false;
        }
        Economy e = economy;
        return e.has(p, this.clampAndRoundPrice(amount));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b/\b\u0082\b\u0018\u00002\u00020\u0001B\u008b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0003\u0012\u0006\u0010\u0015\u001a\u00020\u0005\u0012\u0006\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0017\u0010\u0018J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0005H\u00c6\u0003J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\t\u00101\u001a\u00020\u0005H\u00c6\u0003J\t\u00102\u001a\u00020\u0005H\u00c6\u0003J\t\u00103\u001a\u00020\nH\u00c6\u0003J\t\u00104\u001a\u00020\u0005H\u00c6\u0003J\t\u00105\u001a\u00020\u0005H\u00c6\u0003J\t\u00106\u001a\u00020\u0003H\u00c6\u0003J\t\u00107\u001a\u00020\u000fH\u00c6\u0003J\t\u00108\u001a\u00020\u0011H\u00c6\u0003J\u0015\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u0013H\u00c6\u0003J\t\u0010:\u001a\u00020\u0003H\u00c6\u0003J\t\u0010;\u001a\u00020\u0005H\u00c6\u0003J\t\u0010<\u001a\u00020\u0005H\u00c6\u0003J\u00ab\u0001\u0010=\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00032\b\b\u0002\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010>\u001a\u00020\u00032\b\u0010?\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010@\u001a\u00020\nH\u00d6\u0001J\t\u0010A\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001cR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001cR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001aR\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001cR\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001c\u00a8\u0006B"}, d2={"Lcom/bilolib/bobshop/eco/EconomyBridge$Cfg;", "", "enabled", "", "creationprice", "", "removeRefund", "minPrice", "maxPrice", "roundDigits", "", "buyTax", "sellTax", "sinkToServer", "currencySymbol", "", "locale", "Ljava/util/Locale;", "permTaxFactors", "", "prefix", "adminBuyTax", "adminSellTax", "<init>", "(ZDDDDIDDZLjava/lang/String;Ljava/util/Locale;Ljava/util/Map;ZDD)V", "getEnabled", "()Z", "getCreationprice", "()D", "getRemoveRefund", "getMinPrice", "getMaxPrice", "getRoundDigits", "()I", "getBuyTax", "getSellTax", "getSinkToServer", "getCurrencySymbol", "()Ljava/lang/String;", "getLocale", "()Ljava/util/Locale;", "getPermTaxFactors", "()Ljava/util/Map;", "getPrefix", "getAdminBuyTax", "getAdminSellTax", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "copy", "equals", "other", "hashCode", "toString", "BOBSHOP"})
    private static final class Cfg {
        private final boolean enabled;
        private final double creationprice;
        private final double removeRefund;
        private final double minPrice;
        private final double maxPrice;
        private final int roundDigits;
        private final double buyTax;
        private final double sellTax;
        private final boolean sinkToServer;
        @NotNull
        private final String currencySymbol;
        @NotNull
        private final Locale locale;
        @NotNull
        private final Map<String, Double> permTaxFactors;
        private final boolean prefix;
        private final double adminBuyTax;
        private final double adminSellTax;

        public Cfg(boolean enabled, double creationprice, double removeRefund, double minPrice, double maxPrice, int roundDigits, double buyTax, double sellTax, boolean sinkToServer, @NotNull String currencySymbol, @NotNull Locale locale, @NotNull Map<String, Double> permTaxFactors, boolean prefix, double adminBuyTax, double adminSellTax) {
            Intrinsics.checkNotNullParameter(currencySymbol, "currencySymbol");
            Intrinsics.checkNotNullParameter(locale, "locale");
            Intrinsics.checkNotNullParameter(permTaxFactors, "permTaxFactors");
            this.enabled = enabled;
            this.creationprice = creationprice;
            this.removeRefund = removeRefund;
            this.minPrice = minPrice;
            this.maxPrice = maxPrice;
            this.roundDigits = roundDigits;
            this.buyTax = buyTax;
            this.sellTax = sellTax;
            this.sinkToServer = sinkToServer;
            this.currencySymbol = currencySymbol;
            this.locale = locale;
            this.permTaxFactors = permTaxFactors;
            this.prefix = prefix;
            this.adminBuyTax = adminBuyTax;
            this.adminSellTax = adminSellTax;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final double getCreationprice() {
            return this.creationprice;
        }

        public final double getRemoveRefund() {
            return this.removeRefund;
        }

        public final double getMinPrice() {
            return this.minPrice;
        }

        public final double getMaxPrice() {
            return this.maxPrice;
        }

        public final int getRoundDigits() {
            return this.roundDigits;
        }

        public final double getBuyTax() {
            return this.buyTax;
        }

        public final double getSellTax() {
            return this.sellTax;
        }

        public final boolean getSinkToServer() {
            return this.sinkToServer;
        }

        @NotNull
        public final String getCurrencySymbol() {
            return this.currencySymbol;
        }

        @NotNull
        public final Locale getLocale() {
            return this.locale;
        }

        @NotNull
        public final Map<String, Double> getPermTaxFactors() {
            return this.permTaxFactors;
        }

        public final boolean getPrefix() {
            return this.prefix;
        }

        public final double getAdminBuyTax() {
            return this.adminBuyTax;
        }

        public final double getAdminSellTax() {
            return this.adminSellTax;
        }

        public final boolean component1() {
            return this.enabled;
        }

        public final double component2() {
            return this.creationprice;
        }

        public final double component3() {
            return this.removeRefund;
        }

        public final double component4() {
            return this.minPrice;
        }

        public final double component5() {
            return this.maxPrice;
        }

        public final int component6() {
            return this.roundDigits;
        }

        public final double component7() {
            return this.buyTax;
        }

        public final double component8() {
            return this.sellTax;
        }

        public final boolean component9() {
            return this.sinkToServer;
        }

        @NotNull
        public final String component10() {
            return this.currencySymbol;
        }

        @NotNull
        public final Locale component11() {
            return this.locale;
        }

        @NotNull
        public final Map<String, Double> component12() {
            return this.permTaxFactors;
        }

        public final boolean component13() {
            return this.prefix;
        }

        public final double component14() {
            return this.adminBuyTax;
        }

        public final double component15() {
            return this.adminSellTax;
        }

        @NotNull
        public final Cfg copy(boolean enabled, double creationprice, double removeRefund, double minPrice, double maxPrice, int roundDigits, double buyTax, double sellTax, boolean sinkToServer, @NotNull String currencySymbol, @NotNull Locale locale, @NotNull Map<String, Double> permTaxFactors, boolean prefix, double adminBuyTax, double adminSellTax) {
            Intrinsics.checkNotNullParameter(currencySymbol, "currencySymbol");
            Intrinsics.checkNotNullParameter(locale, "locale");
            Intrinsics.checkNotNullParameter(permTaxFactors, "permTaxFactors");
            return new Cfg(enabled, creationprice, removeRefund, minPrice, maxPrice, roundDigits, buyTax, sellTax, sinkToServer, currencySymbol, locale, permTaxFactors, prefix, adminBuyTax, adminSellTax);
        }

        public static /* synthetic */ Cfg copy$default(Cfg cfg, boolean bl, double d, double d2, double d3, double d4, int n, double d5, double d6, boolean bl2, String string, Locale locale, Map map, boolean bl3, double d7, double d8, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = cfg.enabled;
            }
            if ((n2 & 2) != 0) {
                d = cfg.creationprice;
            }
            if ((n2 & 4) != 0) {
                d2 = cfg.removeRefund;
            }
            if ((n2 & 8) != 0) {
                d3 = cfg.minPrice;
            }
            if ((n2 & 0x10) != 0) {
                d4 = cfg.maxPrice;
            }
            if ((n2 & 0x20) != 0) {
                n = cfg.roundDigits;
            }
            if ((n2 & 0x40) != 0) {
                d5 = cfg.buyTax;
            }
            if ((n2 & 0x80) != 0) {
                d6 = cfg.sellTax;
            }
            if ((n2 & 0x100) != 0) {
                bl2 = cfg.sinkToServer;
            }
            if ((n2 & 0x200) != 0) {
                string = cfg.currencySymbol;
            }
            if ((n2 & 0x400) != 0) {
                locale = cfg.locale;
            }
            if ((n2 & 0x800) != 0) {
                map = cfg.permTaxFactors;
            }
            if ((n2 & 0x1000) != 0) {
                bl3 = cfg.prefix;
            }
            if ((n2 & 0x2000) != 0) {
                d7 = cfg.adminBuyTax;
            }
            if ((n2 & 0x4000) != 0) {
                d8 = cfg.adminSellTax;
            }
            return cfg.copy(bl, d, d2, d3, d4, n, d5, d6, bl2, string, locale, map, bl3, d7, d8);
        }

        @NotNull
        public String toString() {
            return "Cfg(enabled=" + this.enabled + ", creationprice=" + this.creationprice + ", removeRefund=" + this.removeRefund + ", minPrice=" + this.minPrice + ", maxPrice=" + this.maxPrice + ", roundDigits=" + this.roundDigits + ", buyTax=" + this.buyTax + ", sellTax=" + this.sellTax + ", sinkToServer=" + this.sinkToServer + ", currencySymbol=" + this.currencySymbol + ", locale=" + this.locale + ", permTaxFactors=" + this.permTaxFactors + ", prefix=" + this.prefix + ", adminBuyTax=" + this.adminBuyTax + ", adminSellTax=" + this.adminSellTax + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.enabled);
            result = result * 31 + Double.hashCode(this.creationprice);
            result = result * 31 + Double.hashCode(this.removeRefund);
            result = result * 31 + Double.hashCode(this.minPrice);
            result = result * 31 + Double.hashCode(this.maxPrice);
            result = result * 31 + Integer.hashCode(this.roundDigits);
            result = result * 31 + Double.hashCode(this.buyTax);
            result = result * 31 + Double.hashCode(this.sellTax);
            result = result * 31 + Boolean.hashCode(this.sinkToServer);
            result = result * 31 + this.currencySymbol.hashCode();
            result = result * 31 + this.locale.hashCode();
            result = result * 31 + ((Object)this.permTaxFactors).hashCode();
            result = result * 31 + Boolean.hashCode(this.prefix);
            result = result * 31 + Double.hashCode(this.adminBuyTax);
            result = result * 31 + Double.hashCode(this.adminSellTax);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Cfg)) {
                return false;
            }
            Cfg cfg = (Cfg)other;
            if (this.enabled != cfg.enabled) {
                return false;
            }
            if (Double.compare(this.creationprice, cfg.creationprice) != 0) {
                return false;
            }
            if (Double.compare(this.removeRefund, cfg.removeRefund) != 0) {
                return false;
            }
            if (Double.compare(this.minPrice, cfg.minPrice) != 0) {
                return false;
            }
            if (Double.compare(this.maxPrice, cfg.maxPrice) != 0) {
                return false;
            }
            if (this.roundDigits != cfg.roundDigits) {
                return false;
            }
            if (Double.compare(this.buyTax, cfg.buyTax) != 0) {
                return false;
            }
            if (Double.compare(this.sellTax, cfg.sellTax) != 0) {
                return false;
            }
            if (this.sinkToServer != cfg.sinkToServer) {
                return false;
            }
            if (!Intrinsics.areEqual(this.currencySymbol, cfg.currencySymbol)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.locale, cfg.locale)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.permTaxFactors, cfg.permTaxFactors)) {
                return false;
            }
            if (this.prefix != cfg.prefix) {
                return false;
            }
            if (Double.compare(this.adminBuyTax, cfg.adminBuyTax) != 0) {
                return false;
            }
            return Double.compare(this.adminSellTax, cfg.adminSellTax) == 0;
        }
    }
}

