/*
 * Decompiled with CFR 0.152.
 */
package com.bilolib.bobshop.market;

import com.bilolib.bobshop.market.MarketDatabase;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0006\u0010\u0014\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/bilolib/bobshop/market/MarketBackupManager;", "", "<init>", "()V", "taskId", "", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "startAutoBackup", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "intervalMinutes", "", "backupNow", "doBackup", "cleanupOldBackups", "backupsDir", "Ljava/io/File;", "keep", "stop", "BOBSHOP"})
@SourceDebugExtension(value={"SMAP\nMarketBackupManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketBackupManager.kt\ncom/bilolib/bobshop/market/MarketBackupManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1#2:114\n3919#3:115\n4434#3,2:116\n1068#4:118\n1869#4,2:119\n*S KotlinDebug\n*F\n+ 1 MarketBackupManager.kt\ncom/bilolib/bobshop/market/MarketBackupManager\n*L\n95#1:115\n95#1:116,2\n96#1:118\n98#1:119,2\n*E\n"})
public final class MarketBackupManager {
    @NotNull
    public static final MarketBackupManager INSTANCE = new MarketBackupManager();
    private static int taskId = -1;
    @NotNull
    private static final AtomicBoolean running = new AtomicBoolean(false);

    private MarketBackupManager() {
    }

    public final void startAutoBackup(@NotNull JavaPlugin plugin, long intervalMinutes) {
        File file;
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        long minutes = RangesKt.coerceAtLeast(intervalMinutes, 1L);
        long initialDelay = 600L;
        long periodTicks = minutes * 60L * 20L;
        File $this$startAutoBackup_u24lambda_u240 = file = new File(plugin.getDataFolder(), "backups");
        boolean bl = false;
        if (!$this$startAutoBackup_u24lambda_u240.exists()) {
            $this$startAutoBackup_u24lambda_u240.mkdirs();
        }
        taskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> MarketBackupManager.startAutoBackup$lambda$1(plugin), initialDelay, periodTicks).getTaskId();
    }

    public final void backupNow(@NotNull JavaPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> MarketBackupManager.backupNow$lambda$0(plugin));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doBackup(JavaPlugin plugin) {
        if (!running.compareAndSet(false, true)) {
            plugin.getLogger().warning("Backup skipped: previous backup still running.");
            return;
        }
        try {
            Object $this$doBackup_u24lambda_u241;
            File file;
            File file2 = plugin.getDataFolder();
            Intrinsics.checkNotNullExpressionValue(file2, "getDataFolder(...)");
            File dataFolder = file2;
            File $this$doBackup_u24lambda_u240 = file = new File(dataFolder, "backups");
            boolean bl = false;
            if (!$this$doBackup_u24lambda_u240.exists()) {
                $this$doBackup_u24lambda_u240.mkdirs();
            }
            File backupsDir = file;
            String ts = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            File dbSrc = new File(new File(dataFolder, "data"), "shop.db");
            if (!dbSrc.exists()) {
                plugin.getLogger().warning("DB not found: " + dbSrc.getAbsolutePath());
                return;
            }
            File dbDst = new File(backupsDir, "shop-" + ts + ".db");
            Object object = this;
            try {
                $this$doBackup_u24lambda_u241 = object;
                boolean bl2 = false;
                MarketDatabase.INSTANCE.execRaw("PRAGMA wal_checkpoint(TRUNCATE);");
                $this$doBackup_u24lambda_u241 = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl2) {
                $this$doBackup_u24lambda_u241 = Result.constructor-impl(ResultKt.createFailure(bl2));
            }
            object = $this$doBackup_u24lambda_u241;
            Throwable throwable = Result.exceptionOrNull-impl(object);
            if (throwable != null) {
                Object it = $this$doBackup_u24lambda_u241 = throwable;
                boolean bl3 = false;
                plugin.getLogger().warning("wal_checkpoint failed: " + ((Throwable)it).getMessage());
            }
            String string = dbDst.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
            String dstPathSql = StringsKt.replace$default(string, "'", "''", false, 4, null);
            MarketDatabase.INSTANCE.execRaw("VACUUM INTO '" + dstPathSql + "';");
            int keep = RangesKt.coerceAtLeast(plugin.getConfig().getInt("backups.keep", 10), 1);
            this.cleanupOldBackups(backupsDir, keep);
            plugin.getLogger().info("Backup completed -> " + dbDst.getAbsolutePath());
        }
        finally {
            running.set(false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void cleanupOldBackups(File backupsDir, int keep) {
        block8: {
            block7: {
                v0 = backupsDir.listFiles();
                if (v0 == null) break block7;
                $this$filter$iv = v0;
                $i$f$filter = false;
                var8_7 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var12_12 = ((void)$this$filterTo$iv$iv).length;
                for (var11_10 = 0; var11_10 < var12_12; ++var11_10) {
                    it = element$iv$iv = $this$filterTo$iv$iv[var11_10];
                    $i$a$-filter-MarketBackupManager$cleanupOldBackups$files$1 = false;
                    if (!it.isFile()) ** GOTO lbl-1000
                    v1 = it.getName();
                    Intrinsics.checkNotNullExpressionValue(v1, "getName(...)");
                    if (StringsKt.endsWith(v1, ".db", true)) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (!v2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                break block8;
            }
            return;
        }
        files = (List)destination$iv$iv;
        $this$sortedByDescending$iv = files;
        $i$f$sortedByDescending = false;
        sorted = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.lastModified());
                it = (File)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.lastModified());
            }
        });
        if (sorted.size() <= keep) {
            return;
        }
        $this$forEach$iv = CollectionsKt.drop((Iterable)sorted, keep);
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            f = (File)element$iv;
            $i$a$-forEach-MarketBackupManager$cleanupOldBackups$1 = false;
            var11_11 = MarketBackupManager.INSTANCE;
            try {
                $this$cleanupOldBackups_u24lambda_u242_u240 = var11_11;
                $i$a$-runCatching-MarketBackupManager$cleanupOldBackups$1$1 = false;
                var12_13 = Result.constructor-impl(f.delete());
            }
            catch (Throwable $i$a$-runCatching-MarketBackupManager$cleanupOldBackups$1$1) {
                var12_13 = Result.constructor-impl(ResultKt.createFailure($i$a$-runCatching-MarketBackupManager$cleanupOldBackups$1$1));
            }
            var11_11 = var12_13;
            v3 = Result.exceptionOrNull-impl(var11_11);
            if (v3 == null) continue;
            it = var12_13 = v3;
            $i$a$-onFailure-MarketBackupManager$cleanupOldBackups$1$2 = false;
            Bukkit.getLogger().warning("Failed to delete old backup: " + f.getAbsolutePath());
        }
    }

    public final void stop() {
        if (taskId != -1) {
            Bukkit.getScheduler().cancelTask(taskId);
            taskId = -1;
        }
    }

    private static final void startAutoBackup$lambda$1(JavaPlugin $plugin) {
        block2: {
            Object object;
            Object object2 = INSTANCE;
            try {
                MarketBackupManager $this$startAutoBackup_u24lambda_u241_u240 = object2;
                boolean bl = false;
                $this$startAutoBackup_u24lambda_u241_u240.doBackup($plugin);
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            $plugin.getLogger().severe("Backup failed: " + ((Throwable)it).getMessage());
        }
    }

    private static final void backupNow$lambda$0(JavaPlugin $plugin) {
        block2: {
            Object object;
            Object object2 = INSTANCE;
            try {
                MarketBackupManager $this$backupNow_u24lambda_u240_u240 = object2;
                boolean bl = false;
                $this$backupNow_u24lambda_u240_u240.doBackup($plugin);
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            $plugin.getLogger().severe("Manual backup failed: " + ((Throwable)it).getMessage());
        }
    }
}

