/*
 * Decompiled with CFR 0.152.
 */
package com.bilolib.bobshop.market;

import com.bilolib.bobshop.market.Market;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\nJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\u0018\u001a\u00020\u0019R,\u0010\u0004\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/bilolib/bobshop/market/MarketChunkIndex;", "", "<init>", "()V", "byWorld", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "", "", "", "Lcom/bilolib/bobshop/market/Market;", "chunkKey", "cx", "", "cz", "rebuild", "", "markets", "", "add", "m", "remove", "get", "", "chunk", "Lorg/bukkit/Chunk;", "BOBSHOP"})
@SourceDebugExtension(value={"SMAP\nMarketChunkIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketChunkIndex.kt\ncom/bilolib/bobshop/market/MarketChunkIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1869#2,2:42\n*S KotlinDebug\n*F\n+ 1 MarketChunkIndex.kt\ncom/bilolib/bobshop/market/MarketChunkIndex\n*L\n15#1:42,2\n*E\n"})
public final class MarketChunkIndex {
    @NotNull
    public static final MarketChunkIndex INSTANCE = new MarketChunkIndex();
    @NotNull
    private static final ConcurrentHashMap<UUID, Map<Long, List<Market>>> byWorld = new ConcurrentHashMap();

    private MarketChunkIndex() {
    }

    private final long chunkKey(int cx, int cz) {
        return (long)cx << 32 ^ (long)cz & 0xFFFFFFFFL;
    }

    public final void rebuild(@NotNull Collection<Market> markets) {
        Intrinsics.checkNotNullParameter(markets, "markets");
        byWorld.clear();
        Iterable $this$forEach$iv = markets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Market it = (Market)element$iv;
            boolean bl = false;
            INSTANCE.add(it);
        }
    }

    public final void add(@NotNull Market m) {
        Intrinsics.checkNotNullParameter(m, "m");
        Location location = m.getChestLocation();
        if (location == null) {
            return;
        }
        Location loc = location;
        World world = loc.getWorld();
        if (world == null) {
            return;
        }
        World w = world;
        int cx = loc.getBlockX() >> 4;
        int cz = loc.getBlockZ() >> 4;
        Map map = byWorld.computeIfAbsent(w.getUID(), arg_0 -> MarketChunkIndex.add$lambda$1(MarketChunkIndex::add$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(map, "computeIfAbsent(...)");
        Map map2 = map;
        List list = map2.computeIfAbsent(this.chunkKey(cx, cz), arg_0 -> MarketChunkIndex.add$lambda$3(MarketChunkIndex::add$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue(list, "computeIfAbsent(...)");
        List list2 = list;
        list2.add(m);
    }

    public final void remove(@NotNull Market m) {
        block2: {
            Intrinsics.checkNotNullParameter(m, "m");
            Location location = m.getChestLocation();
            if (location == null) {
                return;
            }
            Location loc = location;
            World world = loc.getWorld();
            if (world == null) {
                return;
            }
            World w = world;
            int cx = loc.getBlockX() >> 4;
            int cz = loc.getBlockZ() >> 4;
            Map<Long, List<Market>> map = byWorld.get(w.getUID());
            if (map == null || (map = map.get(this.chunkKey(cx, cz))) == null) break block2;
            map.removeIf(arg_0 -> MarketChunkIndex.remove$lambda$1(arg_0 -> MarketChunkIndex.remove$lambda$0(m, arg_0), arg_0));
        }
    }

    @NotNull
    public final List<Market> get(@NotNull Chunk chunk) {
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        Map<Long, List<Market>> map = byWorld.get(chunk.getWorld().getUID());
        if (map == null) {
            return CollectionsKt.emptyList();
        }
        Map<Long, List<Market>> map2 = map;
        List<Market> list = map2.get(this.chunkKey(chunk.getX(), chunk.getZ()));
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Map add$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new HashMap();
    }

    private static final Map add$lambda$1(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final List add$lambda$2(Long it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ArrayList();
    }

    private static final List add$lambda$3(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final boolean remove$lambda$0(Market $m, Market it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getChestLocation(), $m.getChestLocation());
    }

    private static final boolean remove$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

