/*
 * Decompiled with CFR 0.152.
 */
package com.bilolib.bobshop.market;

import com.bilolib.bobshop.BOBShop;
import com.bilolib.bobshop.market.Market;
import com.bilolib.bobshop.market.MarketMode;
import com.bilolib.bobshop.market.MarketOlusturma;
import com.bilolib.bobshop.shopholo.ShopItemHolo;
import com.bilolib.libs.hikari.HikariConfig;
import com.bilolib.libs.hikari.HikariDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001<B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0018J(\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u0002H\u001d0\u001fH\u0082\b\u00a2\u0006\u0002\u0010!J-\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\b2\u001b\b\u0002\u0010$\u001a\u0015\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001f\u00a2\u0006\u0002\b&H\u0002JM\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u001d0(\"\u0004\b\u0000\u0010\u001d2\u0006\u0010#\u001a\u00020\b2\u001b\b\u0002\u0010$\u001a\u0015\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001f\u00a2\u0006\u0002\b&2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0002J\b\u0010+\u001a\u00020\u0018H\u0002J\u0010\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010.2\u0006\u00100\u001a\u00020\bH\u0002J\u000e\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u00020\tJ\u000e\u00103\u001a\u00020\u00182\u0006\u00102\u001a\u00020\tJ\f\u00104\u001a\b\u0012\u0004\u0012\u00020\t0(J\u0010\u00105\u001a\u0004\u0018\u00010\t2\u0006\u00106\u001a\u00020\u000fJ\u0006\u00107\u001a\u00020\u0018J\u0014\u00108\u001a\u00020\u00182\f\u00109\u001a\b\u0012\u0004\u0012\u00020\t0:J\u000e\u0010;\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006="}, d2={"Lcom/bilolib/bobshop/market/MarketDatabase;", "", "<init>", "()V", "ds", "Lcom/bilolib/libs/hikari/HikariDataSource;", "cache", "", "", "Lcom/bilolib/bobshop/market/Market;", "getCache", "()Ljava/util/Map;", "marketKey", "m", "loc", "Lorg/bukkit/Location;", "sameBlock", "", "a", "b", "parseMode", "Lcom/bilolib/bobshop/market/MarketMode;", "s", "connect", "", "dataFolder", "Ljava/io/File;", "disconnect", "withConn", "T", "block", "Lkotlin/Function1;", "Ljava/sql/Connection;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "exec", "sql", "binder", "Ljava/sql/PreparedStatement;", "Lkotlin/ExtensionFunctionType;", "query", "", "mapper", "Ljava/sql/ResultSet;", "createTable", "itemToBase64", "item", "Lorg/bukkit/inventory/ItemStack;", "itemFromBase64", "data", "saveOrUpdateMarket", "market", "removeMarket", "loadMarkets", "getMarket", "location", "saveMarketsSync", "saveAllSync", "markets", "", "execRaw", "DbRow", "BOBSHOP"})
@SourceDebugExtension(value={"SMAP\nMarketDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketDatabase.kt\ncom/bilolib/bobshop/market/MarketDatabase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,388:1\n87#1:390\n87#1:392\n87#1:397\n1#2:389\n1#2:391\n1#2:393\n1#2:398\n1761#3,3:394\n*S KotlinDebug\n*F\n+ 1 MarketDatabase.kt\ncom/bilolib/bobshop/market/MarketDatabase\n*L\n91#1:390\n104#1:392\n381#1:397\n91#1:391\n104#1:393\n381#1:398\n279#1:394,3\n*E\n"})
public final class MarketDatabase {
    @NotNull
    public static final MarketDatabase INSTANCE = new MarketDatabase();
    private static HikariDataSource ds;
    @NotNull
    private static final Map<String, Market> cache;

    private MarketDatabase() {
    }

    @NotNull
    public final Map<String, Market> getCache() {
        return cache;
    }

    private final String marketKey(Market m) {
        return m.getChestLocation().getWorld().getName() + ":" + m.getChestLocation().getBlockX() + ":" + m.getChestLocation().getBlockY() + ":" + m.getChestLocation().getBlockZ();
    }

    private final String marketKey(Location loc) {
        World world = loc.getWorld();
        return (world != null ? world.getName() : null) + ":" + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ();
    }

    private final boolean sameBlock(Location a, Location b) {
        World world = a.getWorld();
        World world2 = b.getWorld();
        return Intrinsics.areEqual(world != null ? world.getName() : null, world2 != null ? world2.getName() : null) && a.getBlockX() == b.getBlockX() && a.getBlockY() == b.getBlockY() && a.getBlockZ() == b.getBlockZ();
    }

    private final MarketMode parseMode(String s) {
        String string = s;
        if (string == null) {
            string = "BUY";
        }
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue(locale, "ENGLISH");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
        String raw = string3;
        return Intrinsics.areEqual(raw, "SELL") ? MarketMode.SELL : MarketMode.BUY;
    }

    public final void connect(@NotNull File dataFolder) {
        HikariConfig hikariConfig;
        File file;
        Intrinsics.checkNotNullParameter(dataFolder, "dataFolder");
        File $this$connect_u24lambda_u240 = file = new File(dataFolder, "data");
        boolean bl = false;
        if (!$this$connect_u24lambda_u240.exists()) {
            $this$connect_u24lambda_u240.mkdirs();
        }
        File dataDir = file;
        File dbFile = new File(dataDir, "shop.db");
        HikariConfig $this$connect_u24lambda_u241 = hikariConfig = new HikariConfig();
        boolean bl2 = false;
        $this$connect_u24lambda_u241.setJdbcUrl("jdbc:sqlite:" + dbFile.getAbsolutePath());
        $this$connect_u24lambda_u241.setMaximumPoolSize(4);
        $this$connect_u24lambda_u241.setPoolName("BOBShop-SQLite");
        $this$connect_u24lambda_u241.addDataSourceProperty("journalMode", "WAL");
        $this$connect_u24lambda_u241.addDataSourceProperty("busy_timeout", "3000");
        $this$connect_u24lambda_u241.addDataSourceProperty("foreign_keys", "on");
        HikariConfig cfg = hikariConfig;
        ds = new HikariDataSource(cfg);
        MarketDatabase.exec$default(this, "PRAGMA journal_mode = WAL;", null, 2, null);
        MarketDatabase.exec$default(this, "PRAGMA synchronous = NORMAL;", null, 2, null);
        MarketDatabase.exec$default(this, "PRAGMA foreign_keys = ON;", null, 2, null);
        this.createTable();
        BOBShop.Companion.getInstance().getLogger().info("SQLite/Hikari ba\u011flant\u0131s\u0131 haz\u0131r.");
    }

    public final void disconnect() {
        try {
            if (ds != null) {
                HikariDataSource hikariDataSource = ds;
                if (hikariDataSource == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("ds");
                    hikariDataSource = null;
                }
                hikariDataSource.close();
                BOBShop.Companion.getInstance().getLogger().info("DATABASE POOL CLOSED.");
            }
        }
        catch (Exception e) {
            BOBShop.Companion.getInstance().getLogger().severe("DATABASE CLOSE ERROR: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withConn(Function1<? super Connection, ? extends T> block) {
        T t;
        boolean $i$f$withConn = false;
        HikariDataSource hikariDataSource = ds;
        if (hikariDataSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ds");
            hikariDataSource = null;
        }
        AutoCloseable autoCloseable = hikariDataSource.getConnection();
        Throwable throwable = null;
        try {
            Connection c = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull(c);
            t = block.invoke(c);
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                InlineMarker.finallyStart(1);
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
                InlineMarker.finallyEnd(1);
                throw throwable3;
            }
        }
        InlineMarker.finallyStart(2);
        AutoCloseableKt.closeFinally(autoCloseable, throwable);
        InlineMarker.finallyEnd(2);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void exec(String sql, Function1<? super PreparedStatement, Unit> binder) {
        MarketDatabase this_$iv = this;
        boolean $i$f$withConn = false;
        HikariDataSource hikariDataSource = ds;
        if (hikariDataSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ds");
            hikariDataSource = null;
        }
        AutoCloseable autoCloseable = hikariDataSource.getConnection();
        Throwable throwable = null;
        try {
            boolean bl;
            Connection c$iv = (Connection)autoCloseable;
            boolean bl2 = false;
            Intrinsics.checkNotNull(c$iv);
            Connection c = c$iv;
            boolean bl3 = false;
            AutoCloseable autoCloseable2 = c.prepareStatement(sql);
            Throwable throwable2 = null;
            try {
                PreparedStatement ps = (PreparedStatement)autoCloseable2;
                boolean bl4 = false;
                Function1<? super PreparedStatement, Unit> function1 = binder;
                if (function1 != null) {
                    Intrinsics.checkNotNull(ps);
                    function1.invoke(ps);
                }
                bl = ps.execute();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            boolean bl5 = bl;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    static /* synthetic */ void exec$default(MarketDatabase marketDatabase, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        marketDatabase.exec(string, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> List<T> query(String sql, Function1<? super PreparedStatement, Unit> binder, Function1<? super ResultSet, ? extends T> mapper) {
        List list;
        MarketDatabase this_$iv = this;
        boolean $i$f$withConn = false;
        HikariDataSource hikariDataSource = ds;
        if (hikariDataSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ds");
            hikariDataSource = null;
        }
        AutoCloseable autoCloseable = hikariDataSource.getConnection();
        Throwable throwable = null;
        try {
            List list2;
            Connection c$iv = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull(c$iv);
            Connection c = c$iv;
            boolean bl2 = false;
            AutoCloseable autoCloseable2 = c.prepareStatement(sql);
            Throwable throwable2 = null;
            try {
                List list3;
                PreparedStatement ps = (PreparedStatement)autoCloseable2;
                boolean bl3 = false;
                Function1<? super PreparedStatement, Unit> function1 = binder;
                if (function1 != null) {
                    Intrinsics.checkNotNull(ps);
                    function1.invoke(ps);
                }
                AutoCloseable autoCloseable3 = ps.executeQuery();
                Throwable throwable3 = null;
                try {
                    ResultSet rs = (ResultSet)autoCloseable3;
                    boolean bl4 = false;
                    List out = new ArrayList();
                    while (rs.next()) {
                        Collection collection = out;
                        Intrinsics.checkNotNull(rs);
                        collection.add(mapper.invoke(rs));
                    }
                    list3 = out;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable3, throwable3);
                }
                list2 = list3;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            list = list2;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return list;
    }

    static /* synthetic */ List query$default(MarketDatabase marketDatabase, String string, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return marketDatabase.query(string, function1, function12);
    }

    private final void createTable() {
        MarketDatabase.exec$default(this, "CREATE TABLE IF NOT EXISTS markets(\n    owner TEXT NOT NULL,\n    chestX INTEGER NOT NULL,\n    chestY INTEGER NOT NULL,\n    chestZ INTEGER NOT NULL,\n    chestWorld TEXT NOT NULL,\n    signX INTEGER,\n    signY INTEGER,\n    signZ INTEGER,\n    signWorld TEXT,\n    item TEXT NOT NULL,\n    amount INTEGER NOT NULL,\n    price REAL NOT NULL,\n    mode TEXT DEFAULT 'BUY',\n    description TEXT DEFAULT '',\n    adminShop INTEGER DEFAULT 0,\n    PRIMARY KEY(owner, chestX, chestY, chestZ, chestWorld)\n);", null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String itemToBase64(ItemStack item) {
        String string;
        try {
            String string2;
            Closeable closeable = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                ByteArrayOutputStream byteOut = (ByteArrayOutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = (Closeable)new BukkitObjectOutputStream((OutputStream)byteOut);
                Throwable throwable2 = null;
                try {
                    BukkitObjectOutputStream out = (BukkitObjectOutputStream)closeable2;
                    boolean bl2 = false;
                    out.writeObject((Object)item);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                string2 = Base64.getEncoder().encodeToString(byteOut.toByteArray());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            string = string2;
            Intrinsics.checkNotNull(string);
        }
        catch (Exception ex) {
            BOBShop.Companion.getInstance().getLogger().severe("ItemStack kaydedilirken hata: " + ex.getMessage());
            string = "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ItemStack itemFromBase64(String data) {
        ItemStack itemStack;
        try {
            ItemStack itemStack2;
            byte[] bytes = Base64.getDecoder().decode(data);
            Closeable closeable = new ByteArrayInputStream(bytes);
            Throwable throwable = null;
            try {
                ItemStack itemStack3;
                ByteArrayInputStream byteIn = (ByteArrayInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = (Closeable)new BukkitObjectInputStream((InputStream)byteIn);
                Throwable throwable2 = null;
                try {
                    BukkitObjectInputStream inp = (BukkitObjectInputStream)closeable2;
                    boolean bl2 = false;
                    Object object = inp.readObject();
                    itemStack3 = object instanceof ItemStack ? (ItemStack)object : null;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                itemStack2 = itemStack3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            itemStack = itemStack2;
        }
        catch (Exception ex) {
            BOBShop.Companion.getInstance().getLogger().severe("ItemStack y\u00fcklenirken hata: " + ex.getMessage());
            itemStack = null;
        }
        return itemStack;
    }

    public final void saveOrUpdateMarket(@NotNull Market market) {
        Intrinsics.checkNotNullParameter(market, "market");
        cache.put(this.marketKey(market), market);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BOBShop.Companion.getInstance(), () -> MarketDatabase.saveOrUpdateMarket$lambda$0(market));
    }

    public final void removeMarket(@NotNull Market market) {
        Intrinsics.checkNotNullParameter(market, "market");
        Bukkit.getScheduler().runTask((Plugin)BOBShop.Companion.getInstance(), () -> MarketDatabase.removeMarket$lambda$0(market));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BOBShop.Companion.getInstance(), () -> MarketDatabase.removeMarket$lambda$1(market));
    }

    @NotNull
    public final List<Market> loadMarkets() {
        List rows = MarketDatabase.query$default(this, "SELECT * FROM markets", null, MarketDatabase::loadMarkets$lambda$0, 2, null);
        List list = new ArrayList();
        for (DbRow r : rows) {
            Location signLoc;
            String string;
            Location chestLoc;
            block12: {
                World worldChest;
                block11: {
                    Object it;
                    boolean bl;
                    block10: {
                        if (Bukkit.getWorld((String)r.getChestWorld()) == null) continue;
                        Intrinsics.checkNotNullExpressionValue(new Location(worldChest, (double)r.getChestX(), (double)r.getChestY(), (double)r.getChestZ()).toBlockLocation(), "toBlockLocation(...)");
                        Iterable $this$any$iv = MarketOlusturma.Companion.getMarkets();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (Market)element$iv;
                                boolean bl2 = false;
                                if (!INSTANCE.sameBlock(((Market)it).getChestLocation(), chestLoc)) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                    if (bl) continue;
                    string = r.getSignWorld();
                    if (string == null) break block11;
                    it = string;
                    boolean bl3 = false;
                    World world = Bukkit.getWorld((String)it);
                    string = world;
                    if (world != null) break block12;
                }
                string = worldChest;
            }
            String worldSign = string;
            Intrinsics.checkNotNullExpressionValue(new Location((World)worldSign, (double)r.getSignX(), (double)r.getSignY(), (double)r.getSignZ()).toBlockLocation(), "toBlockLocation(...)");
            UUID owner = UUID.fromString(r.getOwner());
            ItemStack itemStack = this.itemFromBase64(r.getItem());
            if (itemStack == null) {
                itemStack = new ItemStack(Material.STONE);
            }
            ItemStack itemStack2 = itemStack;
            MarketMode modeEnum = this.parseMode(r.getMode());
            Intrinsics.checkNotNull(owner);
            int n = r.getAmount();
            double d = r.getPrice();
            String string2 = r.getDescription();
            if (string2 == null) {
                string2 = "";
            }
            Market market = new Market(owner, chestLoc, signLoc, itemStack2, n, d, modeEnum, string2, r.getAdminShop(), false, 512, null);
            ((Collection)list).add(market);
            cache.put(this.marketKey(market), market);
            MarketOlusturma.Companion.getMarkets().add(market);
            ShopItemHolo.INSTANCE.spawnOrUpdateHologram(BOBShop.Companion.getInstance(), chestLoc, itemStack2, market.getDescription());
        }
        return list;
    }

    @Nullable
    public final Market getMarket(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return cache.get(this.marketKey(location));
    }

    public final void saveMarketsSync() {
    }

    public final void saveAllSync(@NotNull Iterable<Market> markets) {
        Intrinsics.checkNotNullParameter(markets, "markets");
        for (Market m : markets) {
            try {
                String sql = "INSERT INTO markets \n(owner, chestX, chestY, chestZ, chestWorld, signX, signY, signZ, signWorld, item, amount, price, mode, description, adminShop)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\nON CONFLICT(owner, chestX, chestY, chestZ, chestWorld) DO UPDATE SET\n    signX = excluded.signX,\n    signY = excluded.signY,\n    signZ = excluded.signZ,\n    signWorld = excluded.signWorld,\n    item = excluded.item,\n    amount = excluded.amount,\n    price = excluded.price,\n    mode = excluded.mode,\n    description = excluded.description,\n    adminShop = excluded.adminShop;";
                this.exec(sql, arg_0 -> MarketDatabase.saveAllSync$lambda$0(m, arg_0));
            }
            catch (Throwable t) {
                BOBShop.Companion.getInstance().getLogger().severe("Market sync save failed @ " + m.getChestLocation() + ": " + t.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execRaw(@NotNull String sql) {
        Intrinsics.checkNotNullParameter(sql, "sql");
        MarketDatabase this_$iv = this;
        boolean $i$f$withConn = false;
        HikariDataSource hikariDataSource = ds;
        if (hikariDataSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ds");
            hikariDataSource = null;
        }
        AutoCloseable autoCloseable = hikariDataSource.getConnection();
        Throwable throwable = null;
        try {
            boolean bl;
            Connection c$iv = (Connection)autoCloseable;
            boolean bl2 = false;
            Intrinsics.checkNotNull(c$iv);
            Connection c = c$iv;
            boolean bl3 = false;
            AutoCloseable autoCloseable2 = c.createStatement();
            Throwable throwable2 = null;
            try {
                Statement st = (Statement)autoCloseable2;
                boolean bl4 = false;
                bl = st.execute(sql);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            boolean bl5 = bl;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    private static final void saveOrUpdateMarket$lambda$0(Market $market) {
        String sql = "INSERT INTO markets \n(owner, chestX, chestY, chestZ, chestWorld, signX, signY, signZ, signWorld, item, amount, price, mode, description, adminShop)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\nON CONFLICT(owner, chestX, chestY, chestZ, chestWorld) DO UPDATE SET\n    signX = excluded.signX,\n    signY = excluded.signY,\n    signZ = excluded.signZ,\n    signWorld = excluded.signWorld,\n    item = excluded.item,\n    amount = excluded.amount,\n    price = excluded.price,\n    mode = excluded.mode,\n    description = excluded.description,\n    adminShop = excluded.adminShop;";
        INSTANCE.exec(sql, arg_0 -> MarketDatabase.saveOrUpdateMarket$lambda$0$0($market, arg_0));
    }

    private static final Unit saveOrUpdateMarket$lambda$0$0(Market $market, PreparedStatement $this$exec) {
        Intrinsics.checkNotNullParameter($this$exec, "$this$exec");
        $this$exec.setString(1, $market.getOwner().toString());
        $this$exec.setInt(2, $market.getChestLocation().getBlockX());
        $this$exec.setInt(3, $market.getChestLocation().getBlockY());
        $this$exec.setInt(4, $market.getChestLocation().getBlockZ());
        $this$exec.setString(5, $market.getChestLocation().getWorld().getName());
        $this$exec.setInt(6, $market.getSignLocation().getBlockX());
        $this$exec.setInt(7, $market.getSignLocation().getBlockY());
        $this$exec.setInt(8, $market.getSignLocation().getBlockZ());
        $this$exec.setString(9, $market.getSignLocation().getWorld().getName());
        $this$exec.setString(10, INSTANCE.itemToBase64($market.getItemStack()));
        $this$exec.setInt(11, $market.getAmount());
        $this$exec.setDouble(12, $market.getPrice());
        $this$exec.setString(13, $market.getMode().name());
        String string = $market.getDescription();
        if (string == null) {
            string = "";
        }
        $this$exec.setString(14, string);
        $this$exec.setInt(15, $market.getAdminShop() ? 1 : 0);
        return Unit.INSTANCE;
    }

    private static final void removeMarket$lambda$0(Market $market) {
        cache.remove(INSTANCE.marketKey($market));
        MarketOlusturma.Companion.getMarkets().removeIf(arg_0 -> MarketDatabase.removeMarket$lambda$0$1(arg_0 -> MarketDatabase.removeMarket$lambda$0$0($market, arg_0), arg_0));
        ShopItemHolo.INSTANCE.removeHologram($market.getChestLocation());
        Block block = $market.getSignLocation().getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block sb = block;
        if (StringsKt.endsWith$default(sb.getType().name(), "_SIGN", false, 2, null)) {
            sb.setType(Material.AIR);
        }
    }

    private static final boolean removeMarket$lambda$0$0(Market $market, Market it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.sameBlock(it.getChestLocation(), $market.getChestLocation());
    }

    private static final boolean removeMarket$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void removeMarket$lambda$1(Market $market) {
        String sql = "DELETE FROM markets\nWHERE owner = ? AND chestX = ? AND chestY = ? AND chestZ = ? AND chestWorld = ?";
        INSTANCE.exec(sql, arg_0 -> MarketDatabase.removeMarket$lambda$1$0($market, arg_0));
    }

    private static final Unit removeMarket$lambda$1$0(Market $market, PreparedStatement $this$exec) {
        Intrinsics.checkNotNullParameter($this$exec, "$this$exec");
        $this$exec.setString(1, $market.getOwner().toString());
        $this$exec.setInt(2, $market.getChestLocation().getBlockX());
        $this$exec.setInt(3, $market.getChestLocation().getBlockY());
        $this$exec.setInt(4, $market.getChestLocation().getBlockZ());
        $this$exec.setString(5, $market.getChestLocation().getWorld().getName());
        return Unit.INSTANCE;
    }

    private static final DbRow loadMarkets$lambda$0(ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        String string = rs.getString("owner");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = rs.getString("chestWorld");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        int n = rs.getInt("chestX");
        int n2 = rs.getInt("chestY");
        int n3 = rs.getInt("chestZ");
        String string3 = rs.getString("signWorld");
        int n4 = rs.getInt("signX");
        int n5 = rs.getInt("signY");
        int n6 = rs.getInt("signZ");
        String string4 = rs.getString("item");
        Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
        return new DbRow(string, string2, n, n2, n3, string3, n4, n5, n6, string4, rs.getInt("amount"), rs.getDouble("price"), rs.getString("mode"), rs.getString("description"), rs.getInt("adminShop") == 1);
    }

    private static final Unit saveAllSync$lambda$0(Market $m, PreparedStatement $this$exec) {
        Intrinsics.checkNotNullParameter($this$exec, "$this$exec");
        $this$exec.setString(1, $m.getOwner().toString());
        $this$exec.setInt(2, $m.getChestLocation().getBlockX());
        $this$exec.setInt(3, $m.getChestLocation().getBlockY());
        $this$exec.setInt(4, $m.getChestLocation().getBlockZ());
        $this$exec.setString(5, $m.getChestLocation().getWorld().getName());
        $this$exec.setInt(6, $m.getSignLocation().getBlockX());
        $this$exec.setInt(7, $m.getSignLocation().getBlockY());
        $this$exec.setInt(8, $m.getSignLocation().getBlockZ());
        $this$exec.setString(9, $m.getSignLocation().getWorld().getName());
        $this$exec.setString(10, INSTANCE.itemToBase64($m.getItemStack()));
        $this$exec.setInt(11, $m.getAmount());
        $this$exec.setDouble(12, $m.getPrice());
        $this$exec.setString(13, $m.getMode().name());
        String string = $m.getDescription();
        if (string == null) {
            string = "";
        }
        $this$exec.setString(14, string);
        $this$exec.setInt(15, $m.getAdminShop() ? 1 : 0);
        return Unit.INSTANCE;
    }

    static {
        cache = new LinkedHashMap();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b*\b\u0082\b\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0006H\u00c6\u0003J\t\u0010-\u001a\u00020\u0006H\u00c6\u0003J\t\u0010.\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010/\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0006H\u00c6\u0003J\t\u00101\u001a\u00020\u0006H\u00c6\u0003J\t\u00102\u001a\u00020\u0006H\u00c6\u0003J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0006H\u00c6\u0003J\t\u00105\u001a\u00020\u0010H\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u00107\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u00108\u001a\u00020\u0014H\u00c6\u0003J\u00a5\u0001\u00109\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u00c6\u0001J\u0013\u0010:\u001a\u00020\u00142\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010<\u001a\u00020\u0006H\u00d6\u0001J\t\u0010=\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001bR\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001bR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0018R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0018R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006>"}, d2={"Lcom/bilolib/bobshop/market/MarketDatabase$DbRow;", "", "owner", "", "chestWorld", "chestX", "", "chestY", "chestZ", "signWorld", "signX", "signY", "signZ", "item", "amount", "price", "", "mode", "description", "adminShop", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;IIILjava/lang/String;IIILjava/lang/String;IDLjava/lang/String;Ljava/lang/String;Z)V", "getOwner", "()Ljava/lang/String;", "getChestWorld", "getChestX", "()I", "getChestY", "getChestZ", "getSignWorld", "getSignX", "getSignY", "getSignZ", "getItem", "getAmount", "getPrice", "()D", "getMode", "getDescription", "getAdminShop", "()Z", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "copy", "equals", "other", "hashCode", "toString", "BOBSHOP"})
    private static final class DbRow {
        @NotNull
        private final String owner;
        @NotNull
        private final String chestWorld;
        private final int chestX;
        private final int chestY;
        private final int chestZ;
        @Nullable
        private final String signWorld;
        private final int signX;
        private final int signY;
        private final int signZ;
        @NotNull
        private final String item;
        private final int amount;
        private final double price;
        @Nullable
        private final String mode;
        @Nullable
        private final String description;
        private final boolean adminShop;

        public DbRow(@NotNull String owner, @NotNull String chestWorld, int chestX, int chestY, int chestZ, @Nullable String signWorld, int signX, int signY, int signZ, @NotNull String item, int amount, double price, @Nullable String mode, @Nullable String description, boolean adminShop) {
            Intrinsics.checkNotNullParameter(owner, "owner");
            Intrinsics.checkNotNullParameter(chestWorld, "chestWorld");
            Intrinsics.checkNotNullParameter(item, "item");
            this.owner = owner;
            this.chestWorld = chestWorld;
            this.chestX = chestX;
            this.chestY = chestY;
            this.chestZ = chestZ;
            this.signWorld = signWorld;
            this.signX = signX;
            this.signY = signY;
            this.signZ = signZ;
            this.item = item;
            this.amount = amount;
            this.price = price;
            this.mode = mode;
            this.description = description;
            this.adminShop = adminShop;
        }

        @NotNull
        public final String getOwner() {
            return this.owner;
        }

        @NotNull
        public final String getChestWorld() {
            return this.chestWorld;
        }

        public final int getChestX() {
            return this.chestX;
        }

        public final int getChestY() {
            return this.chestY;
        }

        public final int getChestZ() {
            return this.chestZ;
        }

        @Nullable
        public final String getSignWorld() {
            return this.signWorld;
        }

        public final int getSignX() {
            return this.signX;
        }

        public final int getSignY() {
            return this.signY;
        }

        public final int getSignZ() {
            return this.signZ;
        }

        @NotNull
        public final String getItem() {
            return this.item;
        }

        public final int getAmount() {
            return this.amount;
        }

        public final double getPrice() {
            return this.price;
        }

        @Nullable
        public final String getMode() {
            return this.mode;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final boolean getAdminShop() {
            return this.adminShop;
        }

        @NotNull
        public final String component1() {
            return this.owner;
        }

        @NotNull
        public final String component2() {
            return this.chestWorld;
        }

        public final int component3() {
            return this.chestX;
        }

        public final int component4() {
            return this.chestY;
        }

        public final int component5() {
            return this.chestZ;
        }

        @Nullable
        public final String component6() {
            return this.signWorld;
        }

        public final int component7() {
            return this.signX;
        }

        public final int component8() {
            return this.signY;
        }

        public final int component9() {
            return this.signZ;
        }

        @NotNull
        public final String component10() {
            return this.item;
        }

        public final int component11() {
            return this.amount;
        }

        public final double component12() {
            return this.price;
        }

        @Nullable
        public final String component13() {
            return this.mode;
        }

        @Nullable
        public final String component14() {
            return this.description;
        }

        public final boolean component15() {
            return this.adminShop;
        }

        @NotNull
        public final DbRow copy(@NotNull String owner, @NotNull String chestWorld, int chestX, int chestY, int chestZ, @Nullable String signWorld, int signX, int signY, int signZ, @NotNull String item, int amount, double price, @Nullable String mode, @Nullable String description, boolean adminShop) {
            Intrinsics.checkNotNullParameter(owner, "owner");
            Intrinsics.checkNotNullParameter(chestWorld, "chestWorld");
            Intrinsics.checkNotNullParameter(item, "item");
            return new DbRow(owner, chestWorld, chestX, chestY, chestZ, signWorld, signX, signY, signZ, item, amount, price, mode, description, adminShop);
        }

        public static /* synthetic */ DbRow copy$default(DbRow dbRow, String string, String string2, int n, int n2, int n3, String string3, int n4, int n5, int n6, String string4, int n7, double d, String string5, String string6, boolean bl, int n8, Object object) {
            if ((n8 & 1) != 0) {
                string = dbRow.owner;
            }
            if ((n8 & 2) != 0) {
                string2 = dbRow.chestWorld;
            }
            if ((n8 & 4) != 0) {
                n = dbRow.chestX;
            }
            if ((n8 & 8) != 0) {
                n2 = dbRow.chestY;
            }
            if ((n8 & 0x10) != 0) {
                n3 = dbRow.chestZ;
            }
            if ((n8 & 0x20) != 0) {
                string3 = dbRow.signWorld;
            }
            if ((n8 & 0x40) != 0) {
                n4 = dbRow.signX;
            }
            if ((n8 & 0x80) != 0) {
                n5 = dbRow.signY;
            }
            if ((n8 & 0x100) != 0) {
                n6 = dbRow.signZ;
            }
            if ((n8 & 0x200) != 0) {
                string4 = dbRow.item;
            }
            if ((n8 & 0x400) != 0) {
                n7 = dbRow.amount;
            }
            if ((n8 & 0x800) != 0) {
                d = dbRow.price;
            }
            if ((n8 & 0x1000) != 0) {
                string5 = dbRow.mode;
            }
            if ((n8 & 0x2000) != 0) {
                string6 = dbRow.description;
            }
            if ((n8 & 0x4000) != 0) {
                bl = dbRow.adminShop;
            }
            return dbRow.copy(string, string2, n, n2, n3, string3, n4, n5, n6, string4, n7, d, string5, string6, bl);
        }

        @NotNull
        public String toString() {
            return "DbRow(owner=" + this.owner + ", chestWorld=" + this.chestWorld + ", chestX=" + this.chestX + ", chestY=" + this.chestY + ", chestZ=" + this.chestZ + ", signWorld=" + this.signWorld + ", signX=" + this.signX + ", signY=" + this.signY + ", signZ=" + this.signZ + ", item=" + this.item + ", amount=" + this.amount + ", price=" + this.price + ", mode=" + this.mode + ", description=" + this.description + ", adminShop=" + this.adminShop + ")";
        }

        public int hashCode() {
            int result = this.owner.hashCode();
            result = result * 31 + this.chestWorld.hashCode();
            result = result * 31 + Integer.hashCode(this.chestX);
            result = result * 31 + Integer.hashCode(this.chestY);
            result = result * 31 + Integer.hashCode(this.chestZ);
            result = result * 31 + (this.signWorld == null ? 0 : this.signWorld.hashCode());
            result = result * 31 + Integer.hashCode(this.signX);
            result = result * 31 + Integer.hashCode(this.signY);
            result = result * 31 + Integer.hashCode(this.signZ);
            result = result * 31 + this.item.hashCode();
            result = result * 31 + Integer.hashCode(this.amount);
            result = result * 31 + Double.hashCode(this.price);
            result = result * 31 + (this.mode == null ? 0 : this.mode.hashCode());
            result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
            result = result * 31 + Boolean.hashCode(this.adminShop);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DbRow)) {
                return false;
            }
            DbRow dbRow = (DbRow)other;
            if (!Intrinsics.areEqual(this.owner, dbRow.owner)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.chestWorld, dbRow.chestWorld)) {
                return false;
            }
            if (this.chestX != dbRow.chestX) {
                return false;
            }
            if (this.chestY != dbRow.chestY) {
                return false;
            }
            if (this.chestZ != dbRow.chestZ) {
                return false;
            }
            if (!Intrinsics.areEqual(this.signWorld, dbRow.signWorld)) {
                return false;
            }
            if (this.signX != dbRow.signX) {
                return false;
            }
            if (this.signY != dbRow.signY) {
                return false;
            }
            if (this.signZ != dbRow.signZ) {
                return false;
            }
            if (!Intrinsics.areEqual(this.item, dbRow.item)) {
                return false;
            }
            if (this.amount != dbRow.amount) {
                return false;
            }
            if (Double.compare(this.price, dbRow.price) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual(this.mode, dbRow.mode)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.description, dbRow.description)) {
                return false;
            }
            return this.adminShop == dbRow.adminShop;
        }
    }
}

