/*
 * Decompiled with CFR 0.152.
 */
package com.bilolib.bobshop.market;

import com.bilolib.bobshop.market.Market;
import com.bilolib.bobshop.market.MarketOlusturma;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Barrel;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Hopper;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0015H\u0007\u00a8\u0006\u0016"}, d2={"Lcom/bilolib/bobshop/market/MarketHopperGuard;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onInventoryMove", "", "e", "Lorg/bukkit/event/inventory/InventoryMoveItemEvent;", "invTouchesAnyMarket", "", "inv", "Lorg/bukkit/inventory/Inventory;", "holderLocations", "", "Lorg/bukkit/Location;", "holder", "Lorg/bukkit/inventory/InventoryHolder;", "sameBlock", "a", "b", "onHopperPlace", "Lorg/bukkit/event/block/BlockPlaceEvent;", "BOBSHOP"})
@SourceDebugExtension(value={"SMAP\nMarketHopperGuard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketHopperGuard.kt\ncom/bilolib/bobshop/market/MarketHopperGuard\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1761#2,2:92\n1761#2,3:94\n1763#2:97\n1761#2,2:98\n1761#2,3:100\n1763#2:103\n*S KotlinDebug\n*F\n+ 1 MarketHopperGuard.kt\ncom/bilolib/bobshop/market/MarketHopperGuard\n*L\n39#1:92,2\n40#1:94,3\n39#1:97\n78#1:98,2\n79#1:100,3\n78#1:103\n*E\n"})
public final class MarketHopperGuard
implements Listener {
    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onInventoryMove(@NotNull InventoryMoveItemEvent e) {
        block5: {
            block4: {
                boolean hopperInitiated;
                InventoryHolder initiator;
                Intrinsics.checkNotNullParameter(e, "e");
                Inventory inventory = e.getInitiator();
                InventoryHolder inventoryHolder = initiator = inventory != null ? inventory.getHolder() : null;
                boolean bl = inventoryHolder instanceof Hopper ? true : (hopperInitiated = inventoryHolder instanceof HopperMinecart);
                if (!hopperInitiated) {
                    return;
                }
                Inventory inventory2 = e.getSource();
                Intrinsics.checkNotNullExpressionValue(inventory2, "getSource(...)");
                if (this.invTouchesAnyMarket(inventory2)) break block4;
                Inventory inventory3 = e.getDestination();
                Intrinsics.checkNotNullExpressionValue(inventory3, "getDestination(...)");
                if (!this.invTouchesAnyMarket(inventory3)) break block5;
            }
            e.setCancelled(true);
        }
    }

    private final boolean invTouchesAnyMarket(Inventory inv) {
        boolean bl;
        block8: {
            List<Location> list = this.holderLocations(inv.getHolder());
            if (list == null) {
                return false;
            }
            List<Location> invLocs = list;
            Iterable $this$any$iv = MarketOlusturma.Companion.getMarkets();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block7: {
                        Market m = (Market)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = invLocs;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                Location it = (Location)element$iv2;
                                boolean bl4 = false;
                                if (!this.sameBlock(it, m.getChestLocation())) continue;
                                bl2 = true;
                                break block7;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<Location> holderLocations(InventoryHolder holder) {
        List<Object> list;
        InventoryHolder inventoryHolder = holder;
        if (inventoryHolder instanceof Chest) {
            list = CollectionsKt.listOf(((Chest)holder).getLocation());
        } else if (inventoryHolder instanceof DoubleChest) {
            Location[] locationArray = ((DoubleChest)holder).getLeftSide();
            Chest chest = locationArray instanceof Chest ? (Chest)locationArray : null;
            Location left = chest != null ? chest.getLocation() : null;
            InventoryHolder inventoryHolder2 = ((DoubleChest)holder).getRightSide();
            Chest chest2 = inventoryHolder2 instanceof Chest ? (Chest)inventoryHolder2 : null;
            Location right = chest2 != null ? chest2.getLocation() : null;
            locationArray = new Location[]{left, right};
            list = CollectionsKt.listOfNotNull(locationArray);
        } else {
            list = inventoryHolder instanceof Barrel ? CollectionsKt.listOf(((Barrel)holder).getLocation()) : (inventoryHolder instanceof Hopper ? CollectionsKt.listOf(((Hopper)holder).getLocation()) : (inventoryHolder instanceof HopperMinecart ? CollectionsKt.listOf(((HopperMinecart)holder).getLocation()) : null));
        }
        return list;
    }

    private final boolean sameBlock(Location a, Location b) {
        return Intrinsics.areEqual(a.getWorld(), b.getWorld()) && a.getBlockX() == b.getBlockX() && a.getBlockY() == b.getBlockY() && a.getBlockZ() == b.getBlockZ();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onHopperPlace(@NotNull BlockPlaceEvent e) {
        boolean touchingMarket;
        block10: {
            Intrinsics.checkNotNullParameter(e, "e");
            if (e.getBlockPlaced().getType() != Material.HOPPER) {
                return;
            }
            Location location = e.getBlockPlaced().getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            Location placed = location;
            World world = placed.getWorld();
            if (world == null) {
                return;
            }
            World world2 = world;
            Location[] locationArray = new Location[]{placed.clone().add(0.0, 1.0, 0.0), placed.clone().add(0.0, -1.0, 0.0), placed.clone().add(1.0, 0.0, 0.0), placed.clone().add(-1.0, 0.0, 0.0), placed.clone().add(0.0, 0.0, 1.0), placed.clone().add(0.0, 0.0, -1.0)};
            List<Location> neighbors = CollectionsKt.listOf(locationArray);
            Iterable $this$any$iv = neighbors;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl;
                    block9: {
                        Location n = (Location)element$iv;
                        boolean bl2 = false;
                        Iterable $this$any$iv2 = MarketOlusturma.Companion.getMarkets();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                Market m = (Market)element$iv2;
                                boolean bl3 = false;
                                if (!(Intrinsics.areEqual(m.getChestLocation().getWorld(), world2) && m.getChestLocation().getBlockX() == n.getBlockX() && m.getChestLocation().getBlockY() == n.getBlockY() && m.getChestLocation().getBlockZ() == n.getBlockZ())) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    v2 = true;
                    break block10;
                }
                v2 = touchingMarket = false;
            }
        }
        if (touchingMarket) {
            e.setCancelled(true);
        }
    }
}

