/*
 * Decompiled with CFR 0.152.
 */
package com.bilolib.bobshop.market;

import com.bilolib.bobshop.BOBShop;
import com.bilolib.bobshop.manager.LangManager;
import com.bilolib.bobshop.market.Market;
import com.bilolib.bobshop.market.MarketOlusturma;
import com.bilolib.bobshop.tabela.TabelaUpdate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Barrel;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/bilolib/bobshop/market/MarketInventoryListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "pending", "", "Lorg/bukkit/Location;", "Lorg/bukkit/scheduler/BukkitTask;", "onInventoryClose", "", "e", "Lorg/bukkit/event/inventory/InventoryCloseEvent;", "containerBlockLocations", "", "inv", "Lorg/bukkit/inventory/Inventory;", "computeTotalSimilar", "", "proto", "Lorg/bukkit/inventory/ItemStack;", "isSameItem", "", "a", "b", "updateMarketsForContainer", "containerLoc", "BOBSHOP"})
@SourceDebugExtension(value={"SMAP\nMarketInventoryListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketInventoryListener.kt\ncom/bilolib/bobshop/market/MarketInventoryListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1869#2,2:122\n774#2:125\n865#2,2:126\n1#3:124\n*S KotlinDebug\n*F\n+ 1 MarketInventoryListener.kt\ncom/bilolib/bobshop/market/MarketInventoryListener\n*L\n31#1:122,2\n87#1:125\n87#1:126,2\n*E\n"})
public final class MarketInventoryListener
implements Listener {
    @NotNull
    private final Map<Location, BukkitTask> pending = new ConcurrentHashMap();

    @EventHandler
    public final void onInventoryClose(@NotNull InventoryCloseEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Inventory inventory = e.getInventory();
        if (inventory == null) {
            return;
        }
        Inventory inv = inventory;
        List<Location> blockLocs = this.containerBlockLocations(inv);
        if (blockLocs.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = blockLocs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BukkitTask task2;
            Location loc = (Location)element$iv;
            boolean bl = false;
            BukkitTask bukkitTask = this.pending.remove(loc);
            if (bukkitTask != null) {
                bukkitTask.cancel();
            }
            Intrinsics.checkNotNullExpressionValue(Bukkit.getScheduler().runTaskLater((Plugin)BOBShop.Companion.getInstance(), () -> MarketInventoryListener.onInventoryClose$lambda$0$0(this, inv, loc), 2L), "runTaskLater(...)");
            this.pending.put(loc, task2);
        }
    }

    private final List<Location> containerBlockLocations(Inventory inv) {
        Object object;
        block5: {
            block8: {
                block7: {
                    InventoryHolder inventoryHolder;
                    InventoryHolder holder;
                    block6: {
                        block4: {
                            InventoryHolder inventoryHolder2 = inv.getHolder();
                            if (inventoryHolder2 == null) {
                                return CollectionsKt.emptyList();
                            }
                            holder = inventoryHolder2;
                            inventoryHolder = holder;
                            if (!(inventoryHolder instanceof DoubleChest)) break block4;
                            Location[] locationArray = ((DoubleChest)holder).getLeftSide();
                            Chest chest = locationArray instanceof Chest ? (Chest)locationArray : null;
                            Location left = chest != null ? chest.getLocation() : null;
                            InventoryHolder inventoryHolder3 = ((DoubleChest)holder).getRightSide();
                            Chest chest2 = inventoryHolder3 instanceof Chest ? (Chest)inventoryHolder3 : null;
                            Location right = chest2 != null ? chest2.getLocation() : null;
                            locationArray = new Location[]{left, right};
                            object = CollectionsKt.listOfNotNull(locationArray);
                            break block5;
                        }
                        if (!(inventoryHolder instanceof Chest)) break block6;
                        object = CollectionsKt.listOf(((Chest)holder).getLocation());
                        break block5;
                    }
                    if (!(inventoryHolder instanceof Barrel)) break block7;
                    object = CollectionsKt.listOf(((Barrel)holder).getLocation());
                    break block5;
                }
                object = inv.getLocation();
                if (object == null) break block8;
                Object it = object;
                boolean bl = false;
                List<Location> list = CollectionsKt.listOf(it);
                object = list;
                if (list != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final int computeTotalSimilar(Inventory inv, ItemStack proto) {
        int total = 0;
        ItemStack[] itemStackArray = inv.getContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray, "getContents(...)");
        for (ItemStack stack : itemStackArray) {
            if (stack == null || stack.getType().isAir() || !this.isSameItem(stack, proto)) continue;
            total += stack.getAmount();
        }
        return total;
    }

    private final boolean isSameItem(ItemStack a, ItemStack b) {
        Integer n;
        Integer n2;
        if (a.getType() != b.getType()) {
            return false;
        }
        ItemMeta am = a.getItemMeta();
        ItemMeta bm = b.getItemMeta();
        ItemMeta itemMeta = am;
        if (itemMeta != null) {
            ItemMeta it = itemMeta;
            boolean bl = false;
            n2 = it.hasCustomModelData() ? Integer.valueOf(it.getCustomModelData()) : null;
        } else {
            n2 = null;
        }
        Integer acmd = n2;
        ItemMeta itemMeta2 = bm;
        if (itemMeta2 != null) {
            ItemMeta it = itemMeta2;
            boolean bl = false;
            n = it.hasCustomModelData() ? Integer.valueOf(it.getCustomModelData()) : null;
        } else {
            n = null;
        }
        Integer bcmd = n;
        return Intrinsics.areEqual(acmd, bcmd);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateMarketsForContainer(Inventory inv, Location containerLoc) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = MarketOlusturma.Companion.getMarkets();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Market it = (Market)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getChestLocation(), containerLoc)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List targets = (List)destination$iv$iv;
        if (targets.isEmpty()) {
            return;
        }
        for (Market market : targets) {
            BlockState state;
            int total = this.computeTotalSimilar(inv, market.getItemStack());
            if (market.getAmount() == total) continue;
            market.setAmount(total);
            String amountText = total <= 0 ? LangManager.INSTANCE.getMessage("empty") : String.valueOf(total);
            Intrinsics.checkNotNullExpressionValue(containerLoc.getBlock().getState(), "getState(...)");
            BlockState blockState = state;
            if (blockState instanceof Chest) {
                TabelaUpdate.INSTANCE.updateSign((Chest)state, market.getItemStack(), market.getPrice(), null, amountText);
                continue;
            }
            if (blockState instanceof Barrel) {
                TabelaUpdate.INSTANCE.updateSignAnyContainer(market, market.getItemStack(), market.getPrice(), null, amountText);
                continue;
            }
            TabelaUpdate.INSTANCE.updateSignAnyContainer(market, market.getItemStack(), market.getPrice(), null, amountText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void onInventoryClose$lambda$0$0(MarketInventoryListener this$0, Inventory $inv, Location $loc) {
        try {
            this$0.updateMarketsForContainer($inv, $loc);
        }
        finally {
            this$0.pending.remove($loc);
        }
    }
}

