/*
 * Decompiled with CFR 0.152.
 */
package com.bilolib.bobshop.market;

import com.bilolib.bobshop.market.Market;
import com.bilolib.bobshop.market.MarketMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\nJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\nJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\nJ\u0010\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/bilolib/bobshop/market/MarketManager;", "", "<init>", "()V", "markets", "", "Lcom/bilolib/bobshop/market/Market;", "sameBlock", "", "a", "Lorg/bukkit/Location;", "b", "keyOf", "", "loc", "getAll", "", "setAll", "", "list", "", "save", "market", "removeByChest", "chest", "removeBySign", "sign", "findByChest", "findBySign", "canonicalMode", "Lcom/bilolib/bobshop/market/MarketMode;", "s", "BOBSHOP"})
@SourceDebugExtension(value={"SMAP\nMarket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Market.kt\ncom/bilolib/bobshop/market/MarketManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1869#2,2:86\n295#2,2:88\n295#2,2:90\n*S KotlinDebug\n*F\n+ 1 Market.kt\ncom/bilolib/bobshop/market/MarketManager\n*L\n45#1:86,2\n74#1:88,2\n79#1:90,2\n*E\n"})
public final class MarketManager {
    @NotNull
    public static final MarketManager INSTANCE = new MarketManager();
    @NotNull
    private static final List<Market> markets = new ArrayList();

    private MarketManager() {
    }

    private final boolean sameBlock(Location a, Location b) {
        World world = a.getWorld();
        World world2 = b.getWorld();
        return Intrinsics.areEqual(world != null ? world.getName() : null, world2 != null ? world2.getName() : null) && a.getBlockX() == b.getBlockX() && a.getBlockY() == b.getBlockY() && a.getBlockZ() == b.getBlockZ();
    }

    private final String keyOf(Location loc) {
        World world = loc.getWorld();
        return (world != null ? world.getName() : null) + ":" + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ();
    }

    @NotNull
    public final synchronized List<Market> getAll() {
        return CollectionsKt.toList((Iterable)markets);
    }

    public final synchronized void setAll(@NotNull Collection<Market> list) {
        Intrinsics.checkNotNullParameter(list, "list");
        markets.clear();
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Location sign;
            Location chest;
            Market m = (Market)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(m.getChestLocation().toBlockLocation(), "toBlockLocation(...)");
            Intrinsics.checkNotNullExpressionValue(m.getSignLocation().toBlockLocation(), "toBlockLocation(...)");
            markets.add(Market.copy$default(m, null, chest, sign, null, 0, 0.0, null, null, false, false, 1017, null));
        }
    }

    public final synchronized void save(@NotNull Market market) {
        Intrinsics.checkNotNullParameter(market, "market");
        Location location = market.getChestLocation().toBlockLocation();
        Intrinsics.checkNotNullExpressionValue(location, "toBlockLocation(...)");
        Location chest = location;
        Location location2 = market.getSignLocation().toBlockLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "toBlockLocation(...)");
        Location sign = location2;
        markets.removeIf(arg_0 -> MarketManager.save$lambda$1(arg_0 -> MarketManager.save$lambda$0(chest, arg_0), arg_0));
        markets.add(Market.copy$default(market, null, chest, sign, null, 0, 0.0, null, null, false, false, 1017, null));
    }

    public final synchronized boolean removeByChest(@NotNull Location chest) {
        Intrinsics.checkNotNullParameter(chest, "chest");
        return markets.removeIf(arg_0 -> MarketManager.removeByChest$lambda$1(arg_0 -> MarketManager.removeByChest$lambda$0(chest, arg_0), arg_0));
    }

    public final synchronized boolean removeBySign(@NotNull Location sign) {
        Intrinsics.checkNotNullParameter(sign, "sign");
        return markets.removeIf(arg_0 -> MarketManager.removeBySign$lambda$1(arg_0 -> MarketManager.removeBySign$lambda$0(sign, arg_0), arg_0));
    }

    @Nullable
    public final synchronized Market findByChest(@NotNull Location chest) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(chest, "chest");
            Iterable $this$firstOrNull$iv = markets;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Market it = (Market)element$iv;
                boolean bl = false;
                if (!INSTANCE.sameBlock(it.getChestLocation(), chest)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final synchronized Market findBySign(@NotNull Location sign) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(sign, "sign");
            Iterable $this$firstOrNull$iv = markets;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Market it = (Market)element$iv;
                boolean bl = false;
                if (!INSTANCE.sameBlock(it.getSignLocation(), sign)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final MarketMode canonicalMode(@Nullable String s) {
        Object object;
        try {
            String string = s;
            if (string == null) {
                string = "BUY";
            }
            object = ((Object)StringsKt.trim((CharSequence)string)).toString();
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue(locale, "ENGLISH");
            String string2 = ((String)object).toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
            object = MarketMode.valueOf(string2);
        }
        catch (Exception exception) {
            object = MarketMode.BUY;
        }
        return object;
    }

    private static final boolean save$lambda$0(Location $chest, Market it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.sameBlock(it.getChestLocation(), $chest);
    }

    private static final boolean save$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeByChest$lambda$0(Location $chest, Market it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.sameBlock(it.getChestLocation(), $chest);
    }

    private static final boolean removeByChest$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeBySign$lambda$0(Location $sign, Market it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.sameBlock(it.getSignLocation(), $sign);
    }

    private static final boolean removeBySign$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

