/*
 * Decompiled with CFR 0.152.
 */
package com.bilolib.bobshop.market;

import com.bilolib.bobshop.BOBShop;
import com.bilolib.bobshop.eco.EconomyBridge;
import com.bilolib.bobshop.manager.LangManager;
import com.bilolib.bobshop.market.Market;
import com.bilolib.bobshop.market.MarketChunkIndex;
import com.bilolib.bobshop.market.MarketDatabase;
import com.bilolib.bobshop.market.MarketMode;
import com.bilolib.bobshop.shopholo.ShopItemHolo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0007J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006$"}, d2={"Lcom/bilolib/bobshop/market/MarketOlusturma;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "allowedBlocks", "", "Lorg/bukkit/Material;", "getAllowedBlocks", "()Ljava/util/Set;", "allowedBlocks$delegate", "Lkotlin/Lazy;", "onChestClick", "", "e", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onChat", "Lorg/bukkit/event/player/AsyncPlayerChatEvent;", "horizontalFaceOrFallback", "Lorg/bukkit/block/BlockFace;", "face", "playerFacing", "computeInventory", "Lorg/bukkit/inventory/Inventory;", "block", "Lorg/bukkit/block/Block;", "normalizeToWallSign", "materialName", "", "placeShopSign", "player", "Lorg/bukkit/entity/Player;", "item", "Lorg/bukkit/inventory/ItemStack;", "price", "", "Companion", "BOBSHOP"})
@SourceDebugExtension(value={"SMAP\nMarketOlusturma.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketOlusturma.kt\ncom/bilolib/bobshop/market/MarketOlusturma\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n1761#2,3:263\n1788#2,4:266\n774#2:270\n865#2,2:271\n1563#2:274\n1634#2,3:275\n1617#2,9:278\n1869#2:287\n1870#2:289\n1626#2:290\n1563#2:291\n1634#2,3:292\n1#3:273\n1#3:288\n*S KotlinDebug\n*F\n+ 1 MarketOlusturma.kt\ncom/bilolib/bobshop/market/MarketOlusturma\n*L\n56#1:263,3\n63#1:266,4\n211#1:270\n211#1:271,2\n223#1:274\n223#1:275,3\n43#1:278,9\n43#1:287\n43#1:289\n43#1:290\n129#1:291\n129#1:292,3\n43#1:288\n*E\n"})
public final class MarketOlusturma
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy allowedBlocks$delegate = LazyKt.lazy(() -> MarketOlusturma.allowedBlocks_delegate$lambda$0(this));
    @NotNull
    private static final Map<UUID, Companion.ShopSetup> waitingForPrice = new LinkedHashMap();
    @NotNull
    private static final List<Market> markets = new ArrayList();

    private final Set<Material> getAllowedBlocks() {
        Lazy lazy = this.allowedBlocks$delegate;
        return (Set)lazy.getValue();
    }

    @EventHandler
    public final void onChestClick(@NotNull PlayerInteractEvent e) {
        boolean bl;
        Player player;
        Block block;
        block13: {
            Intrinsics.checkNotNullParameter(e, "e");
            if (e.getAction() != Action.LEFT_CLICK_BLOCK) {
                return;
            }
            Block block2 = e.getClickedBlock();
            if (block2 == null) {
                return;
            }
            block = block2;
            if (!this.getAllowedBlocks().contains(block.getType())) {
                return;
            }
            Player player2 = e.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
            player = player2;
            Iterable $this$any$iv = markets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Market it = (Market)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getChestLocation().getBlock(), block)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        int shopLimit = BOBShop.Companion.getInstance().getConfig().getInt("economy.shop_limit", 5);
        if (!player.hasPermission("bobshop.admin")) {
            int count;
            Iterable $this$count$iv = markets;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v3 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Market it = (Market)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getOwner(), player.getUniqueId()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v3 = count = count$iv;
            }
            if (count >= shopLimit) {
                String msg = StringsKt.replace$default(LangManager.INSTANCE.getMessage("market-limit-reached"), "{limit}", String.valueOf(shopLimit), false, 4, null);
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
                return;
            }
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInMainHand(...)");
        ItemStack item = itemStack;
        if (item.getType().isAir()) {
            return;
        }
        Map<UUID, Companion.ShopSetup> map = waitingForPrice;
        UUID uUID = player.getUniqueId();
        ItemStack itemStack2 = item.clone();
        Intrinsics.checkNotNullExpressionValue(itemStack2, "clone(...)");
        Companion.ShopSetup shopSetup = new Companion.ShopSetup(block, itemStack2);
        map.put(uUID, shopSetup);
        player.sendMessage(LangManager.INSTANCE.getMessage("enter-price"));
    }

    @EventHandler
    public final void onChat(@NotNull AsyncPlayerChatEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uid = uUID;
        Companion.ShopSetup shopSetup = waitingForPrice.get(uid);
        if (shopSetup == null) {
            return;
        }
        Companion.ShopSetup setup = shopSetup;
        e.setCancelled(true);
        String string = e.getMessage();
        Intrinsics.checkNotNullExpressionValue(string, "getMessage(...)");
        String raw = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String cancelWord = LangManager.INSTANCE.getMessage("cancel");
        if (StringsKt.equals(raw, cancelWord, true)) {
            Bukkit.getScheduler().runTask((Plugin)BOBShop.Companion.getInstance(), () -> MarketOlusturma.onChat$lambda$0(uid, player2));
            return;
        }
        Double parsed = StringsKt.toDoubleOrNull(StringsKt.replace$default(raw, ',', '.', false, 4, null));
        Bukkit.getScheduler().runTask((Plugin)BOBShop.Companion.getInstance(), () -> MarketOlusturma.onChat$lambda$1(parsed, player2, setup, uid, this));
    }

    private final BlockFace horizontalFaceOrFallback(BlockFace face, BlockFace playerFacing) {
        return switch (WhenMappings.$EnumSwitchMapping$0[face.ordinal()]) {
            case 5, 6 -> {
                BlockFace v0 = playerFacing;
                switch (v0 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        yield playerFacing;
                    }
                }
                yield BlockFace.NORTH;
            }
            default -> face;
        };
    }

    private final Inventory computeInventory(Block block) {
        Inventory inventory;
        BlockState blockState = block.getState();
        Intrinsics.checkNotNullExpressionValue(blockState, "getState(...)");
        BlockState st = blockState;
        if (st instanceof Chest) {
            InventoryHolder inventoryHolder = ((Chest)st).getInventory().getHolder();
            inventory = inventoryHolder instanceof DoubleChest ? (DoubleChest)inventoryHolder : null;
            if (inventory == null || (inventory = inventory.getInventory()) == null) {
                Inventory inventory2 = ((Chest)st).getInventory();
                inventory = inventory2;
                Intrinsics.checkNotNullExpressionValue(inventory2, "getInventory(...)");
            }
        } else {
            inventory = st instanceof Barrel ? ((Barrel)st).getInventory() : null;
        }
        return inventory;
    }

    private final Material normalizeToWallSign(String materialName) {
        String string = materialName.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        String upper = string;
        if (StringsKt.endsWith$default(upper, "_WALL_SIGN", false, 2, null)) {
            Material material = Material.getMaterial((String)upper);
            if (material == null) {
                material = Material.OAK_WALL_SIGN;
            }
            return material;
        }
        Object candidate = StringsKt.endsWith$default(upper, "_SIGN", false, 2, null) ? StringsKt.replace$default(upper, "_SIGN", "_WALL_SIGN", false, 4, null) : upper + "_WALL_SIGN";
        Material material = Material.getMaterial((String)candidate);
        if (material == null) {
            material = Material.OAK_WALL_SIGN;
        }
        return material;
    }

    /*
     * WARNING - void declaration
     */
    private final void placeShopSign(Player player, Block block, ItemStack item, double price) {
        void $this$placeShopSign_u24lambda_u248;
        void $this$mapTo$iv$iv;
        Object object;
        String $this$filterTo$iv$iv;
        BlockData blockData = block.getBlockData();
        Directional directional = blockData instanceof Directional ? (Directional)blockData : null;
        if (directional == null) {
            MarketOlusturma $this$placeShopSign_u24lambda_u240 = this;
            boolean bl = false;
            player.sendMessage(LangManager.INSTANCE.getMessage("invalid-chest"));
            return;
        }
        Directional dir = directional;
        blockData = switch (WhenMappings.$EnumSwitchMapping$0[dir.getFacing().ordinal()]) {
            case 1, 2, 3, 4 -> dir.getFacing();
            case 5, 6 -> player.getFacing().getOppositeFace();
            default -> player.getFacing().getOppositeFace();
        };
        Intrinsics.checkNotNull(blockData);
        BlockData faceForSign = blockData;
        Block block2 = block.getRelative((BlockFace)faceForSign);
        Intrinsics.checkNotNullExpressionValue(block2, "getRelative(...)");
        Block target = block2;
        String string = LangManager.INSTANCE.getConfig().getString("sign");
        if (string == null) {
            string = "OAK_WALL_SIGN";
        }
        String signCfg = string;
        Material signMat = this.normalizeToWallSign(signCfg);
        if (!target.getType().isAir() && target.getType() != signMat) {
            player.sendMessage(LangManager.INSTANCE.getMessage("invalid-sign"));
            return;
        }
        target.setType(signMat);
        BlockData blockData2 = target.getBlockData();
        WallSign wallSign = blockData2 instanceof WallSign ? (WallSign)blockData2 : null;
        if (wallSign == null) {
            MarketOlusturma $this$placeShopSign_u24lambda_u241 = this;
            boolean bl = false;
            player.sendMessage(LangManager.INSTANCE.getMessage("invalid-sign"));
            return;
        }
        WallSign wall = wallSign;
        wall.setFacing((BlockFace)faceForSign);
        target.setBlockData((BlockData)wall);
        BlockState $this$placeShopSign_u24lambda_u241 = target.getState();
        Sign sign = $this$placeShopSign_u24lambda_u241 instanceof Sign ? (Sign)$this$placeShopSign_u24lambda_u241 : null;
        if (sign == null) {
            MarketOlusturma $this$placeShopSign_u24lambda_u242 = this;
            boolean bl = false;
            player.sendMessage(LangManager.INSTANCE.getMessage("invalid-sign"));
            return;
        }
        Sign sign2 = sign;
        Inventory inventory = this.computeInventory(block);
        if (inventory == null) {
            MarketOlusturma $this$placeShopSign_u24lambda_u243 = this;
            boolean bl = false;
            player.sendMessage(LangManager.INSTANCE.getMessage("invalid-chest"));
            return;
        }
        Inventory inv = inventory;
        ItemStack[] itemStackArray = inv.getContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray, "getContents(...)");
        Iterable $this$filter$iv = ArraysKt.filterNotNull((Object[])itemStackArray);
        int $i$f$filter22 = 0;
        Iterable bl = $this$filter$iv;
        Collection<Object> destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            ItemStack it = (ItemStack)element$iv$iv;
            boolean bl2 = false;
            if (!it.isSimilar(item)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        $i$f$filter22 = 0;
        for (Collection<Object> destination$iv$iv2 : $this$filter$iv) {
            void it;
            ItemStack $i$f$filterTo2 = (ItemStack)destination$iv$iv2;
            int n = $i$f$filter22;
            boolean bl3 = false;
            int n2 = it.getAmount();
            $i$f$filter22 = n + n2;
        }
        int totalAmount = $i$f$filter22;
        ItemMeta itemMeta = item.getItemMeta();
        boolean bl4 = itemMeta != null ? itemMeta.hasDisplayName() : false;
        if (bl4) {
            ItemMeta itemMeta2 = item.getItemMeta();
            Intrinsics.checkNotNull(itemMeta2);
            object = itemMeta2.getDisplayName();
        } else {
            String string2 = item.getType().name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            $this$filterTo$iv$iv = StringsKt.replace$default(string2, "_", " ", false, 4, null);
            if (((CharSequence)$this$filterTo$iv$iv).length() > 0) {
                void it22;
                char destination$iv$iv2 = $this$filterTo$iv$iv.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                String string3 = String.valueOf((char)it22);
                Intrinsics.checkNotNull(string3, "null cannot be cast to non-null type java.lang.String");
                String string4 = string3.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
                StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
                Object it22 = $this$filterTo$iv$iv;
                n = 1;
                String string5 = ((String)it22).substring(n);
                Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                object = stringBuilder2.append(string5).toString();
            } else {
                object = $this$filterTo$iv$iv;
            }
        }
        String $i$f$filter22 = object;
        Intrinsics.checkNotNull($i$f$filter22);
        String itemName = $i$f$filter22;
        String amountText = totalAmount <= 0 ? LangManager.INSTANCE.getMessage("empty") : String.valueOf(totalAmount);
        MarketMode marketMode = MarketMode.BUY;
        String modeText = LangManager.INSTANCE.getMessage("market-modes.buy");
        String priceStr = EconomyBridge.INSTANCE.format(price);
        Iterable $this$map$iv = new IntRange(1, 4);
        boolean $i$f$map = false;
        Iterable bl2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator3 = $this$mapTo$iv$iv.iterator();
        while (iterator3.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator3).nextInt();
            Collection collection = destination$iv$iv3;
            boolean bl5 = false;
            String template = LangManager.INSTANCE.getMessage("sign." + (int)i);
            String string6 = player.getName();
            Intrinsics.checkNotNullExpressionValue(string6, "getName(...)");
            collection.add(ChatColor.translateAlternateColorCodes((char)'&', (String)StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(template, "{owner}", string6, false, 4, null), "{item}", itemName, false, 4, null), "{price}", priceStr, false, 4, null), "{amount}", amountText, false, 4, null), "{mode}", modeText, false, 4, null)));
        }
        List lines = (List)destination$iv$iv3;
        for (int i = 0; i < 4; ++i) {
            sign2.setLine(i, (String)lines.get(i));
        }
        sign2.update(true);
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Location location = block.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = target.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        ItemStack itemStack = item.clone();
        destination$iv$iv3 = itemStack;
        Location location3 = location2;
        Location location4 = location;
        UUID uUID2 = uUID;
        boolean bl6 = false;
        $this$placeShopSign_u24lambda_u248.setAmount(1);
        Unit unit = Unit.INSTANCE;
        ItemStack itemStack2 = itemStack;
        Intrinsics.checkNotNullExpressionValue(itemStack2, "apply(...)");
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 512;
        boolean bl7 = false;
        boolean bl8 = false;
        String string7 = null;
        MarketMode marketMode2 = marketMode;
        double d = price;
        int n3 = totalAmount;
        ItemStack itemStack3 = itemStack2;
        Location location5 = location3;
        Location location6 = location4;
        UUID uUID3 = uUID2;
        Market newMarket = new Market(uUID3, location6, location5, itemStack3, n3, d, marketMode2, string7, bl8, bl7, n, defaultConstructorMarker);
        markets.removeIf(arg_0 -> MarketOlusturma.placeShopSign$lambda$10(arg_0 -> MarketOlusturma.placeShopSign$lambda$9(block, arg_0), arg_0));
        markets.add(newMarket);
        MarketDatabase.INSTANCE.saveOrUpdateMarket(newMarket);
        MarketChunkIndex.INSTANCE.add(newMarket);
        if (BOBShop.Companion.getInstance().getConfig().getBoolean("hologram", true)) {
            JavaPlugin javaPlugin = BOBShop.Companion.getInstance();
            Location location7 = block.getLocation();
            Intrinsics.checkNotNullExpressionValue(location7, "getLocation(...)");
            ShopItemHolo.spawnOrUpdateHologram$default(ShopItemHolo.INSTANCE, javaPlugin, location7, newMarket.getItemStack(), null, 8, null);
        } else {
            Location location8 = block.getLocation();
            Intrinsics.checkNotNullExpressionValue(location8, "getLocation(...)");
            ShopItemHolo.INSTANCE.removeHologram(location8);
        }
        player.sendMessage(LangManager.INSTANCE.getMessage("market-created"));
    }

    /*
     * WARNING - void declaration
     */
    private static final Set allowedBlocks_delegate$lambda$0(MarketOlusturma this$0) {
        void $this$mapNotNullTo$iv$iv;
        List list = BOBShop.Companion.getInstance().getConfig().getStringList("shop-blocks");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Material it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Object object2 = this$0;
            try {
                MarketOlusturma $this$allowedBlocks_delegate_u24lambda_u240_u240_u240 = object2;
                boolean bl3 = false;
                Intrinsics.checkNotNull(it);
                String string = it.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                object = Result.constructor-impl(Material.valueOf((String)string));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            object2 = object;
            if ((Material)(Result.isFailure-impl(object2) ? null : object2) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    private static final void onChat$lambda$0(UUID $uid, Player $player) {
        waitingForPrice.remove($uid);
        $player.sendMessage(LangManager.INSTANCE.getMessage("price-cancelled"));
        $player.closeInventory();
    }

    /*
     * WARNING - void declaration
     */
    private static final void onChat$lambda$1(Double $parsed, Player $player, Companion.ShopSetup $setup, UUID $uid, MarketOlusturma this$0) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<String> list;
        if ($parsed == null || !(Math.abs($parsed) <= Double.MAX_VALUE)) {
            $player.sendMessage(LangManager.INSTANCE.getMessage("shop-price-invalid-number"));
            return;
        }
        double fixedPrice = EconomyBridge.INSTANCE.clampAndRoundPrice($parsed);
        boolean charged = EconomyBridge.INSTANCE.chargeCreationPrice($player);
        if (!charged) {
            double creationFee = BOBShop.Companion.getInstance().getConfig().getDouble("economy.creation_fee", 10.0);
            String msg = StringsKt.replace$default(LangManager.INSTANCE.getMessage("not-enough-money"), "{price}", EconomyBridge.INSTANCE.format(creationFee), false, 4, null);
            $player.sendMessage(msg);
            return;
        }
        Block block = $setup.getChestBlock();
        Iterable<String> msg = BOBShop.Companion.getInstance().getConfig().getStringList("shop-blocks");
        if (msg.isEmpty()) {
            boolean bl = false;
            list = CollectionsKt.listOf("CHEST");
        } else {
            list = msg;
        }
        msg = list;
        boolean $i$f$map = false;
        void var12_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            String string2 = it.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
            collection.add(string2);
        }
        Set allowed = CollectionsKt.toSet((List)destination$iv$iv);
        if (!allowed.contains(block.getType().name())) {
            double creationPrice = BOBShop.Companion.getInstance().getConfig().getDouble("economy.creation_price", 10.0);
            EconomyBridge.INSTANCE.depositPlayer($player, creationPrice);
            $player.sendMessage(LangManager.INSTANCE.getMessage("invalid-chest"));
            waitingForPrice.remove($uid);
            return;
        }
        waitingForPrice.remove($uid);
        this$0.placeShopSign($player, block, $setup.getItem(), fixedPrice);
    }

    private static final boolean placeShopSign$lambda$9(Block $block, Market it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getChestLocation(), $block.getLocation());
    }

    private static final boolean placeShopSign$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/bilolib/bobshop/market/MarketOlusturma$Companion;", "", "<init>", "()V", "waitingForPrice", "", "Ljava/util/UUID;", "Lcom/bilolib/bobshop/market/MarketOlusturma$Companion$ShopSetup;", "getWaitingForPrice", "()Ljava/util/Map;", "markets", "", "Lcom/bilolib/bobshop/market/Market;", "getMarkets", "()Ljava/util/List;", "ShopSetup", "BOBSHOP"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<UUID, ShopSetup> getWaitingForPrice() {
            return waitingForPrice;
        }

        @NotNull
        public final List<Market> getMarkets() {
            return markets;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/bilolib/bobshop/market/MarketOlusturma$Companion$ShopSetup;", "", "chestBlock", "Lorg/bukkit/block/Block;", "item", "Lorg/bukkit/inventory/ItemStack;", "<init>", "(Lorg/bukkit/block/Block;Lorg/bukkit/inventory/ItemStack;)V", "getChestBlock", "()Lorg/bukkit/block/Block;", "getItem", "()Lorg/bukkit/inventory/ItemStack;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "BOBSHOP"})
        public static final class ShopSetup {
            @NotNull
            private final Block chestBlock;
            @NotNull
            private final ItemStack item;

            public ShopSetup(@NotNull Block chestBlock, @NotNull ItemStack item) {
                Intrinsics.checkNotNullParameter(chestBlock, "chestBlock");
                Intrinsics.checkNotNullParameter(item, "item");
                this.chestBlock = chestBlock;
                this.item = item;
            }

            @NotNull
            public final Block getChestBlock() {
                return this.chestBlock;
            }

            @NotNull
            public final ItemStack getItem() {
                return this.item;
            }

            @NotNull
            public final Block component1() {
                return this.chestBlock;
            }

            @NotNull
            public final ItemStack component2() {
                return this.item;
            }

            @NotNull
            public final ShopSetup copy(@NotNull Block chestBlock, @NotNull ItemStack item) {
                Intrinsics.checkNotNullParameter(chestBlock, "chestBlock");
                Intrinsics.checkNotNullParameter(item, "item");
                return new ShopSetup(chestBlock, item);
            }

            public static /* synthetic */ ShopSetup copy$default(ShopSetup shopSetup, Block block, ItemStack itemStack, int n, Object object) {
                if ((n & 1) != 0) {
                    block = shopSetup.chestBlock;
                }
                if ((n & 2) != 0) {
                    itemStack = shopSetup.item;
                }
                return shopSetup.copy(block, itemStack);
            }

            @NotNull
            public String toString() {
                return "ShopSetup(chestBlock=" + this.chestBlock + ", item=" + this.item + ")";
            }

            public int hashCode() {
                int result = this.chestBlock.hashCode();
                result = result * 31 + this.item.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ShopSetup)) {
                    return false;
                }
                ShopSetup shopSetup = (ShopSetup)other;
                if (!Intrinsics.areEqual(this.chestBlock, shopSetup.chestBlock)) {
                    return false;
                }
                return Intrinsics.areEqual(this.item, shopSetup.item);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlockFace.values().length];
            try {
                nArray[BlockFace.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

