/*
 * Decompiled with CFR 0.152.
 */
package com.bilolib.bobshop.menu;

import com.bilolib.bobshop.BOBShop;
import com.bilolib.bobshop.manager.LangManager;
import com.bilolib.bobshop.market.Market;
import com.bilolib.bobshop.market.MarketChunkIndex;
import com.bilolib.bobshop.market.MarketDatabase;
import com.bilolib.bobshop.market.MarketMode;
import com.bilolib.bobshop.market.MarketOlusturma;
import com.bilolib.bobshop.menu.MarketMenu;
import com.bilolib.bobshop.menu.marketmenueventlist.ChangeItemMenu;
import com.bilolib.bobshop.menu.marketmenueventlist.DescriptionManager;
import com.bilolib.bobshop.menu.marketmenueventlist.PriceChangeManager;
import com.bilolib.bobshop.shopholo.ShopItemHolo;
import com.bilolib.bobshop.tabela.TabelaUpdate;
import com.bilolib.bobshop.util.MarketmodeKt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/bilolib/bobshop/menu/MarketMenuEvent;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "openMenus", "", "Ljava/util/UUID;", "Lcom/bilolib/bobshop/market/Market;", "waitingForItemSelection", "onInventoryClick", "", "e", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "toggleMarketMode", "player", "Lorg/bukkit/entity/Player;", "market", "onSignRightClick", "Lorg/bukkit/event/player/PlayerInteractEvent;", "BOBSHOP"})
@SourceDebugExtension(value={"SMAP\nMarketMenuEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketMenuEvent.kt\ncom/bilolib/bobshop/menu/MarketMenuEvent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class MarketMenuEvent
implements Listener {
    @NotNull
    private final Map<UUID, Market> openMenus = new LinkedHashMap();
    @NotNull
    private final Map<UUID, Market> waitingForItemSelection = new LinkedHashMap();

    @EventHandler
    public final void onInventoryClick(@NotNull InventoryClickEvent e) {
        Market market;
        Object v5;
        Market cached;
        Player player;
        block17: {
            Intrinsics.checkNotNullParameter(e, "e");
            HumanEntity humanEntity = e.getWhoClicked();
            Player player2 = humanEntity instanceof Player ? (Player)humanEntity : null;
            if (player2 == null) {
                return;
            }
            player = player2;
            String string = LangManager.INSTANCE.getMessage("market-menu-title");
            String string2 = player.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            String expected = ChatColor.stripColor((String)StringsKt.replace$default(string, "{owner}", string2, false, 4, null));
            String currentTitle = ChatColor.stripColor((String)e.getView().getTitle());
            if (!Intrinsics.areEqual(currentTitle, expected)) {
                return;
            }
            Inventory inventory = e.getView().getTopInventory();
            Intrinsics.checkNotNullExpressionValue(inventory, "getTopInventory(...)");
            Inventory top = inventory;
            if (!Intrinsics.areEqual(e.getClickedInventory(), top)) {
                return;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[e.getClick().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    e.setCancelled(true);
                    return;
                }
            }
            e.setCancelled(true);
            Market market2 = this.openMenus.get(player.getUniqueId());
            if (market2 == null) {
                return;
            }
            cached = market2;
            Iterable iterable = MarketOlusturma.Companion.getMarkets();
            for (Object t : iterable) {
                Market it = (Market)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getChestLocation(), cached.getChestLocation())) continue;
                v5 = t;
                break block17;
            }
            v5 = null;
        }
        if ((market = (Market)v5) == null) {
            market = cached;
        }
        Market market3 = market;
        int slot = e.getRawSlot();
        switch (slot) {
            case 26: {
                this.openMenus.remove(player.getUniqueId());
                MarketDatabase.INSTANCE.removeMarket(market3);
                MarketOlusturma.Companion.getMarkets().removeIf(arg_0 -> MarketMenuEvent.onInventoryClick$lambda$2(arg_0 -> MarketMenuEvent.onInventoryClick$lambda$1(market3, arg_0), arg_0));
                ShopItemHolo.INSTANCE.removeHologram(market3.getChestLocation());
                player.sendMessage(LangManager.INSTANCE.getMessage("market-removed"));
                MarketChunkIndex.INSTANCE.remove(market3);
                player.closeInventory();
                break;
            }
            case 10: {
                this.openMenus.remove(player.getUniqueId());
                PriceChangeManager.INSTANCE.requestPriceChange(player, market3);
                break;
            }
            case 11: {
                this.waitingForItemSelection.put(player.getUniqueId(), market3);
                this.openMenus.remove(player.getUniqueId());
                player.closeInventory();
                ChangeItemMenu.INSTANCE.openPlayerInventoryMenu(player, market3);
                break;
            }
            case 12: {
                this.toggleMarketMode(player, market3);
                TabelaUpdate.INSTANCE.update(market3);
                break;
            }
            case 13: {
                BOBShop plugin = BOBShop.Companion.getInstance();
                boolean descriptionEnabled = plugin.getConfig().getBoolean("holo-description.enabled", true);
                if (!descriptionEnabled) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LangManager.INSTANCE.getMessage("description-disabled-msg")));
                    return;
                }
                this.openMenus.remove(player.getUniqueId());
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                DescriptionManager.INSTANCE.requestDescription(uUID, market3);
                break;
            }
            default: {
                return;
            }
        }
    }

    private final void toggleMarketMode(Player player, Market market) {
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask((Plugin)BOBShop.Companion.getInstance(), () -> MarketMenuEvent.toggleMarketMode$lambda$0(this, player, market));
            return;
        }
        market.setMode(market.getMode() == MarketMode.BUY ? MarketMode.SELL : MarketMode.BUY);
        MarketDatabase.INSTANCE.saveOrUpdateMarket(market);
        BlockState blockState = market.getChestLocation().getBlock().getState();
        Chest chest = blockState instanceof Chest ? (Chest)blockState : null;
        if (chest != null) {
            Chest chest2 = chest;
            boolean bl = false;
            TabelaUpdate.updateSign$default(TabelaUpdate.INSTANCE, chest2, market.getItemStack(), market.getPrice(), null, null, 24, null);
        }
        ShopItemHolo.INSTANCE.spawnOrUpdateHologram(BOBShop.Companion.getInstance(), market.getChestLocation(), market.getItemStack(), market.getDescription());
        player.sendMessage(StringsKt.replace$default(LangManager.INSTANCE.getMessage("market-mode-changed"), "{mode}", MarketmodeKt.displayMode(market.getMode()), false, 4, null));
        player.closeInventory();
    }

    @EventHandler
    public final void onSignRightClick(@NotNull PlayerInteractEvent e) {
        Object v2;
        block8: {
            Intrinsics.checkNotNullParameter(e, "e");
            if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            Block block = e.getClickedBlock();
            if (block == null) {
                return;
            }
            Block block2 = block;
            BlockState blockState = block2.getState();
            Sign sign = blockState instanceof Sign ? (Sign)blockState : null;
            if (sign == null) {
                return;
            }
            Sign sign2 = sign;
            if (e.getPlayer().isSneaking()) {
                return;
            }
            Iterable iterable = MarketOlusturma.Companion.getMarkets();
            for (Object t : iterable) {
                Market it = (Market)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getSignLocation().getBlock(), sign2.getBlock())) continue;
                v2 = t;
                break block8;
            }
            v2 = null;
        }
        Market market = v2;
        if (market == null) {
            return;
        }
        Market market2 = market;
        if (market2.getAdminShop()) {
            return;
        }
        if (!Intrinsics.areEqual(e.getPlayer().getUniqueId(), market2.getOwner())) {
            return;
        }
        e.setCancelled(true);
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        MarketMenu.INSTANCE.open(player, market2);
        this.openMenus.put(e.getPlayer().getUniqueId(), market2);
    }

    private static final boolean onInventoryClick$lambda$1(Market $market, Market it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getChestLocation(), $market.getChestLocation());
    }

    private static final boolean onInventoryClick$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void toggleMarketMode$lambda$0(MarketMenuEvent this$0, Player $player, Market $market) {
        this$0.toggleMarketMode($player, $market);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClickType.values().length];
            try {
                nArray[ClickType.DOUBLE_CLICK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickType.SHIFT_LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickType.SHIFT_RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickType.NUMBER_KEY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickType.SWAP_OFFHAND.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

