/*
 * Decompiled with CFR 0.152.
 */
package com.bilolib.bobshop.menu.marketmenueventlist;

import com.bilolib.bobshop.BOBShop;
import com.bilolib.bobshop.manager.LangManager;
import com.bilolib.bobshop.market.Market;
import com.bilolib.bobshop.market.MarketDatabase;
import com.bilolib.bobshop.market.MarketOlusturma;
import com.bilolib.bobshop.shopholo.ShopItemHolo;
import com.bilolib.bobshop.util.Cooldown;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/bilolib/bobshop/menu/marketmenueventlist/DescriptionManager;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "waitingForDescription", "", "Ljava/util/UUID;", "Lcom/bilolib/bobshop/market/Market;", "requestDescription", "", "playerUUID", "market", "onChat", "e", "Lorg/bukkit/event/player/AsyncPlayerChatEvent;", "BOBSHOP"})
public final class DescriptionManager
implements Listener {
    @NotNull
    public static final DescriptionManager INSTANCE = new DescriptionManager();
    @NotNull
    private static final Map<UUID, Market> waitingForDescription = new LinkedHashMap();

    private DescriptionManager() {
    }

    public final void requestDescription(@NotNull UUID playerUUID, @NotNull Market market) {
        Intrinsics.checkNotNullParameter(playerUUID, "playerUUID");
        Intrinsics.checkNotNullParameter(market, "market");
        String cdKey = "descbtn:" + playerUUID;
        if (!Cooldown.INSTANCE.allow(cdKey, 150L)) {
            return;
        }
        Player player = BOBShop.Companion.getInstance().getServer().getPlayer(playerUUID);
        if (player == null) {
            return;
        }
        Player player2 = player;
        CharSequence charSequence = market.getDescription();
        if (charSequence == null || StringsKt.isBlank(charSequence)) {
            waitingForDescription.put(playerUUID, market);
            player2.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LangManager.INSTANCE.getMessage("enter-description")));
            Bukkit.getScheduler().runTaskLater((Plugin)BOBShop.Companion.getInstance(), () -> DescriptionManager.requestDescription$lambda$0(playerUUID), 300L);
            player2.closeInventory();
        } else {
            Market updatedMarket = Market.copy$default(market, null, null, null, null, 0, 0.0, null, null, false, false, 895, null);
            MarketOlusturma.Companion.getMarkets().removeIf(arg_0 -> DescriptionManager.requestDescription$lambda$2(arg_0 -> DescriptionManager.requestDescription$lambda$1(market, arg_0), arg_0));
            MarketOlusturma.Companion.getMarkets().add(updatedMarket);
            MarketDatabase.INSTANCE.saveOrUpdateMarket(updatedMarket);
            ShopItemHolo.INSTANCE.removeHologram(updatedMarket.getChestLocation());
            ShopItemHolo.INSTANCE.spawnOrUpdateHologram(BOBShop.Companion.getInstance(), updatedMarket.getChestLocation(), updatedMarket.getItemStack(), updatedMarket.getDescription());
            String removedMsg = LangManager.INSTANCE.getMessage("market-description-removed");
            player2.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)removedMsg));
            player2.closeInventory();
        }
    }

    @EventHandler
    public final void onChat(@NotNull AsyncPlayerChatEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uid = uUID;
        Market market = waitingForDescription.get(uid);
        if (market == null) {
            return;
        }
        Market market2 = market;
        e.setCancelled(true);
        String string = e.getMessage();
        Intrinsics.checkNotNullExpressionValue(string, "getMessage(...)");
        String raw = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String cancelWord = LangManager.INSTANCE.getMessage("cancel");
        if (StringsKt.equals(raw, cancelWord, true) || StringsKt.equals(raw, "cancel", true)) {
            Bukkit.getScheduler().runTask((Plugin)BOBShop.Companion.getInstance(), () -> DescriptionManager.onChat$lambda$0(player2, uid));
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)BOBShop.Companion.getInstance(), () -> DescriptionManager.onChat$lambda$1(raw, player2, market2, uid));
    }

    private static final void requestDescription$lambda$0(UUID $playerUUID) {
        waitingForDescription.remove($playerUUID);
    }

    private static final boolean requestDescription$lambda$1(Market $market, Market it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getChestLocation(), $market.getChestLocation());
    }

    private static final boolean requestDescription$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void onChat$lambda$0(Player $player, UUID $uid) {
        String msg = LangManager.INSTANCE.getMessage("cancelled");
        $player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
        waitingForDescription.remove($uid);
        $player.closeInventory();
    }

    private static final void onChat$lambda$1(String $raw, Player $player, Market $market, UUID $uid) {
        int maxChars = LangManager.INSTANCE.getConfig().getInt("holo-description.maxchars", 30);
        if ($raw.length() > maxChars) {
            String msg = StringsKt.replace$default(LangManager.INSTANCE.getMessage("description-too-long"), "{max}", String.valueOf(maxChars), false, 4, null);
            $player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
            return;
        }
        Market updatedMarket = Market.copy$default($market, null, null, null, null, 0, 0.0, null, $raw, false, false, 895, null);
        MarketOlusturma.Companion.getMarkets().removeIf(arg_0 -> DescriptionManager.onChat$lambda$1$1(arg_0 -> DescriptionManager.onChat$lambda$1$0($market, arg_0), arg_0));
        MarketOlusturma.Companion.getMarkets().add(updatedMarket);
        MarketDatabase.INSTANCE.saveOrUpdateMarket(updatedMarket);
        ShopItemHolo.INSTANCE.removeHologram(updatedMarket.getChestLocation());
        ShopItemHolo.INSTANCE.spawnOrUpdateHologram(BOBShop.Companion.getInstance(), updatedMarket.getChestLocation(), updatedMarket.getItemStack(), updatedMarket.getDescription());
        String updatedMsg = StringsKt.replace$default(LangManager.INSTANCE.getMessage("market-description-updated"), "{desc}", $raw, false, 4, null);
        $player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)updatedMsg));
        waitingForDescription.remove($uid);
        $player.closeInventory();
    }

    private static final boolean onChat$lambda$1$0(Market $market, Market it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getChestLocation(), $market.getChestLocation());
    }

    private static final boolean onChat$lambda$1$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

