/*
 * Decompiled with CFR 0.152.
 */
package com.bilolib.bobshop.menu.marketmenueventlist;

import com.bilolib.bobshop.BOBShop;
import com.bilolib.bobshop.manager.LangManager;
import com.bilolib.bobshop.market.Market;
import com.bilolib.bobshop.market.MarketDatabase;
import com.bilolib.bobshop.tabela.TabelaUpdate;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/bilolib/bobshop/menu/marketmenueventlist/PriceChangeManager;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "waitingForPrice", "", "Ljava/util/UUID;", "Lcom/bilolib/bobshop/market/Market;", "getWaitingForPrice", "()Ljava/util/Map;", "requestPriceChange", "", "player", "Lorg/bukkit/entity/Player;", "market", "onChat", "e", "Lorg/bukkit/event/player/AsyncPlayerChatEvent;", "BOBSHOP"})
@SourceDebugExtension(value={"SMAP\npricechange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pricechange.kt\ncom/bilolib/bobshop/menu/marketmenueventlist/PriceChangeManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class PriceChangeManager
implements Listener {
    @NotNull
    public static final PriceChangeManager INSTANCE = new PriceChangeManager();
    @NotNull
    private static final Map<UUID, Market> waitingForPrice = new LinkedHashMap();

    private PriceChangeManager() {
    }

    @NotNull
    public final Map<UUID, Market> getWaitingForPrice() {
        return waitingForPrice;
    }

    public final void requestPriceChange(@NotNull Player player, @NotNull Market market) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(market, "market");
        waitingForPrice.put(player.getUniqueId(), market);
        Bukkit.getScheduler().runTask((Plugin)BOBShop.Companion.getInstance(), () -> PriceChangeManager.requestPriceChange$lambda$0(player));
        Bukkit.getScheduler().runTaskLater((Plugin)BOBShop.Companion.getInstance(), () -> PriceChangeManager.requestPriceChange$lambda$1(player), 300L);
    }

    @EventHandler
    public final void onChat(@NotNull AsyncPlayerChatEvent e) {
        Double newPrice;
        Double parsed;
        Intrinsics.checkNotNullParameter(e, "e");
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uid = uUID;
        Market market = waitingForPrice.get(uid);
        if (market == null) {
            return;
        }
        Market market2 = market;
        e.setCancelled(true);
        String string = e.getMessage();
        Intrinsics.checkNotNullExpressionValue(string, "getMessage(...)");
        String raw = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String cancelWord = LangManager.INSTANCE.getMessage("cancel");
        if (StringsKt.equals(raw, cancelWord, true) || StringsKt.equals(raw, "cancel", true)) {
            Bukkit.getScheduler().runTask((Plugin)BOBShop.Companion.getInstance(), () -> PriceChangeManager.onChat$lambda$0(player2, uid));
            return;
        }
        Double d = parsed = StringsKt.toDoubleOrNull(StringsKt.replace$default(raw, ',', '.', false, 4, null));
        if (d != null) {
            Double d2 = d;
            double it = ((Number)d2).doubleValue();
            boolean bl = false;
            v5 = Math.abs(it) <= Double.MAX_VALUE && it > 0.0 && it <= 1.0E12 ? d2 : null;
        } else {
            v5 = newPrice = null;
        }
        if (newPrice == null) {
            Bukkit.getScheduler().runTask((Plugin)BOBShop.Companion.getInstance(), () -> PriceChangeManager.onChat$lambda$2(player2));
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)BOBShop.Companion.getInstance(), () -> PriceChangeManager.onChat$lambda$3(market2, newPrice, player2, uid));
    }

    private static final void requestPriceChange$lambda$0(Player $player) {
        $player.closeInventory();
        $player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LangManager.INSTANCE.getMessage("price-prompt")));
    }

    private static final void requestPriceChange$lambda$1(Player $player) {
        waitingForPrice.remove($player.getUniqueId());
    }

    private static final void onChat$lambda$0(Player $player, UUID $uid) {
        $player.sendMessage(LangManager.INSTANCE.getMessage("price-cancelled"));
        waitingForPrice.remove($uid);
        $player.closeInventory();
    }

    private static final void onChat$lambda$2(Player $player) {
        $player.sendMessage(LangManager.INSTANCE.getMessage("price-invalid"));
    }

    private static final void onChat$lambda$3(Market $market, Double $newPrice, Player $player, UUID $uid) {
        Chest chest;
        $market.setPrice($newPrice);
        MarketDatabase.INSTANCE.saveOrUpdateMarket($market);
        BlockState blockState = $market.getChestLocation().getBlock().getState();
        Chest chest2 = chest = blockState instanceof Chest ? (Chest)blockState : null;
        if (chest != null) {
            TabelaUpdate.updateSign$default(TabelaUpdate.INSTANCE, chest, $market.getItemStack(), $market.getPrice(), null, null, 24, null);
        }
        String string = LangManager.INSTANCE.getMessage("price-updated");
        Locale locale = Locale.US;
        String string2 = "%.2f";
        Object[] objectArray = new Object[]{$newPrice};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        String msg = StringsKt.replace$default(string, "{price}", string3, false, 4, null);
        $player.sendMessage(msg);
        TabelaUpdate.INSTANCE.update($market);
        waitingForPrice.remove($uid);
        $player.closeInventory();
    }
}

