/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.teams999;

import com.yourname.teams999.AllianceInvite;
import com.yourname.teams999.Team;
import com.yourname.teams999.Teams999;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

class AllianceManager {
    private final Teams999 plugin;
    private Map<String, Set<String>> alliances;
    private Map<String, AllianceInvite> pendingInvites;

    public AllianceManager(Teams999 plugin) {
        this.plugin = plugin;
        this.alliances = new HashMap<String, Set<String>>();
        this.pendingInvites = new HashMap<String, AllianceInvite>();
    }

    public void inviteTeam(Player sender, String targetTeamName) {
        Team senderTeam = this.plugin.getTeamManager().getPlayerTeam(sender.getUniqueId());
        if (senderTeam == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (!senderTeam.getOwner().equals(sender.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner can manage alliances.");
            return;
        }
        Team targetTeam = this.plugin.getTeamManager().getTeamByName(targetTeamName);
        if (targetTeam == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Team '" + targetTeamName + "' not found.");
            return;
        }
        if (senderTeam.equals(targetTeam)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You cannot ally with your own team.");
            return;
        }
        if (this.areAllied(senderTeam.getName(), targetTeam.getName())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You are already allied with this team.");
            return;
        }
        if (this.pendingInvites.containsKey(targetTeam.getName().toLowerCase())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This team already has a pending alliance invitation.");
            return;
        }
        AllianceInvite invite = new AllianceInvite(senderTeam.getName(), targetTeam.getName(), System.currentTimeMillis());
        this.pendingInvites.put(targetTeam.getName().toLowerCase(), invite);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Alliance invitation sent to team '" + targetTeam.getName() + "'.");
        Player targetOwner = Bukkit.getPlayer((UUID)targetTeam.getOwner());
        if (targetOwner != null) {
            targetOwner.sendMessage(String.valueOf(ChatColor.GOLD) + "Your team has been invited to form an alliance with team '" + senderTeam.getName() + "'.");
            targetOwner.sendMessage(String.valueOf(ChatColor.YELLOW) + "Type " + String.valueOf(ChatColor.GREEN) + "/ally accept" + String.valueOf(ChatColor.YELLOW) + " to accept.");
        }
    }

    public void acceptInvite(Player player) {
        Player senderOwner;
        Team team = this.plugin.getTeamManager().getPlayerTeam(player.getUniqueId());
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (!team.getOwner().equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner can accept alliance invitations.");
            return;
        }
        AllianceInvite invite = this.pendingInvites.get(team.getName().toLowerCase());
        if (invite == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Your team has no pending alliance invitations.");
            return;
        }
        String senderTeamName = invite.getSenderTeam();
        String targetTeamName = invite.getTargetTeam();
        this.alliances.computeIfAbsent(senderTeamName.toLowerCase(), k -> new HashSet()).add(targetTeamName.toLowerCase());
        this.alliances.computeIfAbsent(targetTeamName.toLowerCase(), k -> new HashSet()).add(senderTeamName.toLowerCase());
        this.pendingInvites.remove(team.getName().toLowerCase());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have formed an alliance with team '" + senderTeamName + "'!");
        Team senderTeam = this.plugin.getTeamManager().getTeamByName(senderTeamName);
        if (senderTeam != null && (senderOwner = Bukkit.getPlayer((UUID)senderTeam.getOwner())) != null) {
            senderOwner.sendMessage(String.valueOf(ChatColor.GREEN) + "Team '" + targetTeamName + "' has accepted your alliance invitation!");
        }
    }

    public void declineInvite(Player player) {
        Player senderOwner;
        Team team = this.plugin.getTeamManager().getPlayerTeam(player.getUniqueId());
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (!team.getOwner().equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner can decline alliance invitations.");
            return;
        }
        AllianceInvite invite = this.pendingInvites.get(team.getName().toLowerCase());
        if (invite == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Your team has no pending alliance invitations.");
            return;
        }
        this.pendingInvites.remove(team.getName().toLowerCase());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have declined the alliance invitation.");
        Team senderTeam = this.plugin.getTeamManager().getTeamByName(invite.getSenderTeam());
        if (senderTeam != null && (senderOwner = Bukkit.getPlayer((UUID)senderTeam.getOwner())) != null) {
            senderOwner.sendMessage(String.valueOf(ChatColor.RED) + "Team '" + team.getName() + "' has declined your alliance invitation.");
        }
    }

    public void breakAlliance(Player player, String targetTeamName) {
        Player targetOwner;
        Team team = this.plugin.getTeamManager().getPlayerTeam(player.getUniqueId());
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (!team.getOwner().equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner can break alliances.");
            return;
        }
        if (!this.areAllied(team.getName(), targetTeamName)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not allied with this team.");
            return;
        }
        String teamName1 = team.getName().toLowerCase();
        String teamName2 = targetTeamName.toLowerCase();
        if (this.alliances.containsKey(teamName1)) {
            this.alliances.get(teamName1).remove(teamName2);
        }
        if (this.alliances.containsKey(teamName2)) {
            this.alliances.get(teamName2).remove(teamName1);
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have broken your alliance with team '" + targetTeamName + "'.");
        Team targetTeam = this.plugin.getTeamManager().getTeamByName(targetTeamName);
        if (targetTeam != null && (targetOwner = Bukkit.getPlayer((UUID)targetTeam.getOwner())) != null) {
            targetOwner.sendMessage(String.valueOf(ChatColor.RED) + "Team '" + team.getName() + "' has broken their alliance with you.");
        }
    }

    public boolean areAllied(String team1, String team2) {
        if (team1 == null || team2 == null) {
            return false;
        }
        Set<String> allies = this.alliances.get(team1.toLowerCase());
        return allies != null && allies.contains(team2.toLowerCase());
    }

    public Set<UUID> getAlliedMembers(Team team) {
        HashSet<UUID> alliedMembers = new HashSet<UUID>();
        alliedMembers.addAll(team.getAllMembers());
        Set<String> alliedTeamNames = this.alliances.get(team.getName().toLowerCase());
        if (alliedTeamNames != null) {
            for (String alliedTeamName : alliedTeamNames) {
                Team alliedTeam = this.plugin.getTeamManager().getTeamByName(alliedTeamName);
                if (alliedTeam == null) continue;
                alliedMembers.addAll(alliedTeam.getAllMembers());
            }
        }
        return alliedMembers.stream().filter(uuid -> Bukkit.getPlayer((UUID)uuid) != null && Bukkit.getPlayer((UUID)uuid).isOnline()).collect(Collectors.toSet());
    }

    public void loadFromConfig(FileConfiguration config) {
        this.alliances.clear();
        if (config.contains("alliances")) {
            for (String teamName : config.getConfigurationSection("alliances").getKeys(false)) {
                List allyList = config.getStringList("alliances." + teamName);
                this.alliances.put(teamName, new HashSet(allyList));
            }
        }
    }

    public void saveToConfig(FileConfiguration config) {
        config.set("alliances", null);
        for (Map.Entry<String, Set<String>> entry : this.alliances.entrySet()) {
            config.set("alliances." + entry.getKey(), new ArrayList(entry.getValue()));
        }
    }
}

