/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.teams999;

import com.yourname.teams999.PendingInvite;
import com.yourname.teams999.Team;
import com.yourname.teams999.Teams999;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

class TeamManager {
    private final Teams999 plugin;
    private Map<String, Team> teams;
    private Map<UUID, Team> playerTeams;
    private Map<UUID, PendingInvite> pendingInvites;

    public TeamManager(Teams999 plugin) {
        this.plugin = plugin;
        this.teams = new HashMap<String, Team>();
        this.playerTeams = new HashMap<UUID, Team>();
        this.pendingInvites = new HashMap<UUID, PendingInvite>();
    }

    public Team getPlayerTeam(UUID playerId) {
        return this.playerTeams.get(playerId);
    }

    public Team getTeamByName(String name) {
        return this.teams.get(name.toLowerCase());
    }

    public void createTeam(Player player, String name) {
        if (this.teams.containsKey(name.toLowerCase())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Team name '" + name + "' is already in use.");
            return;
        }
        if (this.playerTeams.containsKey(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are already in a team.");
            return;
        }
        if (!Pattern.matches(this.plugin.getTeamNameFormat(), name)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Team name does not match the required format: " + this.plugin.getTeamNameFormat());
            return;
        }
        Team team = new Team(name, player.getUniqueId());
        this.teams.put(name.toLowerCase(), team);
        this.playerTeams.put(player.getUniqueId(), team);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Team '" + name + "' created successfully! You are now the owner.");
    }

    public void disbandTeam(Player player) {
        Team team = this.playerTeams.get(player.getUniqueId());
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (!team.getOwner().equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner can disband the team.");
            return;
        }
        for (UUID memberId : team.getAllMembers()) {
            Player member = Bukkit.getPlayer((UUID)memberId);
            if (member != null) {
                member.sendMessage(String.valueOf(ChatColor.RED) + "Your team '" + team.getName() + "' has been disbanded by the owner.");
                this.plugin.updatePlayerDisplay(member);
            }
            this.playerTeams.remove(memberId);
        }
        this.teams.remove(team.getName().toLowerCase());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Team '" + team.getName() + "' has been disbanded.");
    }

    public void invitePlayer(Player sender, String targetName) {
        Team team = this.playerTeams.get(sender.getUniqueId());
        if (team == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (!team.getOwner().equals(sender.getUniqueId()) && !team.getOfficers().contains(sender.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only owners and officers can invite players.");
            return;
        }
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player '" + targetName + "' not found or is offline.");
            return;
        }
        if (this.playerTeams.containsKey(target.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " is already in a team.");
            return;
        }
        if (this.pendingInvites.containsKey(target.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " already has a pending invitation.");
            return;
        }
        int currentSize = team.getAllMembers().size();
        if (currentSize >= this.plugin.getMaxTeamSize()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Your team has reached the maximum size of " + this.plugin.getMaxTeamSize() + ".");
            return;
        }
        PendingInvite invite = new PendingInvite(team, sender.getUniqueId(), System.currentTimeMillis());
        this.pendingInvites.put(target.getUniqueId(), invite);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Invitation sent to " + target.getName() + ".");
        target.sendMessage(String.valueOf(ChatColor.GOLD) + "You have been invited to join team '" + team.getName() + "' by " + sender.getName() + ".");
        target.sendMessage(String.valueOf(ChatColor.YELLOW) + "Type " + String.valueOf(ChatColor.GREEN) + "/team accept" + String.valueOf(ChatColor.YELLOW) + " to join. (Expires in " + this.plugin.getInviteExpiryMillis() / 60000L + " minutes)");
    }

    public void acceptInvite(Player player) {
        PendingInvite invite = this.pendingInvites.get(player.getUniqueId());
        if (invite == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have any pending team invitations.");
            return;
        }
        Team team = invite.getTeam();
        if (team == null || !this.teams.containsValue(team)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This invitation is no longer valid.");
            this.pendingInvites.remove(player.getUniqueId());
            return;
        }
        if (System.currentTimeMillis() - invite.getTimestamp() > this.plugin.getInviteExpiryMillis()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This invitation has expired.");
            this.pendingInvites.remove(player.getUniqueId());
            return;
        }
        int currentSize = team.getAllMembers().size();
        if (currentSize >= this.plugin.getMaxTeamSize()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "The team has reached the maximum size of " + this.plugin.getMaxTeamSize() + ". You cannot join.");
            this.pendingInvites.remove(player.getUniqueId());
            return;
        }
        team.getMembers().add(player.getUniqueId());
        this.playerTeams.put(player.getUniqueId(), team);
        this.pendingInvites.remove(player.getUniqueId());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have joined team '" + team.getName() + "'!");
        this.plugin.updatePlayerDisplay(player);
        for (UUID memberId : team.getAllMembers()) {
            Player member = Bukkit.getPlayer((UUID)memberId);
            if (member == null || member.getUniqueId().equals(player.getUniqueId())) continue;
            member.sendMessage(String.valueOf(ChatColor.GREEN) + player.getName() + " has joined the team!");
            this.plugin.updatePlayerDisplay(member);
        }
    }

    public void leaveTeam(Player player) {
        Team team = this.playerTeams.get(player.getUniqueId());
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (team.getOwner().equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot leave the team as the owner. Use " + String.valueOf(ChatColor.YELLOW) + "/team disband" + String.valueOf(ChatColor.RED) + " instead.");
            return;
        }
        team.getMembers().remove(player.getUniqueId());
        team.getOfficers().remove(player.getUniqueId());
        this.playerTeams.remove(player.getUniqueId());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have left team '" + team.getName() + "'.");
        this.plugin.updatePlayerDisplay(player);
        for (UUID memberId : team.getAllMembers()) {
            Player member = Bukkit.getPlayer((UUID)memberId);
            if (member == null) continue;
            member.sendMessage(String.valueOf(ChatColor.YELLOW) + player.getName() + " has left the team.");
            this.plugin.updatePlayerDisplay(member);
        }
    }

    public void promotePlayer(Player sender, String targetName) {
        Team team = this.playerTeams.get(sender.getUniqueId());
        if (team == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (!team.getOwner().equals(sender.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner can promote players.");
            return;
        }
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player '" + targetName + "' not found or is offline.");
            return;
        }
        if (team.getOwner().equals(target.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You cannot promote the owner.");
            return;
        }
        if (!team.getMembers().contains(target.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " is not a member of your team.");
            return;
        }
        if (team.getOfficers().contains(target.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " is already an officer.");
            return;
        }
        team.getMembers().remove(target.getUniqueId());
        team.getOfficers().add(target.getUniqueId());
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Promoted " + target.getName() + " to Officer.");
        target.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been promoted to Officer in team '" + team.getName() + "'!");
        this.plugin.updatePlayerDisplay(target);
        this.plugin.updatePlayerDisplay(sender);
        for (UUID memberId : team.getAllMembers()) {
            Player member = Bukkit.getPlayer((UUID)memberId);
            if (member == null || member.getUniqueId().equals(sender.getUniqueId()) || member.getUniqueId().equals(target.getUniqueId())) continue;
            member.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + " has been promoted to Officer.");
            this.plugin.updatePlayerDisplay(member);
        }
    }

    public void demotePlayer(Player sender, String targetName) {
        Team team = this.playerTeams.get(sender.getUniqueId());
        if (team == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (!team.getOwner().equals(sender.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner can demote players.");
            return;
        }
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player '" + targetName + "' not found or is offline.");
            return;
        }
        if (!team.getOfficers().contains(target.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " is not an officer in your team.");
            return;
        }
        team.getOfficers().remove(target.getUniqueId());
        team.getMembers().add(target.getUniqueId());
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Demoted " + target.getName() + " to Member.");
        target.sendMessage(String.valueOf(ChatColor.YELLOW) + "You have been demoted to Member in team '" + team.getName() + "'.");
        this.plugin.updatePlayerDisplay(target);
        this.plugin.updatePlayerDisplay(sender);
        for (UUID memberId : team.getAllMembers()) {
            Player member = Bukkit.getPlayer((UUID)memberId);
            if (member == null || member.getUniqueId().equals(sender.getUniqueId()) || member.getUniqueId().equals(target.getUniqueId())) continue;
            member.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + " has been demoted to Member.");
            this.plugin.updatePlayerDisplay(member);
        }
    }

    public void showTeamInfo(Player player) {
        Team team = this.playerTeams.get(player.getUniqueId());
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.BLUE) + "Team Info: " + team.getName()));
        ItemStack infoItem = new ItemStack(Material.BOOK);
        ItemMeta infoMeta = infoItem.getItemMeta();
        infoMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + team.getName());
        ArrayList<CallSite> infoLore = new ArrayList<CallSite>();
        infoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Owner: " + String.valueOf(ChatColor.WHITE) + Bukkit.getOfflinePlayer((UUID)team.getOwner()).getName())));
        infoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Total Members: " + String.valueOf(ChatColor.WHITE) + team.getAllMembers().size())));
        infoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Officers: " + String.valueOf(ChatColor.WHITE) + team.getOfficers().size())));
        infoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Homes: " + String.valueOf(ChatColor.WHITE) + team.getHomes().size() + "/" + this.plugin.getMaxTeamHomes())));
        if (!team.getHomes().isEmpty()) {
            infoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Available homes: " + String.valueOf(ChatColor.WHITE) + String.join((CharSequence)", ", team.getHomes().keySet()))));
        }
        infoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "MOTD: " + String.valueOf(ChatColor.WHITE) + (team.getMotd() != null ? team.getMotd() : "None"))));
        infoMeta.setLore(infoLore);
        infoItem.setItemMeta(infoMeta);
        gui.setItem(4, infoItem);
        int slot = 9;
        ItemStack ownerHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta ownerMeta = (SkullMeta)ownerHead.getItemMeta();
        ownerMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)team.getOwner()));
        ownerMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + Bukkit.getOfflinePlayer((UUID)team.getOwner()).getName() + " (Owner)");
        ownerHead.setItemMeta((ItemMeta)ownerMeta);
        gui.setItem(slot++, ownerHead);
        for (UUID officerId : team.getOfficers()) {
            ItemStack officerHead = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta officerMeta = (SkullMeta)officerHead.getItemMeta();
            officerMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)officerId));
            officerMeta.setDisplayName(String.valueOf(ChatColor.BLUE) + Bukkit.getOfflinePlayer((UUID)officerId).getName() + " (Officer)");
            officerHead.setItemMeta((ItemMeta)officerMeta);
            gui.setItem(slot++, officerHead);
        }
        for (UUID memberId : team.getMembers()) {
            ItemStack memberHead = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta memberMeta = (SkullMeta)memberHead.getItemMeta();
            memberMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)memberId));
            memberMeta.setDisplayName(String.valueOf(ChatColor.WHITE) + Bukkit.getOfflinePlayer((UUID)memberId).getName() + " (Member)");
            memberHead.setItemMeta((ItemMeta)memberMeta);
            gui.setItem(slot++, memberHead);
        }
        player.openInventory(gui);
    }

    public void listOnlineMembers(Player player) {
        Team team = this.playerTeams.get(player.getUniqueId());
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        ArrayList<CallSite> onlineMembers = new ArrayList<CallSite>();
        ArrayList<CallSite> onlineOfficers = new ArrayList<CallSite>();
        Player owner = Bukkit.getPlayer((UUID)team.getOwner());
        if (owner != null && owner.isOnline()) {
            onlineMembers.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + owner.getName() + " (Owner)")));
        }
        for (UUID uUID : team.getOfficers()) {
            Player officer = Bukkit.getPlayer((UUID)uUID);
            if (officer == null || !officer.isOnline()) continue;
            onlineOfficers.add((CallSite)((Object)(String.valueOf(ChatColor.BLUE) + officer.getName() + " (Officer)")));
        }
        for (UUID uUID : team.getMembers()) {
            Player member = Bukkit.getPlayer((UUID)uUID);
            if (member == null || !member.isOnline()) continue;
            onlineMembers.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + member.getName() + " (Member)")));
        }
        if (onlineMembers.isEmpty() && onlineOfficers.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "No team members are currently online.");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "=== Online Team Members ===");
        for (String string : onlineMembers) {
            player.sendMessage(string);
        }
        for (String string : onlineOfficers) {
            player.sendMessage(string);
        }
    }

    public void setHome(Player player, String homeName) {
        Team team = this.playerTeams.get(player.getUniqueId());
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (!team.getOwner().equals(player.getUniqueId()) && !team.getOfficers().contains(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner or officers can set a home location.");
            return;
        }
        if (team.getHomes().size() >= this.plugin.getMaxTeamHomes() && !team.getHomes().containsKey(homeName.toLowerCase())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Your team has reached the maximum number of homes (" + this.plugin.getMaxTeamHomes() + ").");
            return;
        }
        team.setHome(homeName, player.getLocation());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Team home '" + homeName + "' set!");
    }

    public void teleportHome(Player player, String homeName) {
        Team team = this.playerTeams.get(player.getUniqueId());
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (team.getHomes().isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Your team has no homes set.");
            return;
        }
        if (homeName == null) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Available homes: " + String.join((CharSequence)", ", team.getHomes().keySet()));
            return;
        }
        Location home = team.getHome(homeName);
        if (home == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Home '" + homeName + "' not found.");
            return;
        }
        player.teleport(home);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleported to team home '" + homeName + "'!");
    }

    public void deleteHome(Player player, String homeName) {
        Team team = this.playerTeams.get(player.getUniqueId());
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (!team.getOwner().equals(player.getUniqueId()) && !team.getOfficers().contains(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner or officers can delete a home location.");
            return;
        }
        if (team.getHome(homeName) == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Home '" + homeName + "' not found.");
            return;
        }
        team.removeHome(homeName);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Team home '" + homeName + "' deleted!");
    }

    public void renameTeam(Player player, String newName) {
        Player member;
        Team team = this.playerTeams.get(player.getUniqueId());
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (!team.getOwner().equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner can rename the team.");
            return;
        }
        if (this.teams.containsKey(newName.toLowerCase())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Team name '" + newName + "' is already in use.");
            return;
        }
        if (!Pattern.matches(this.plugin.getTeamNameFormat(), newName)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "New team name does not match the required format: " + this.plugin.getTeamNameFormat());
            return;
        }
        long currentTime = System.currentTimeMillis();
        long cooldownMillis = (long)this.plugin.getTeamRenameCooldown() * 60L * 1000L;
        if (team.getLastRenameTimestamp() != 0L && currentTime - team.getLastRenameTimestamp() < cooldownMillis) {
            long remainingSeconds = (cooldownMillis - (currentTime - team.getLastRenameTimestamp())) / 1000L;
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait " + remainingSeconds / 60L + " minutes and " + remainingSeconds % 60L + " seconds before renaming your team again.");
            return;
        }
        if (this.plugin.getEconomy() != null) {
            double cost = this.plugin.getTeamRenameCost();
            if (cost > 0.0 && !this.plugin.getEconomy().has((OfflinePlayer)player, cost)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You need " + this.plugin.getEconomy().format(cost) + " to rename your team.");
                return;
            }
            if (cost > 0.0) {
                this.plugin.getEconomy().withdrawPlayer((OfflinePlayer)player, cost);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "You paid " + this.plugin.getEconomy().format(cost) + " to rename your team.");
            }
        } else if (this.plugin.getTeamRenameCost() > 0.0) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Economy features are disabled. Cannot rename team for a cost.");
            return;
        }
        String oldName = team.getName();
        this.teams.remove(oldName.toLowerCase());
        team.setName(newName);
        team.setLastRenameTimestamp(currentTime);
        this.teams.put(newName.toLowerCase(), team);
        for (UUID memberId : team.getAllMembers()) {
            this.playerTeams.put(memberId, team);
            member = Bukkit.getPlayer((UUID)memberId);
            if (member == null) continue;
            this.plugin.updatePlayerDisplay(member);
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your team has been renamed to '" + newName + "'!");
        for (UUID memberId : team.getAllMembers()) {
            member = Bukkit.getPlayer((UUID)memberId);
            if (member == null || member.getUniqueId().equals(player.getUniqueId())) continue;
            member.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your team has been renamed to '" + newName + "' by the owner.");
        }
    }

    public void setMotd(Player player, String motd) {
        Team team = this.playerTeams.get(player.getUniqueId());
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (!team.getOwner().equals(player.getUniqueId()) && !team.getOfficers().contains(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner or officers can set the MOTD.");
            return;
        }
        team.setMotd(motd);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Team MOTD set to: " + String.valueOf(ChatColor.YELLOW) + motd);
        for (UUID memberId : team.getAllMembers()) {
            Player member = Bukkit.getPlayer((UUID)memberId);
            if (member == null || member.getUniqueId().equals(player.getUniqueId())) continue;
            member.sendMessage(String.valueOf(ChatColor.YELLOW) + player.getName() + " has updated the team MOTD: " + String.valueOf(ChatColor.GOLD) + motd);
        }
    }

    public void cleanupExpiredInvites() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<UUID, PendingInvite>> iterator = this.pendingInvites.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, PendingInvite> entry = iterator.next();
            if (currentTime - entry.getValue().getTimestamp() <= this.plugin.getInviteExpiryMillis()) continue;
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player != null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Your team invitation has expired.");
            }
            iterator.remove();
        }
    }

    public void loadFromConfig(FileConfiguration config) {
        this.teams.clear();
        this.playerTeams.clear();
        if (config.contains("teams")) {
            for (String teamName : config.getConfigurationSection("teams").getKeys(false)) {
                try {
                    String ownerIdStr = config.getString("teams." + teamName + ".owner");
                    UUID ownerId = UUID.fromString(ownerIdStr);
                    Team team = new Team(teamName, ownerId);
                    List memberIds = config.getStringList("teams." + teamName + ".members");
                    for (String memberIdStr : memberIds) {
                        UUID memberId = UUID.fromString(memberIdStr);
                        team.getMembers().add(memberId);
                        this.playerTeams.put(memberId, team);
                    }
                    List officerIds = config.getStringList("teams." + teamName + ".officers");
                    for (String officerIdStr : officerIds) {
                        UUID officerId = UUID.fromString(officerIdStr);
                        team.getOfficers().add(officerId);
                        this.playerTeams.put(officerId, team);
                    }
                    if (config.isConfigurationSection("teams." + teamName + ".homes")) {
                        for (String homeName : config.getConfigurationSection("teams." + teamName + ".homes").getKeys(false)) {
                            Location home = config.getLocation("teams." + teamName + ".homes." + homeName);
                            if (home == null) continue;
                            team.setHome(homeName, home);
                        }
                    }
                    if (config.contains("teams." + teamName + ".motd")) {
                        team.setMotd(config.getString("teams." + teamName + ".motd"));
                    }
                    if (config.contains("teams." + teamName + ".last-rename-timestamp")) {
                        team.setLastRenameTimestamp(config.getLong("teams." + teamName + ".last-rename-timestamp"));
                    }
                    this.teams.put(teamName.toLowerCase(), team);
                    this.playerTeams.put(ownerId, team);
                }
                catch (Exception e) {
                    Bukkit.getLogger().warning("Failed to load team: " + teamName + " - " + e.getMessage());
                }
            }
        }
    }

    public void saveToConfig(FileConfiguration config) {
        config.set("teams", null);
        for (Team team : this.teams.values()) {
            String teamName = team.getName();
            config.set("teams." + teamName + ".owner", (Object)team.getOwner().toString());
            ArrayList<String> memberIds = new ArrayList<String>();
            for (UUID memberId : team.getMembers()) {
                memberIds.add(memberId.toString());
            }
            config.set("teams." + teamName + ".members", memberIds);
            ArrayList<String> officerIds = new ArrayList<String>();
            for (UUID uUID : team.getOfficers()) {
                officerIds.add(uUID.toString());
            }
            config.set("teams." + teamName + ".officers", officerIds);
            if (!team.getHomes().isEmpty()) {
                for (Map.Entry entry : team.getHomes().entrySet()) {
                    config.set("teams." + teamName + ".homes." + (String)entry.getKey(), entry.getValue());
                }
            }
            if (team.getMotd() != null && !team.getMotd().isEmpty()) {
                config.set("teams." + teamName + ".motd", (Object)team.getMotd());
            }
            config.set("teams." + teamName + ".last-rename-timestamp", (Object)team.getLastRenameTimestamp());
        }
    }
}

