/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.teams999;

import com.yourname.teams999.AllianceManager;
import com.yourname.teams999.Team;
import com.yourname.teams999.TeamManager;
import com.yourname.teams999.VaultManager;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Teams999
extends JavaPlugin
implements Listener {
    private TeamManager teamManager;
    private AllianceManager allianceManager;
    private VaultManager vaultManager;
    private File dataFile;
    private FileConfiguration dataConfig;
    private Economy econ = null;
    private long inviteExpiryMillis;
    private int maxTeamSize;
    private double teamRenameCost;
    private int teamRenameCooldown;
    private String teamNameFormat;
    private boolean allianceFriendlyFire;
    private int maxTeamHomes;
    private Set<UUID> rolesEnabled;
    private Set<UUID> teamChatEnabled;
    private Set<UUID> allyChatEnabled;

    public void onEnable() {
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault not found! Economy features will be disabled.");
        }
        this.teamManager = new TeamManager(this);
        this.allianceManager = new AllianceManager(this);
        this.vaultManager = new VaultManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.rolesEnabled = new HashSet<UUID>();
        this.teamChatEnabled = new HashSet<UUID>();
        this.allyChatEnabled = new HashSet<UUID>();
        this.saveDefaultConfig();
        this.loadConfigSettings();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.loadData();
        this.vaultManager.loadVaults();
        new BukkitRunnable(){

            public void run() {
                Teams999.this.teamManager.cleanupExpiredInvites();
            }
        }.runTaskTimer((Plugin)this, 6000L, 6000L);
        for (Player online : Bukkit.getOnlinePlayers()) {
            this.updatePlayerDisplay(online);
        }
        this.getLogger().info("Teams999 plugin has been enabled!");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return this.econ != null;
    }

    private void loadConfigSettings() {
        FileConfiguration config = this.getConfig();
        this.inviteExpiryMillis = config.getLong("team.invite-expiry", 5L) * 60L * 1000L;
        this.maxTeamSize = config.getInt("team.max-size", 10);
        if (this.maxTeamSize < 2) {
            this.maxTeamSize = 2;
        }
        this.teamRenameCost = config.getDouble("team.rename-cost", 1000.0);
        this.teamRenameCooldown = config.getInt("team.rename-cooldown", 60);
        this.teamNameFormat = config.getString("team.name-format", "^[a-zA-Z0-9_]{3,16}$");
        this.allianceFriendlyFire = config.getBoolean("alliances.friendly-fire", false);
        this.maxTeamHomes = config.getInt("team.max-homes", 3);
    }

    public void onDisable() {
        this.saveData();
        this.vaultManager.saveVaults();
        this.getLogger().info("Teams999 plugin has been disabled!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("team")) {
            if (args.length == 0) {
                this.sendHelp(player);
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "create": {
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team create <name>");
                        return true;
                    }
                    this.teamManager.createTeam(player, args[1]);
                    this.updatePlayerDisplay(player);
                    break;
                }
                case "disband": {
                    this.teamManager.disbandTeam(player);
                    this.updatePlayerDisplay(player);
                    break;
                }
                case "invite": {
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team invite <player>");
                        return true;
                    }
                    this.teamManager.invitePlayer(player, args[1]);
                    break;
                }
                case "accept": {
                    this.teamManager.acceptInvite(player);
                    this.updatePlayerDisplay(player);
                    break;
                }
                case "leave": {
                    this.teamManager.leaveTeam(player);
                    this.updatePlayerDisplay(player);
                    break;
                }
                case "promote": {
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team promote <player>");
                        return true;
                    }
                    this.teamManager.promotePlayer(player, args[1]);
                    this.updatePlayerDisplay(player);
                    break;
                }
                case "demote": {
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team demote <player>");
                        return true;
                    }
                    this.teamManager.demotePlayer(player, args[1]);
                    this.updatePlayerDisplay(player);
                    break;
                }
                case "info": {
                    this.teamManager.showTeamInfo(player);
                    break;
                }
                case "online": {
                    this.teamManager.listOnlineMembers(player);
                    break;
                }
                case "sethome": {
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team sethome <name>");
                        return true;
                    }
                    this.teamManager.setHome(player, args[1]);
                    break;
                }
                case "home": {
                    this.teamManager.teleportHome(player, args.length > 1 ? args[1] : null);
                    break;
                }
                case "delhome": {
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team delhome <name>");
                        return true;
                    }
                    this.teamManager.deleteHome(player, args[1]);
                    break;
                }
                case "chat": {
                    this.toggleTeamChat(player);
                    break;
                }
                case "rename": {
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team rename <new-name>");
                        return true;
                    }
                    this.teamManager.renameTeam(player, args[1]);
                    break;
                }
                case "motd": {
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team motd <message>");
                        return true;
                    }
                    String motd = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                    this.teamManager.setMotd(player, motd);
                    break;
                }
                case "roles": {
                    if (args.length >= 2 && args[1].equalsIgnoreCase("toggle")) {
                        this.toggleRoles(player);
                        break;
                    }
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /team roles toggle");
                    break;
                }
                case "vault": {
                    this.vaultManager.openVault(player);
                    break;
                }
                default: {
                    this.sendHelp(player);
                    break;
                }
            }
        } else if (command.getName().equalsIgnoreCase("ally")) {
            if (args.length == 0) {
                this.sendAllyHelp(player);
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "invite": {
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ally invite <team>");
                        return true;
                    }
                    this.allianceManager.inviteTeam(player, args[1]);
                    break;
                }
                case "accept": {
                    this.allianceManager.acceptInvite(player);
                    break;
                }
                case "decline": {
                    this.allianceManager.declineInvite(player);
                    break;
                }
                case "break": {
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ally break <team>");
                        return true;
                    }
                    this.allianceManager.breakAlliance(player, args[1]);
                    break;
                }
                case "chat": {
                    this.toggleAllyChat(player);
                    break;
                }
                default: {
                    this.sendAllyHelp(player);
                }
            }
        }
        return true;
    }

    private void toggleRoles(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.rolesEnabled.contains(uuid)) {
            this.rolesEnabled.remove(uuid);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Role prefix in chat disabled.");
        } else {
            this.rolesEnabled.add(uuid);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Role prefix in chat enabled.");
        }
        this.updatePlayerDisplay(player);
    }

    private void toggleTeamChat(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.teamChatEnabled.contains(uuid)) {
            this.teamChatEnabled.remove(uuid);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Now everyone can see your messages.");
        } else {
            this.teamChatEnabled.add(uuid);
            this.allyChatEnabled.remove(uuid);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Only team members can see your messages now.");
        }
    }

    private void toggleAllyChat(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.allyChatEnabled.contains(uuid)) {
            this.allyChatEnabled.remove(uuid);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Now everyone can see your messages.");
        } else {
            this.allyChatEnabled.add(uuid);
            this.teamChatEnabled.remove(uuid);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Only allied members can see your messages now.");
        }
    }

    private void sendHelp(Player player) {
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Teams999 Commands ===");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team create <name> " + String.valueOf(ChatColor.GRAY) + "- Create a new team");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team disband " + String.valueOf(ChatColor.GRAY) + "- Disband your team (Owner only)");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team invite <player> " + String.valueOf(ChatColor.GRAY) + "- Invite a player to your team");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team accept " + String.valueOf(ChatColor.GRAY) + "- Accept a team invitation");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team leave " + String.valueOf(ChatColor.GRAY) + "- Leave your current team");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team promote <player> " + String.valueOf(ChatColor.GRAY) + "- Promote a member to officer");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team demote <player> " + String.valueOf(ChatColor.GRAY) + "- Demote an officer to member");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team info " + String.valueOf(ChatColor.GRAY) + "- View team information");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team online " + String.valueOf(ChatColor.GRAY) + "- List online team members");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team sethome <name> " + String.valueOf(ChatColor.GRAY) + "- Set a named team home (Leaders only)");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team home [name] " + String.valueOf(ChatColor.GRAY) + "- Teleport to a team home");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team delhome <name> " + String.valueOf(ChatColor.GRAY) + "- Delete a named team home (Leaders only)");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team chat " + String.valueOf(ChatColor.GRAY) + "- Toggle team-only chat");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team roles toggle " + String.valueOf(ChatColor.GRAY) + "- Toggle role prefix in chat");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team vault " + String.valueOf(ChatColor.GRAY) + "- Access the team vault");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team rename <new-name> " + String.valueOf(ChatColor.GRAY) + "- Rename your team (Owner only)");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team motd <message> " + String.valueOf(ChatColor.GRAY) + "- Set team message of the day");
    }

    private void sendAllyHelp(Player player) {
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Alliance Commands ===");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ally invite <team> " + String.valueOf(ChatColor.GRAY) + "- Invite a team to form an alliance");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ally accept " + String.valueOf(ChatColor.GRAY) + "- Accept an alliance invitation");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ally decline " + String.valueOf(ChatColor.GRAY) + "- Decline an alliance invitation");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ally break <team> " + String.valueOf(ChatColor.GRAY) + "- Break an alliance with a team");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ally chat " + String.valueOf(ChatColor.GRAY) + "- Toggle alliance-only chat");
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView().getTitle().contains("Team Info")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getView().getTitle().startsWith(String.valueOf(ChatColor.BLUE) + "Team Vault: ")) {
            this.vaultManager.saveVault(event.getInventory(), event.getView().getTitle());
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player && event.getEntity() instanceof Player) {
            Player damager = (Player)event.getDamager();
            Player target = (Player)event.getEntity();
            Team damagerTeam = this.teamManager.getPlayerTeam(damager.getUniqueId());
            Team targetTeam = this.teamManager.getPlayerTeam(target.getUniqueId());
            if (damagerTeam != null && targetTeam != null && damagerTeam != targetTeam && this.allianceManager.areAllied(damagerTeam.getName(), targetTeam.getName()) && !this.allianceFriendlyFire) {
                event.setCancelled(true);
                damager.sendMessage(String.valueOf(ChatColor.RED) + "You cannot harm your allies!");
            }
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        Team team = this.teamManager.getPlayerTeam(uuid);
        if (this.teamChatEnabled.contains(uuid)) {
            event.setCancelled(true);
            if (team == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team. Team chat disabled.");
                this.teamChatEnabled.remove(uuid);
                return;
            }
            String message = event.getMessage();
            String prefix = "";
            if (this.rolesEnabled.contains(uuid)) {
                prefix = this.getRolePrefix(team, uuid);
            }
            String formattedMessage = String.valueOf(ChatColor.GREEN) + "[Team] " + prefix + player.getName() + String.valueOf(ChatColor.WHITE) + ": " + message;
            for (UUID memberId : team.getAllMembers()) {
                Player member = Bukkit.getPlayer((UUID)memberId);
                if (member == null || !member.isOnline()) continue;
                member.sendMessage(formattedMessage);
            }
            return;
        }
        if (this.allyChatEnabled.contains(uuid)) {
            event.setCancelled(true);
            if (team == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team. Ally chat disabled.");
                this.allyChatEnabled.remove(uuid);
                return;
            }
            String message = event.getMessage();
            String formattedMessage = String.valueOf(ChatColor.AQUA) + "[Ally] [" + team.getName() + "] " + player.getName() + String.valueOf(ChatColor.WHITE) + ": " + message;
            Set<UUID> alliedMembers = this.allianceManager.getAlliedMembers(team);
            for (UUID memberId : alliedMembers) {
                Player member = Bukkit.getPlayer((UUID)memberId);
                if (member == null || !member.isOnline()) continue;
                member.sendMessage(formattedMessage);
            }
            return;
        }
        if (this.rolesEnabled.contains(uuid) && team != null) {
            String prefix = this.getRolePrefix(team, uuid);
            event.setFormat(prefix + "%1$s" + String.valueOf(ChatColor.WHITE) + ": %2$s");
        } else if (team != null) {
            String teamName = String.valueOf(ChatColor.GREEN) + "[" + team.getName() + "] " + String.valueOf(ChatColor.RESET);
            event.setFormat(teamName + "%1$s: %2$s");
        } else {
            event.setFormat("%1$s: %2$s");
        }
    }

    private String getRolePrefix(Team team, UUID uuid) {
        if (team.getOwner().equals(uuid)) {
            return String.valueOf(ChatColor.GOLD) + "[Owner] ";
        }
        if (team.getOfficers().contains(uuid)) {
            return String.valueOf(ChatColor.BLUE) + "[Officer] ";
        }
        if (team.getMembers().contains(uuid)) {
            return String.valueOf(ChatColor.WHITE) + "[Member] ";
        }
        return "";
    }

    public void updatePlayerDisplay(Player player) {
        UUID uuid = player.getUniqueId();
        Team team = this.teamManager.getPlayerTeam(uuid);
        Object teamName = "";
        if (team != null) {
            teamName = String.valueOf(ChatColor.GREEN) + "[" + team.getName() + "] " + String.valueOf(ChatColor.RESET);
        }
        Object rolePrefix = "";
        if (this.rolesEnabled.contains(uuid) && team != null) {
            if (team.getOwner().equals(uuid)) {
                rolePrefix = String.valueOf(ChatColor.GOLD) + "[Owner] " + String.valueOf(ChatColor.RESET);
            } else if (team.getOfficers().contains(uuid)) {
                rolePrefix = String.valueOf(ChatColor.BLUE) + "[Officer] " + String.valueOf(ChatColor.RESET);
            } else if (team.getMembers().contains(uuid)) {
                rolePrefix = String.valueOf(ChatColor.WHITE) + "[Member] " + String.valueOf(ChatColor.RESET);
            }
        }
        String baseName = player.getName();
        player.setPlayerListName((String)teamName + baseName);
        player.setDisplayName((String)teamName + (String)rolePrefix + baseName);
        player.setCustomName((String)teamName + baseName);
        player.setCustomNameVisible(true);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.updatePlayerDisplay(player);
        Team team = this.teamManager.getPlayerTeam(player.getUniqueId());
        if (team != null && team.getMotd() != null && !team.getMotd().isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "Team MOTD: " + String.valueOf(ChatColor.YELLOW) + team.getMotd());
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        player.setPlayerListName(null);
        player.setDisplayName(null);
        player.setCustomName(null);
        player.setCustomNameVisible(false);
    }

    private void loadData() {
        this.dataFile = new File(this.getDataFolder(), "data.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create data.yml file!");
                return;
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.teamManager.loadFromConfig(this.dataConfig);
        this.allianceManager.loadFromConfig(this.dataConfig);
        this.getLogger().info("Team data loaded successfully!");
    }

    private void saveData() {
        if (this.dataConfig != null) {
            this.teamManager.saveToConfig(this.dataConfig);
            this.allianceManager.saveToConfig(this.dataConfig);
            try {
                this.dataConfig.save(this.dataFile);
                this.getLogger().info("Team data saved successfully!");
            }
            catch (IOException e) {
                this.getLogger().severe("Could not save data to " + String.valueOf(this.dataFile));
            }
        }
    }

    public TeamManager getTeamManager() {
        return this.teamManager;
    }

    public AllianceManager getAllianceManager() {
        return this.allianceManager;
    }

    public int getMaxTeamSize() {
        return this.maxTeamSize;
    }

    public long getInviteExpiryMillis() {
        return this.inviteExpiryMillis;
    }

    public Economy getEconomy() {
        return this.econ;
    }

    public double getTeamRenameCost() {
        return this.teamRenameCost;
    }

    public int getTeamRenameCooldown() {
        return this.teamRenameCooldown;
    }

    public String getTeamNameFormat() {
        return this.teamNameFormat;
    }

    public int getMaxTeamHomes() {
        return this.maxTeamHomes;
    }
}

