/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.teams999;

import com.yourname.teams999.Team;
import com.yourname.teams999.Teams999;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

class VaultManager {
    private final Teams999 plugin;
    private File vaultsFile;
    private FileConfiguration vaultsConfig;
    private Map<String, Inventory> teamVaults = new HashMap<String, Inventory>();

    public VaultManager(Teams999 plugin) {
        this.plugin = plugin;
        this.vaultsFile = new File(plugin.getDataFolder(), "teamvaults.yml");
        if (!this.vaultsFile.exists()) {
            try {
                this.vaultsFile.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().severe("Could not create teamvaults.yml file!");
            }
        }
        this.vaultsConfig = YamlConfiguration.loadConfiguration((File)this.vaultsFile);
    }

    public void openVault(Player player) {
        Team team = this.plugin.getTeamManager().getPlayerTeam(player.getUniqueId());
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        Inventory vault = this.teamVaults.computeIfAbsent(team.getName().toLowerCase(), k -> Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.BLUE) + "Team Vault: " + team.getName())));
        player.openInventory(vault);
    }

    public void saveVault(Inventory inventory, String title) {
        String teamName = ChatColor.stripColor((String)title.substring(title.indexOf(": ") + 2));
        this.vaultsConfig.set("vaults." + teamName.toLowerCase(), (Object)inventory.getContents());
    }

    public void saveVaults() {
        try {
            this.vaultsConfig.save(this.vaultsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save teamvaults.yml file!");
        }
    }

    public void loadVaults() {
        if (this.vaultsConfig.contains("vaults")) {
            for (String teamName : this.vaultsConfig.getConfigurationSection("vaults").getKeys(false)) {
                ItemStack[] items = ((List)this.vaultsConfig.get("vaults." + teamName)).toArray(new ItemStack[0]);
                Inventory vault = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.BLUE) + "Team Vault: " + teamName));
                vault.setContents(items);
                this.teamVaults.put(teamName, vault);
            }
        }
    }
}

