/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.teams999;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Teams999
extends JavaPlugin
implements Listener {
    private TeamManager teamManager;
    private File dataFile;
    private FileConfiguration dataConfig;
    private long inviteExpiryMillis;
    private int maxTeamSize;
    private Set<UUID> rolesEnabled;
    private Set<UUID> teamChatEnabled;

    public void onEnable() {
        this.teamManager = new TeamManager();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.rolesEnabled = new HashSet<UUID>();
        this.teamChatEnabled = new HashSet<UUID>();
        this.saveDefaultConfig();
        this.loadConfigSettings();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.loadData();
        new BukkitRunnable(){

            public void run() {
                Teams999.this.teamManager.cleanupExpiredInvites();
            }
        }.runTaskTimer((Plugin)this, 6000L, 6000L);
        for (Player online : Bukkit.getOnlinePlayers()) {
            this.updatePlayerDisplay(online);
        }
        this.getLogger().info("Teams999 plugin has been enabled!");
    }

    private void loadConfigSettings() {
        FileConfiguration config = this.getConfig();
        this.inviteExpiryMillis = config.getLong("invite-expiry", 5L) * 60L * 1000L;
        this.maxTeamSize = config.getInt("max-team-size", 10);
        if (this.maxTeamSize < 2) {
            this.maxTeamSize = 2;
        }
    }

    public void onDisable() {
        this.saveData();
        this.getLogger().info("Teams999 plugin has been disabled!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelp(player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "create": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team create <name>");
                    return true;
                }
                this.teamManager.createTeam(player, args[1]);
                this.updatePlayerDisplay(player);
                break;
            }
            case "disband": {
                this.teamManager.disbandTeam(player);
                this.updatePlayerDisplay(player);
                break;
            }
            case "invite": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team invite <player>");
                    return true;
                }
                this.teamManager.invitePlayer(player, args[1]);
                break;
            }
            case "accept": {
                this.teamManager.acceptInvite(player);
                this.updatePlayerDisplay(player);
                break;
            }
            case "leave": {
                this.teamManager.leaveTeam(player);
                this.updatePlayerDisplay(player);
                break;
            }
            case "promote": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team promote <player>");
                    return true;
                }
                this.teamManager.promotePlayer(player, args[1]);
                this.updatePlayerDisplay(player);
                break;
            }
            case "demote": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team demote <player>");
                    return true;
                }
                this.teamManager.demotePlayer(player, args[1]);
                this.updatePlayerDisplay(player);
                break;
            }
            case "info": {
                this.teamManager.showTeamInfo(player);
                break;
            }
            case "online": {
                this.teamManager.listOnlineMembers(player);
                break;
            }
            case "sethome": {
                this.teamManager.setHome(player);
                break;
            }
            case "home": {
                this.teamManager.teleportHome(player);
                break;
            }
            case "chat": {
                this.toggleTeamChat(player);
                break;
            }
            case "roles": {
                if (args.length >= 2 && args[1].equalsIgnoreCase("toggle")) {
                    this.toggleRoles(player);
                    break;
                }
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /team roles toggle");
                break;
            }
            default: {
                this.sendHelp(player);
            }
        }
        return true;
    }

    private void toggleRoles(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.rolesEnabled.contains(uuid)) {
            this.rolesEnabled.remove(uuid);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Role prefix in chat disabled.");
        } else {
            this.rolesEnabled.add(uuid);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Role prefix in chat enabled.");
        }
        this.updatePlayerDisplay(player);
    }

    private void toggleTeamChat(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.teamChatEnabled.contains(uuid)) {
            this.teamChatEnabled.remove(uuid);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Now everyone can see your messages.");
        } else {
            this.teamChatEnabled.add(uuid);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Only team members can see your messages now.");
        }
    }

    private void sendHelp(Player player) {
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Teams999 Commands ===");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team create <name> " + String.valueOf(ChatColor.GRAY) + "- Create a new team");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team disband " + String.valueOf(ChatColor.GRAY) + "- Disband your team (Owner only)");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team invite <player> " + String.valueOf(ChatColor.GRAY) + "- Invite a player to your team");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team accept " + String.valueOf(ChatColor.GRAY) + "- Accept a team invitation");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team leave " + String.valueOf(ChatColor.GRAY) + "- Leave your current team");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team promote <player> " + String.valueOf(ChatColor.GRAY) + "- Promote a member to officer");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team demote <player> " + String.valueOf(ChatColor.GRAY) + "- Demote an officer to member");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team info " + String.valueOf(ChatColor.GRAY) + "- View team information");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team online " + String.valueOf(ChatColor.GRAY) + "- List online team members");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team sethome " + String.valueOf(ChatColor.GRAY) + "- Set team home (Owner only)");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team home " + String.valueOf(ChatColor.GRAY) + "- Teleport to team home");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team chat " + String.valueOf(ChatColor.GRAY) + "- Toggle team-only chat");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team roles toggle " + String.valueOf(ChatColor.GRAY) + "- Toggle role prefix in chat");
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView().getTitle().contains("Team Info")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        Team team = this.teamManager.getPlayerTeam(uuid);
        if (this.teamChatEnabled.contains(uuid)) {
            event.setCancelled(true);
            if (team == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team. Team chat disabled.");
                this.teamChatEnabled.remove(uuid);
                return;
            }
            String message = event.getMessage();
            String prefix = "";
            if (this.rolesEnabled.contains(uuid)) {
                prefix = this.getRolePrefix(team, uuid);
            }
            String formattedMessage = String.valueOf(ChatColor.GREEN) + "[Team] " + prefix + player.getName() + String.valueOf(ChatColor.WHITE) + ": " + message;
            for (UUID memberId : team.getAllMembers()) {
                Player member = Bukkit.getPlayer((UUID)memberId);
                if (member == null || !member.isOnline()) continue;
                member.sendMessage(formattedMessage);
            }
            return;
        }
        if (this.rolesEnabled.contains(uuid) && team != null) {
            String prefix = this.getRolePrefix(team, uuid);
            event.setFormat(prefix + "%1$s" + String.valueOf(ChatColor.WHITE) + ": %2$s");
        } else if (team != null) {
            String teamName = String.valueOf(ChatColor.GREEN) + "[" + team.getName() + "] " + String.valueOf(ChatColor.RESET);
            event.setFormat(teamName + "%1$s: %2$s");
        }
    }

    private String getRolePrefix(Team team, UUID uuid) {
        if (team.getOwner().equals(uuid)) {
            return String.valueOf(ChatColor.GOLD) + "[Owner] ";
        }
        if (team.getOfficers().contains(uuid)) {
            return String.valueOf(ChatColor.BLUE) + "[Officer] ";
        }
        if (team.getMembers().contains(uuid)) {
            return String.valueOf(ChatColor.WHITE) + "[Member] ";
        }
        return "";
    }

    public void updatePlayerDisplay(Player player) {
        UUID uuid = player.getUniqueId();
        Team team = this.teamManager.getPlayerTeam(uuid);
        Object teamName = "";
        if (team != null) {
            teamName = String.valueOf(ChatColor.GREEN) + "[" + team.getName() + "] " + String.valueOf(ChatColor.RESET);
        }
        Object rolePrefix = "";
        if (this.rolesEnabled.contains(uuid) && team != null) {
            if (team.getOwner().equals(uuid)) {
                rolePrefix = String.valueOf(ChatColor.GOLD) + "[Owner] " + String.valueOf(ChatColor.RESET);
            } else if (team.getOfficers().contains(uuid)) {
                rolePrefix = String.valueOf(ChatColor.BLUE) + "[Officer] " + String.valueOf(ChatColor.RESET);
            } else if (team.getMembers().contains(uuid)) {
                rolePrefix = String.valueOf(ChatColor.WHITE) + "[Member] " + String.valueOf(ChatColor.RESET);
            }
        }
        String baseName = player.getName();
        player.setPlayerListName((String)teamName + baseName);
        player.setDisplayName((String)teamName + (String)rolePrefix + baseName);
        player.setCustomName((String)teamName + baseName);
        player.setCustomNameVisible(true);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.updatePlayerDisplay(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        player.setPlayerListName(null);
        player.setDisplayName(null);
        player.setCustomName(null);
        player.setCustomNameVisible(false);
    }

    private void loadData() {
        this.dataFile = new File(this.getDataFolder(), "data.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create data.yml file!");
                return;
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.teamManager.loadFromConfig(this.dataConfig);
        this.getLogger().info("Team data loaded successfully!");
    }

    private void saveData() {
        if (this.dataConfig != null) {
            this.teamManager.saveToConfig(this.dataConfig);
            try {
                this.dataConfig.save(this.dataFile);
                this.getLogger().info("Team data saved successfully!");
            }
            catch (IOException e) {
                this.getLogger().severe("Could not save data to " + String.valueOf(this.dataFile));
            }
        }
    }

    public class TeamManager {
        private Map<String, Team> teams = new HashMap<String, Team>();
        private Map<UUID, Team> playerTeams = new HashMap<UUID, Team>();
        private Map<UUID, PendingInvite> pendingInvites = new HashMap<UUID, PendingInvite>();

        public Team getPlayerTeam(UUID playerId) {
            return this.playerTeams.get(playerId);
        }

        public void createTeam(Player player, String name) {
            if (this.teams.containsKey(name.toLowerCase())) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Team name '" + name + "' is already in use.");
                return;
            }
            if (this.playerTeams.containsKey(player.getUniqueId())) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are already in a team.");
                return;
            }
            if (name.length() < 3 || name.length() > 16) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Team name must be between 3 and 16 characters.");
                return;
            }
            if (!name.matches("[a-zA-Z0-9_]+")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Team name can only contain letters, numbers, and underscores.");
                return;
            }
            Team team = new Team(name, player.getUniqueId());
            this.teams.put(name.toLowerCase(), team);
            this.playerTeams.put(player.getUniqueId(), team);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Team '" + name + "' created successfully! You are now the owner.");
        }

        public void disbandTeam(Player player) {
            Team team = this.playerTeams.get(player.getUniqueId());
            if (team == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
                return;
            }
            if (!team.getOwner().equals(player.getUniqueId())) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner can disband the team.");
                return;
            }
            for (UUID memberId : team.getAllMembers()) {
                Player member = Bukkit.getPlayer((UUID)memberId);
                if (member != null) {
                    member.sendMessage(String.valueOf(ChatColor.RED) + "Your team '" + team.getName() + "' has been disbanded by the owner.");
                    Teams999.this.updatePlayerDisplay(member);
                }
                this.playerTeams.remove(memberId);
            }
            this.teams.remove(team.getName().toLowerCase());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Team '" + team.getName() + "' has been disbanded.");
        }

        public void invitePlayer(Player sender, String targetName) {
            Team team = this.playerTeams.get(sender.getUniqueId());
            if (team == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
                return;
            }
            if (!team.getOwner().equals(sender.getUniqueId()) && !team.getOfficers().contains(sender.getUniqueId())) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only owners and officers can invite players.");
                return;
            }
            Player target = Bukkit.getPlayer((String)targetName);
            if (target == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player '" + targetName + "' not found or is offline.");
                return;
            }
            if (this.playerTeams.containsKey(target.getUniqueId())) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " is already in a team.");
                return;
            }
            if (this.pendingInvites.containsKey(target.getUniqueId())) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " already has a pending invitation.");
                return;
            }
            int currentSize = team.getAllMembers().size();
            if (currentSize >= Teams999.this.maxTeamSize) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Your team has reached the maximum size of " + Teams999.this.maxTeamSize + ".");
                return;
            }
            PendingInvite invite = new PendingInvite(team, sender.getUniqueId(), System.currentTimeMillis());
            this.pendingInvites.put(target.getUniqueId(), invite);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Invitation sent to " + target.getName() + ".");
            target.sendMessage(String.valueOf(ChatColor.GOLD) + "You have been invited to join team '" + team.getName() + "' by " + sender.getName() + ".");
            target.sendMessage(String.valueOf(ChatColor.YELLOW) + "Type " + String.valueOf(ChatColor.GREEN) + "/team accept" + String.valueOf(ChatColor.YELLOW) + " to join. (Expires in " + Teams999.this.inviteExpiryMillis / 60000L + " minutes)");
        }

        public void acceptInvite(Player player) {
            PendingInvite invite = this.pendingInvites.get(player.getUniqueId());
            if (invite == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have any pending team invitations.");
                return;
            }
            Team team = invite.getTeam();
            if (team == null || !this.teams.containsValue(team)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This invitation is no longer valid.");
                this.pendingInvites.remove(player.getUniqueId());
                return;
            }
            if (System.currentTimeMillis() - invite.getTimestamp() > Teams999.this.inviteExpiryMillis) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This invitation has expired.");
                this.pendingInvites.remove(player.getUniqueId());
                return;
            }
            int currentSize = team.getAllMembers().size();
            if (currentSize >= Teams999.this.maxTeamSize) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "The team has reached the maximum size of " + Teams999.this.maxTeamSize + ". You cannot join.");
                this.pendingInvites.remove(player.getUniqueId());
                return;
            }
            team.getMembers().add(player.getUniqueId());
            this.playerTeams.put(player.getUniqueId(), team);
            this.pendingInvites.remove(player.getUniqueId());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have joined team '" + team.getName() + "'!");
            Teams999.this.updatePlayerDisplay(player);
            for (UUID memberId : team.getAllMembers()) {
                Player member = Bukkit.getPlayer((UUID)memberId);
                if (member == null || member.getUniqueId().equals(player.getUniqueId())) continue;
                member.sendMessage(String.valueOf(ChatColor.GREEN) + player.getName() + " has joined the team!");
                Teams999.this.updatePlayerDisplay(member);
            }
        }

        public void leaveTeam(Player player) {
            Team team = this.playerTeams.get(player.getUniqueId());
            if (team == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
                return;
            }
            if (team.getOwner().equals(player.getUniqueId())) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot leave the team as the owner. Use " + String.valueOf(ChatColor.YELLOW) + "/team disband" + String.valueOf(ChatColor.RED) + " instead.");
                return;
            }
            team.getMembers().remove(player.getUniqueId());
            team.getOfficers().remove(player.getUniqueId());
            this.playerTeams.remove(player.getUniqueId());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have left team '" + team.getName() + "'.");
            Teams999.this.updatePlayerDisplay(player);
            for (UUID memberId : team.getAllMembers()) {
                Player member = Bukkit.getPlayer((UUID)memberId);
                if (member == null) continue;
                member.sendMessage(String.valueOf(ChatColor.YELLOW) + player.getName() + " has left the team.");
                Teams999.this.updatePlayerDisplay(member);
            }
        }

        public void promotePlayer(Player sender, String targetName) {
            Team team = this.playerTeams.get(sender.getUniqueId());
            if (team == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
                return;
            }
            if (!team.getOwner().equals(sender.getUniqueId())) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner can promote players.");
                return;
            }
            Player target = Bukkit.getPlayer((String)targetName);
            if (target == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player '" + targetName + "' not found or is offline.");
                return;
            }
            if (!team.getMembers().contains(target.getUniqueId())) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " is not a member of your team.");
                return;
            }
            if (team.getOfficers().contains(target.getUniqueId())) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " is already an officer.");
                return;
            }
            team.getMembers().remove(target.getUniqueId());
            team.getOfficers().add(target.getUniqueId());
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Promoted " + target.getName() + " to Officer.");
            target.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been promoted to Officer in team '" + team.getName() + "'!");
            Teams999.this.updatePlayerDisplay(target);
            Teams999.this.updatePlayerDisplay(sender);
            for (UUID memberId : team.getAllMembers()) {
                Player member = Bukkit.getPlayer((UUID)memberId);
                if (member == null || member.getUniqueId().equals(sender.getUniqueId()) || member.getUniqueId().equals(target.getUniqueId())) continue;
                member.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + " has been promoted to Officer.");
                Teams999.this.updatePlayerDisplay(member);
            }
        }

        public void demotePlayer(Player sender, String targetName) {
            Team team = this.playerTeams.get(sender.getUniqueId());
            if (team == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
                return;
            }
            if (!team.getOwner().equals(sender.getUniqueId())) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner can demote players.");
                return;
            }
            Player target = Bukkit.getPlayer((String)targetName);
            if (target == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player '" + targetName + "' not found or is offline.");
                return;
            }
            if (!team.getOfficers().contains(target.getUniqueId())) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " is not an officer in your team.");
                return;
            }
            team.getOfficers().remove(target.getUniqueId());
            team.getMembers().add(target.getUniqueId());
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Demoted " + target.getName() + " to Member.");
            target.sendMessage(String.valueOf(ChatColor.YELLOW) + "You have been demoted to Member in team '" + team.getName() + "'.");
            Teams999.this.updatePlayerDisplay(target);
            Teams999.this.updatePlayerDisplay(sender);
            for (UUID memberId : team.getAllMembers()) {
                Player member = Bukkit.getPlayer((UUID)memberId);
                if (member == null || member.getUniqueId().equals(sender.getUniqueId()) || member.getUniqueId().equals(target.getUniqueId())) continue;
                member.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + " has been demoted to Member.");
                Teams999.this.updatePlayerDisplay(member);
            }
        }

        public void showTeamInfo(Player player) {
            Team team = this.playerTeams.get(player.getUniqueId());
            if (team == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
                return;
            }
            Inventory gui = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.BLUE) + "Team Info: " + team.getName()));
            ItemStack infoItem = new ItemStack(Material.BOOK);
            ItemMeta infoMeta = infoItem.getItemMeta();
            infoMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + team.getName());
            ArrayList<CallSite> infoLore = new ArrayList<CallSite>();
            infoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Owner: " + String.valueOf(ChatColor.WHITE) + Bukkit.getOfflinePlayer((UUID)team.getOwner()).getName())));
            infoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Total Members: " + String.valueOf(ChatColor.WHITE) + team.getAllMembers().size())));
            infoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Officers: " + String.valueOf(ChatColor.WHITE) + team.getOfficers().size())));
            infoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Home: " + String.valueOf(ChatColor.WHITE) + (team.getHome() != null ? "Set" : "Not Set"))));
            infoMeta.setLore(infoLore);
            infoItem.setItemMeta(infoMeta);
            gui.setItem(4, infoItem);
            int slot = 9;
            ItemStack ownerHead = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta ownerMeta = (SkullMeta)ownerHead.getItemMeta();
            ownerMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)team.getOwner()));
            ownerMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + Bukkit.getOfflinePlayer((UUID)team.getOwner()).getName() + " (Owner)");
            ownerHead.setItemMeta((ItemMeta)ownerMeta);
            gui.setItem(slot++, ownerHead);
            for (UUID officerId : team.getOfficers()) {
                ItemStack officerHead = new ItemStack(Material.PLAYER_HEAD);
                SkullMeta officerMeta = (SkullMeta)officerHead.getItemMeta();
                officerMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)officerId));
                officerMeta.setDisplayName(String.valueOf(ChatColor.BLUE) + Bukkit.getOfflinePlayer((UUID)officerId).getName() + " (Officer)");
                officerHead.setItemMeta((ItemMeta)officerMeta);
                gui.setItem(slot++, officerHead);
            }
            for (UUID memberId : team.getMembers()) {
                if (team.getOwner().equals(memberId) || team.getOfficers().contains(memberId)) continue;
                ItemStack memberHead = new ItemStack(Material.PLAYER_HEAD);
                SkullMeta memberMeta = (SkullMeta)memberHead.getItemMeta();
                memberMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)memberId));
                memberMeta.setDisplayName(String.valueOf(ChatColor.WHITE) + Bukkit.getOfflinePlayer((UUID)memberId).getName() + " (Member)");
                memberHead.setItemMeta((ItemMeta)memberMeta);
                gui.setItem(slot++, memberHead);
            }
            player.openInventory(gui);
        }

        public void listOnlineMembers(Player player) {
            Team team = this.playerTeams.get(player.getUniqueId());
            if (team == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
                return;
            }
            ArrayList<CallSite> onlineMembers = new ArrayList<CallSite>();
            ArrayList<CallSite> onlineOfficers = new ArrayList<CallSite>();
            Player owner = Bukkit.getPlayer((UUID)team.getOwner());
            if (owner != null && owner.isOnline()) {
                onlineMembers.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + owner.getName() + " (Owner)")));
            }
            for (UUID uUID : team.getOfficers()) {
                Player officer = Bukkit.getPlayer((UUID)uUID);
                if (officer == null || !officer.isOnline()) continue;
                onlineOfficers.add((CallSite)((Object)(String.valueOf(ChatColor.BLUE) + officer.getName() + " (Officer)")));
            }
            for (UUID uUID : team.getMembers()) {
                Player member;
                if (team.getOwner().equals(uUID) || team.getOfficers().contains(uUID) || (member = Bukkit.getPlayer((UUID)uUID)) == null || !member.isOnline()) continue;
                onlineMembers.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + member.getName() + " (Member)")));
            }
            if (onlineMembers.isEmpty() && onlineOfficers.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "No team members are currently online.");
                return;
            }
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "=== Online Team Members ===");
            for (String string : onlineMembers) {
                player.sendMessage(string);
            }
            for (String string : onlineOfficers) {
                player.sendMessage(string);
            }
        }

        public void setHome(Player player) {
            Team team = this.playerTeams.get(player.getUniqueId());
            if (team == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
                return;
            }
            if (!team.getOwner().equals(player.getUniqueId())) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Only the team owner can set the home location.");
                return;
            }
            team.setHome(player.getLocation());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Team home location set!");
        }

        public void teleportHome(Player player) {
            Team team = this.playerTeams.get(player.getUniqueId());
            if (team == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
                return;
            }
            if (team.getHome() == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Team home location is not set.");
                return;
            }
            player.teleport(team.getHome());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleported to team home!");
        }

        public void cleanupExpiredInvites() {
            long currentTime = System.currentTimeMillis();
            Iterator<Map.Entry<UUID, PendingInvite>> iterator = this.pendingInvites.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, PendingInvite> entry = iterator.next();
                if (currentTime - entry.getValue().getTimestamp() <= Teams999.this.inviteExpiryMillis) continue;
                Player player = Bukkit.getPlayer((UUID)entry.getKey());
                if (player != null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Your team invitation has expired.");
                }
                iterator.remove();
            }
        }

        public void loadFromConfig(FileConfiguration config) {
            this.teams.clear();
            this.playerTeams.clear();
            if (config.contains("teams")) {
                for (String teamName : config.getConfigurationSection("teams").getKeys(false)) {
                    try {
                        Object memberIdStr2;
                        String ownerIdStr = config.getString("teams." + teamName + ".owner");
                        UUID ownerId = UUID.fromString(ownerIdStr);
                        Team team = new Team(teamName, ownerId);
                        List memberIds = config.getStringList("teams." + teamName + ".members");
                        for (Object memberIdStr2 : memberIds) {
                            UUID memberId = UUID.fromString((String)memberIdStr2);
                            team.getMembers().add(memberId);
                            this.playerTeams.put(memberId, team);
                        }
                        List officerIds = config.getStringList("teams." + teamName + ".officers");
                        memberIdStr2 = officerIds.iterator();
                        while (memberIdStr2.hasNext()) {
                            String officerIdStr = (String)memberIdStr2.next();
                            UUID officerId = UUID.fromString(officerIdStr);
                            team.getOfficers().add(officerId);
                            this.playerTeams.put(officerId, team);
                        }
                        if (config.contains("teams." + teamName + ".home")) {
                            Location home = (Location)config.get("teams." + teamName + ".home");
                            team.setHome(home);
                        }
                        this.teams.put(teamName.toLowerCase(), team);
                        this.playerTeams.put(ownerId, team);
                    }
                    catch (Exception e) {
                        Bukkit.getLogger().warning("Failed to load team: " + teamName + " - " + e.getMessage());
                    }
                }
            }
        }

        public void saveToConfig(FileConfiguration config) {
            config.set("teams", null);
            for (Team team : this.teams.values()) {
                String teamName = team.getName();
                config.set("teams." + teamName + ".owner", (Object)team.getOwner().toString());
                ArrayList<String> memberIds = new ArrayList<String>();
                for (UUID memberId : team.getMembers()) {
                    if (team.getOwner().equals(memberId) || team.getOfficers().contains(memberId)) continue;
                    memberIds.add(memberId.toString());
                }
                config.set("teams." + teamName + ".members", memberIds);
                ArrayList<String> officerIds = new ArrayList<String>();
                for (UUID officerId : team.getOfficers()) {
                    officerIds.add(officerId.toString());
                }
                config.set("teams." + teamName + ".officers", officerIds);
                if (team.getHome() == null) continue;
                config.set("teams." + teamName + ".home", (Object)team.getHome());
            }
        }
    }

    public class Team {
        private String name;
        private UUID owner;
        private Set<UUID> members;
        private Set<UUID> officers;
        private Location home;

        public Team(String name, UUID ownerId) {
            this.name = name;
            this.owner = ownerId;
            this.members = new HashSet<UUID>();
            this.officers = new HashSet<UUID>();
            this.members.add(ownerId);
        }

        public String getName() {
            return this.name;
        }

        public UUID getOwner() {
            return this.owner;
        }

        public Set<UUID> getMembers() {
            return this.members;
        }

        public Set<UUID> getOfficers() {
            return this.officers;
        }

        public Location getHome() {
            return this.home;
        }

        public void setHome(Location home) {
            this.home = home;
        }

        public Set<UUID> getAllMembers() {
            HashSet<UUID> all = new HashSet<UUID>();
            all.add(this.owner);
            all.addAll(this.officers);
            all.addAll(this.members);
            return all;
        }
    }

    public class PendingInvite {
        private Team team;
        private UUID inviter;
        private long timestamp;

        public PendingInvite(Team team, UUID inviter, long timestamp) {
            this.team = team;
            this.inviter = inviter;
            this.timestamp = timestamp;
        }

        public Team getTeam() {
            return this.team;
        }

        public UUID getInviter() {
            return this.inviter;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

