/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.game;

import dev.doctor4t.trainmurdermystery.api.GameMode;
import dev.doctor4t.trainmurdermystery.api.TMMRoles;
import dev.doctor4t.trainmurdermystery.cca.GameRoundEndComponent;
import dev.doctor4t.trainmurdermystery.cca.GameTimeComponent;
import dev.doctor4t.trainmurdermystery.cca.GameWorldComponent;
import dev.doctor4t.trainmurdermystery.cca.PlayerShopComponent;
import dev.doctor4t.trainmurdermystery.cca.ScoreboardRoleSelectorComponent;
import dev.doctor4t.trainmurdermystery.cca.TrainWorldComponent;
import dev.doctor4t.trainmurdermystery.client.gui.RoleAnnouncementTexts;
import dev.doctor4t.trainmurdermystery.game.GameConstants;
import dev.doctor4t.trainmurdermystery.game.GameFunctions;
import dev.doctor4t.trainmurdermystery.util.AnnounceWelcomePayload;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

public class MurderGameMode
extends GameMode {
    public MurderGameMode(class_2960 identifier) {
        super(identifier, 10, 6);
    }

    private static int assignRolesAndGetKillerCount(@NotNull class_3218 world, @NotNull List<class_3222> players, GameWorldComponent gameComponent) {
        for (class_3222 player : players) {
            gameComponent.addRole((class_1657)player, TMMRoles.CIVILIAN);
        }
        ScoreboardRoleSelectorComponent roleSelector = (ScoreboardRoleSelectorComponent)ScoreboardRoleSelectorComponent.KEY.get((Object)world.method_14170());
        int killerCount = (int)Math.floor((float)players.size() / 6.0f);
        int total = roleSelector.assignKillers(world, gameComponent, players, killerCount);
        roleSelector.assignVigilantes(world, gameComponent, players, killerCount);
        return total;
    }

    @Override
    public void initializeGame(class_3218 serverWorld, GameWorldComponent gameWorldComponent, List<class_3222> players) {
        ((TrainWorldComponent)TrainWorldComponent.KEY.get((Object)serverWorld)).setTimeOfDay(TrainWorldComponent.TimeOfDay.NIGHT);
        int killerCount = MurderGameMode.assignRolesAndGetKillerCount(serverWorld, players, gameWorldComponent);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new AnnounceWelcomePayload(RoleAnnouncementTexts.ROLE_ANNOUNCEMENT_TEXTS.indexOf(gameWorldComponent.isRole((class_1657)player, TMMRoles.KILLER) ? RoleAnnouncementTexts.KILLER : (gameWorldComponent.isRole((class_1657)player, TMMRoles.VIGILANTE) ? RoleAnnouncementTexts.VIGILANTE : RoleAnnouncementTexts.CIVILIAN)), killerCount, players.size() - killerCount));
        }
    }

    @Override
    public void tickServerGameLoop(class_3218 serverWorld, GameWorldComponent gameWorldComponent) {
        GameFunctions.WinStatus winStatus = GameFunctions.WinStatus.NONE;
        if (!((GameTimeComponent)GameTimeComponent.KEY.get((Object)serverWorld)).hasTime()) {
            winStatus = GameFunctions.WinStatus.TIME;
        }
        boolean civilianAlive = false;
        for (class_3222 class_32222 : serverWorld.method_18456()) {
            Integer balanceToAdd = GameConstants.PASSIVE_MONEY_TICKER.apply(serverWorld.method_8510());
            if (balanceToAdd > 0) {
                ((PlayerShopComponent)PlayerShopComponent.KEY.get((Object)class_32222)).addToBalance(balanceToAdd);
            }
            if (!gameWorldComponent.isInnocent((class_1657)class_32222) || GameFunctions.isPlayerEliminated((class_1657)class_32222)) continue;
            civilianAlive = true;
        }
        if (!civilianAlive) {
            winStatus = GameFunctions.WinStatus.KILLERS;
        }
        if (winStatus == GameFunctions.WinStatus.NONE) {
            winStatus = GameFunctions.WinStatus.PASSENGERS;
            for (UUID uUID : gameWorldComponent.getAllKillerTeamPlayers()) {
                if (GameFunctions.isPlayerEliminated(serverWorld.method_18470(uUID))) continue;
                winStatus = GameFunctions.WinStatus.NONE;
            }
        }
        if (winStatus != GameFunctions.WinStatus.NONE && gameWorldComponent.getGameStatus() == GameWorldComponent.GameStatus.ACTIVE) {
            ((GameRoundEndComponent)GameRoundEndComponent.KEY.get((Object)serverWorld)).setRoundEndData(serverWorld.method_18456(), winStatus);
            GameFunctions.stopGame(serverWorld);
        }
    }
}

