/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.cca;

import dev.doctor4t.trainmurdermystery.TMM;
import dev.doctor4t.trainmurdermystery.api.TMMRoles;
import dev.doctor4t.trainmurdermystery.cca.GameRoundEndComponent;
import dev.doctor4t.trainmurdermystery.cca.GameTimeComponent;
import dev.doctor4t.trainmurdermystery.cca.PlayerShopComponent;
import dev.doctor4t.trainmurdermystery.cca.TrainWorldComponent;
import dev.doctor4t.trainmurdermystery.game.GameConstants;
import dev.doctor4t.trainmurdermystery.game.GameFunctions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ClientTickingComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class GameWorldComponent
implements AutoSyncedComponent,
ServerTickingComponent,
ClientTickingComponent {
    public static final ComponentKey<GameWorldComponent> KEY = ComponentRegistry.getOrCreate((class_2960)TMM.id("game"), GameWorldComponent.class);
    private final class_1937 world;
    private boolean lockedToSupporters = false;
    private boolean enableWeights = false;
    private GameMode gameMode = GameMode.MURDER;
    private boolean bound = true;
    private GameStatus gameStatus = GameStatus.INACTIVE;
    private int fade = 0;
    private final HashMap<UUID, TMMRoles.Role> roles = new HashMap();
    private int ticksUntilNextResetAttempt = -1;
    private int psychosActive = 0;
    private UUID looseEndWinner;

    public void setWeightsEnabled(boolean enabled) {
        this.enableWeights = enabled;
    }

    public boolean areWeightsEnabled() {
        return this.enableWeights;
    }

    public GameWorldComponent(class_1937 world) {
        this.world = world;
    }

    public void sync() {
        KEY.sync((Object)this.world);
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bound) {
        this.bound = bound;
        this.sync();
    }

    public int getFade() {
        return this.fade;
    }

    public void setFade(int fade) {
        this.fade = class_3532.method_15340((int)fade, (int)0, (int)60);
    }

    public void setGameStatus(GameStatus gameStatus) {
        this.gameStatus = gameStatus;
        this.sync();
    }

    public GameStatus getGameStatus() {
        return this.gameStatus;
    }

    public boolean isRunning() {
        return this.gameStatus == GameStatus.ACTIVE || this.gameStatus == GameStatus.STOPPING;
    }

    public void addRole(class_1657 player, TMMRoles.Role role) {
        this.addRole(player.method_5667(), role);
    }

    public void addRole(UUID player, TMMRoles.Role role) {
        this.roles.put(player, role);
    }

    public void resetRole(TMMRoles.Role role) {
        this.roles.entrySet().removeIf(entry -> entry.getValue() == role);
    }

    public void setRoles(List<UUID> players, TMMRoles.Role role) {
        this.resetRole(role);
        for (UUID player : players) {
            this.addRole(player, role);
        }
    }

    public HashMap<UUID, TMMRoles.Role> getRoles() {
        return this.roles;
    }

    public TMMRoles.Role getRole(class_1657 player) {
        return this.getRole(player.method_5667());
    }

    @Nullable
    public TMMRoles.Role getRole(UUID uuid) {
        return this.roles.get(uuid);
    }

    public List<UUID> getAllWithRole(TMMRoles.Role role) {
        ArrayList<UUID> ret = new ArrayList<UUID>();
        this.roles.forEach((uuid, playerRole) -> {
            if (playerRole == role) {
                ret.add((UUID)uuid);
            }
        });
        return ret;
    }

    public boolean isRole(@NotNull class_1657 player, TMMRoles.Role role) {
        return this.isRole(player.method_5667(), role);
    }

    public boolean isRole(@NotNull UUID uuid, TMMRoles.Role role) {
        return this.roles.get(uuid) == role;
    }

    public boolean isInnocent(@NotNull class_1657 player) {
        return this.getRole(player) == null || this.getRole(player).isInnocent();
    }

    public void clearRoleMap() {
        this.roles.clear();
        this.setPsychosActive(0);
    }

    public void queueTrainReset() {
        this.ticksUntilNextResetAttempt = 20;
    }

    public int getPsychosActive() {
        return this.psychosActive;
    }

    public boolean isPsychoActive() {
        return this.psychosActive > 0;
    }

    public void setPsychosActive(int psychosActive) {
        this.psychosActive = Math.max(0, psychosActive);
        this.sync();
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(GameMode discoveryMode) {
        this.gameMode = discoveryMode;
        this.sync();
    }

    public UUID getLooseEndWinner() {
        return this.looseEndWinner;
    }

    public void setLooseEndWinner(UUID looseEndWinner) {
        this.looseEndWinner = looseEndWinner;
        this.sync();
    }

    public boolean isLockedToSupporters() {
        return this.lockedToSupporters;
    }

    public void setLockedToSupporters(boolean lockedToSupporters) {
        this.lockedToSupporters = lockedToSupporters;
    }

    public void readFromNbt(@NotNull class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        this.lockedToSupporters = nbtCompound.method_10577("LockedToSupporters");
        this.enableWeights = nbtCompound.method_10577("EnableWeights");
        this.gameMode = GameMode.valueOf(nbtCompound.method_10558("GameMode"));
        this.gameStatus = GameStatus.valueOf(nbtCompound.method_10558("GameStatus"));
        this.fade = nbtCompound.method_10550("Fade");
        this.psychosActive = nbtCompound.method_10550("PsychosActive");
        for (TMMRoles.Role role : TMMRoles.ROLES) {
            this.setRoles(this.uuidListFromNbt(nbtCompound, role.identifier().toString()), role);
        }
        this.looseEndWinner = nbtCompound.method_10545("LooseEndWinner") ? nbtCompound.method_25926("LooseEndWinner") : null;
    }

    private ArrayList<UUID> uuidListFromNbt(class_2487 nbtCompound, String listName) {
        ArrayList<UUID> ret = new ArrayList<UUID>();
        for (class_2520 e : nbtCompound.method_10554(listName, 11)) {
            ret.add(class_2512.method_25930((class_2520)e));
        }
        return ret;
    }

    public void writeToNbt(@NotNull class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        nbtCompound.method_10556("LockedToSupporters", this.lockedToSupporters);
        nbtCompound.method_10556("EnableWeights", this.enableWeights);
        nbtCompound.method_10582("GameMode", this.gameMode.name());
        nbtCompound.method_10582("GameStatus", this.gameStatus.toString());
        nbtCompound.method_10569("Fade", this.fade);
        nbtCompound.method_10569("PsychosActive", this.psychosActive);
        for (TMMRoles.Role role : TMMRoles.ROLES) {
            nbtCompound.method_10566(role.identifier().toString(), (class_2520)this.nbtFromUuidList(this.getAllWithRole(role)));
        }
        if (this.looseEndWinner != null) {
            nbtCompound.method_25927("LooseEndWinner", this.looseEndWinner);
        }
    }

    private class_2499 nbtFromUuidList(List<UUID> list) {
        class_2499 ret = new class_2499();
        for (UUID player : list) {
            ret.add((Object)class_2512.method_25929((UUID)player));
        }
        return ret;
    }

    public void clientTick() {
        this.tickCommon();
    }

    public void serverTick() {
        this.tickCommon();
        if (this.ticksUntilNextResetAttempt-- == 0 && GameFunctions.tryResetTrain((class_3218)this.world)) {
            this.ticksUntilNextResetAttempt = 5;
        }
        class_3218 serverWorld = (class_3218)this.world;
        if (this.world.method_8510() % 20L == 0L) {
            for (Object player : serverWorld.method_18456()) {
                if (this.isRunning() || (!player.method_7325() || serverWorld.method_8503().method_3835(player.method_7334()) >= 2) && (!GameFunctions.isPlayerAliveAndSurvival((class_1657)player) || !GameConstants.PLAY_AREA.method_1006(player.method_19538()))) continue;
                GameFunctions.resetPlayer((class_3222)player);
            }
        }
        if (serverWorld.method_8503().method_30002().equals(serverWorld)) {
            TrainWorldComponent trainComponent = (TrainWorldComponent)TrainWorldComponent.KEY.get((Object)serverWorld);
            if (trainComponent.getSpeed() > 0) {
                for (class_3222 player : serverWorld.method_18456()) {
                    if (GameFunctions.isPlayerAliveAndSurvival((class_1657)player) || !this.isBound()) continue;
                    GameFunctions.limitPlayerToBox(player, GameConstants.PLAY_AREA);
                }
            }
            if (this.isRunning()) {
                boolean civilianAlive = false;
                for (Object player : serverWorld.method_18456()) {
                    Integer balanceToAdd;
                    if (GameFunctions.isPlayerAliveAndSurvival((class_1657)player) && player.method_23318() < GameConstants.PLAY_AREA.field_1322) {
                        class_1657 killerPlayer;
                        class_1309 class_13092 = player.method_49107();
                        GameFunctions.killPlayer((class_1657)player, false, class_13092 instanceof class_1657 ? (killerPlayer = (class_1657)class_13092) : null, TMM.id("fell_out_of_train"));
                    }
                    if ((balanceToAdd = GameConstants.PASSIVE_MONEY_TICKER.apply(this.world.method_8510())) > 0) {
                        ((PlayerShopComponent)PlayerShopComponent.KEY.get(player)).addToBalance(balanceToAdd);
                    }
                    if (!this.isInnocent((class_1657)player) || GameFunctions.isPlayerEliminated((class_1657)player)) continue;
                    civilianAlive = true;
                }
                GameFunctions.WinStatus winStatus = GameFunctions.WinStatus.NONE;
                if (this.gameMode == GameMode.MURDER) {
                    if (!civilianAlive) {
                        winStatus = GameFunctions.WinStatus.KILLERS;
                    }
                    if (winStatus == GameFunctions.WinStatus.NONE) {
                        winStatus = GameFunctions.WinStatus.PASSENGERS;
                        for (UUID player : this.getAllWithRole(TMMRoles.KILLER)) {
                            if (GameFunctions.isPlayerEliminated(serverWorld.method_18470(player))) continue;
                            winStatus = GameFunctions.WinStatus.NONE;
                        }
                    }
                }
                if (this.gameMode == GameMode.LOOSE_ENDS) {
                    int playersLeft = 0;
                    class_1657 lastPlayer = null;
                    for (class_1657 player : this.world.method_18456()) {
                        if (!GameFunctions.isPlayerAliveAndSurvival(player)) continue;
                        ++playersLeft;
                        lastPlayer = player;
                    }
                    if (playersLeft <= 0) {
                        GameFunctions.stopGame(serverWorld);
                    }
                    if (playersLeft == 1) {
                        this.setLooseEndWinner(lastPlayer.method_5667());
                        winStatus = GameFunctions.WinStatus.LOOSE_END;
                    }
                }
                if (winStatus == GameFunctions.WinStatus.NONE && !((GameTimeComponent)GameTimeComponent.KEY.get((Object)serverWorld)).hasTime()) {
                    winStatus = GameFunctions.WinStatus.TIME;
                }
                if (this.gameMode == GameMode.DISCOVERY && winStatus == GameFunctions.WinStatus.TIME) {
                    GameFunctions.stopGame(serverWorld);
                }
                if (winStatus != GameFunctions.WinStatus.NONE && this.gameStatus == GameStatus.ACTIVE) {
                    ((GameRoundEndComponent)GameRoundEndComponent.KEY.get((Object)serverWorld)).setRoundEndData(serverWorld.method_18456(), winStatus);
                    for (UUID player : serverWorld.method_18456()) {
                        if (winStatus != GameFunctions.WinStatus.TIME || !this.isRole((class_1657)player, TMMRoles.KILLER)) continue;
                        GameFunctions.killPlayer((class_1657)player, true, null);
                    }
                    GameFunctions.stopGame(serverWorld);
                }
            }
            if (this.world.method_8510() % 20L == 0L) {
                this.sync();
            }
        }
    }

    private void tickCommon() {
        if (this.getGameStatus() == GameStatus.STARTING || this.getGameStatus() == GameStatus.STOPPING) {
            class_1937 class_19372;
            this.setFade(this.fade + 1);
            if (this.getFade() >= 60 && (class_19372 = this.world) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                if (this.getGameStatus() == GameStatus.STARTING) {
                    GameFunctions.initializeGame(serverWorld);
                }
                if (this.getGameStatus() == GameStatus.STOPPING) {
                    GameFunctions.finalizeGame(serverWorld);
                }
            }
        } else if (this.getGameStatus() == GameStatus.ACTIVE || this.getGameStatus() == GameStatus.INACTIVE) {
            this.setFade(this.fade - 1);
        }
    }

    public static enum GameMode implements class_3542
    {
        MURDER(10),
        DISCOVERY(10),
        LOOSE_ENDS(60);

        public final int startTime;

        private GameMode(int startTime) {
            this.startTime = startTime;
        }

        public String method_15434() {
            return this.name();
        }
    }

    public static enum GameStatus {
        INACTIVE,
        STARTING,
        ACTIVE,
        STOPPING;

    }
}

