/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.client.gui;

import dev.doctor4t.trainmurdermystery.api.TMMRoles;
import dev.doctor4t.trainmurdermystery.cca.GameWorldComponent;
import dev.doctor4t.trainmurdermystery.cca.PlayerShopComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class StoreRenderer {
    public static MoneyNumberRenderer view = new MoneyNumberRenderer();
    public static float offsetDelta = 0.0f;

    public static void renderHud(class_327 renderer, @NotNull class_746 player, @NotNull class_332 context, float delta) {
        if (!((GameWorldComponent)GameWorldComponent.KEY.get((Object)player.method_37908())).isRole((class_1657)player, TMMRoles.KILLER)) {
            return;
        }
        int balance = ((PlayerShopComponent)PlayerShopComponent.KEY.get((Object)player)).balance;
        if (view.getTarget() != (float)balance) {
            offsetDelta = (float)balance > view.getTarget() ? 0.6f : -0.6f;
            view.setTarget(balance);
        }
        float r = offsetDelta > 0.0f ? 1.0f - offsetDelta : 1.0f;
        float g = offsetDelta < 0.0f ? 1.0f + offsetDelta : 1.0f;
        float b = 1.0f - Math.abs(offsetDelta);
        int colour = class_3532.method_15353((float)r, (float)g, (float)b) | 0xFF000000;
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)(context.method_51421() - 12), 6.0f, 0.0f);
        view.render(renderer, context, 0, 0, colour, delta);
        context.method_51448().method_22909();
        offsetDelta = class_3532.method_16439((float)(delta / 16.0f), (float)offsetDelta, (float)0.0f);
    }

    public static void tick() {
        view.update();
    }

    public static class MoneyNumberRenderer {
        private final List<ScrollingDigit> digits = new ArrayList<ScrollingDigit>();
        private float target;

        public void setTarget(float target) {
            this.target = target;
            int length = String.valueOf(target).length();
            while (this.digits.size() < length) {
                this.digits.add(new ScrollingDigit(this.digits.isEmpty()));
            }
            for (int i = 0; i < this.digits.size(); ++i) {
                if (i == 0) {
                    this.digits.get(i).setTarget((float)((double)target / Math.pow(10.0, i)));
                    continue;
                }
                this.digits.get(i).setTarget((int)((double)target / Math.pow(10.0, i)));
            }
        }

        public void update() {
            for (ScrollingDigit digit : this.digits) {
                digit.update();
            }
        }

        public void render(class_327 renderer, @NotNull class_332 context, int x, int y, int colour, float delta) {
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)x, (float)y, 0.0f);
            context.method_25303(renderer, "\ue781", 0, 0, colour);
            int offset = -8;
            for (ScrollingDigit digit : this.digits) {
                context.method_51448().method_22903();
                context.method_51448().method_46416((float)offset, 0.0f, 0.0f);
                digit.render(renderer, context, colour, delta);
                offset -= 8;
                context.method_51448().method_22909();
            }
            context.method_51448().method_22909();
        }

        public float getTarget() {
            return this.target;
        }
    }

    public static class ScrollingDigit {
        private final boolean force;
        private float target;
        private float value;
        private float lastValue;

        public ScrollingDigit(boolean force) {
            this.force = force;
        }

        public void update() {
            this.lastValue = this.value;
            this.value = class_3532.method_16439((float)0.15f, (float)this.value, (float)this.target);
            if (Math.abs(this.value - this.target) < 0.01f) {
                this.value = this.target;
            }
        }

        public void render(@NotNull class_327 renderer, @NotNull class_332 context, int colour, float delta) {
            if (class_3532.method_15375((float)this.lastValue) != class_3532.method_15375((float)this.value)) {
                class_746 class_7462 = class_310.method_1551().field_1724;
            }
            float value = class_3532.method_16439((float)delta, (float)this.lastValue, (float)this.value);
            int digit = class_3532.method_15375((float)value) % 10;
            int digitNext = class_3532.method_15375((float)(value + 1.0f)) % 10;
            float offset = value % 1.0f;
            colour &= 0xFFFFFF;
            context.method_51448().method_22903();
            class_4587 class_45872 = context.method_51448();
            float f = -offset;
            Objects.requireNonNull(renderer);
            class_45872.method_46416(0.0f, f * (float)(9 + 2), 0.0f);
            float alpha = (1.0f - Math.abs(offset)) * 255.0f;
            if (value < 1.0f && !this.force) {
                alpha *= value;
            }
            int baseColour = colour | (int)alpha << 24;
            int nextColour = colour | (int)(Math.abs(offset) * 255.0f) << 24;
            if ((baseColour & 0xFC000000) != 0) {
                context.method_25303(renderer, String.valueOf(digit), 0, 0, baseColour);
            }
            if ((nextColour & 0xFC000000) != 0) {
                String string = String.valueOf(digitNext);
                Objects.requireNonNull(renderer);
                context.method_25303(renderer, string, 0, 9 + 2, nextColour);
            }
            context.method_51448().method_22909();
        }

        public void setTarget(float target) {
            this.target = target;
        }
    }
}

