/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.client.particle;

import java.awt.Color;
import java.util.function.Function;
import net.minecraft.class_1921;
import net.minecraft.class_2960;

public class HandParticle {
    public float x = 0.0f;
    public float y = 0.0f;
    public float z = 0.0f;
    public float vx = 0.0f;
    public float vy = 0.0f;
    public float vz = 0.0f;
    public float age = 0.0f;
    public float maxAge;
    public float size = 1.0f;
    public class_2960 texture;
    public int light;
    public int frames = 1;
    public boolean loop = false;
    public float u0 = 0.0f;
    public float v0 = 0.0f;
    public float u1 = 1.0f;
    public float v1 = 1.0f;
    public float[] rColors = new float[]{1.0f};
    public float[] gColors = new float[]{1.0f};
    public float[] bColors = new float[]{1.0f};
    public float[] aColors = new float[]{1.0f};
    public Function<class_2960, class_1921> renderLayerFactory = class_1921::method_23580;

    public boolean tick(float dt) {
        this.age += dt;
        if (this.age >= this.maxAge) {
            return false;
        }
        this.x += this.vx * dt;
        this.y += this.vy * dt;
        this.z += this.vz * dt;
        return true;
    }

    public HandParticle setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public HandParticle setVelocity(float vx, float vy, float vz) {
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
        return this;
    }

    public HandParticle setTexture(class_2960 texture) {
        this.texture = texture;
        return this;
    }

    public HandParticle setMaxAge(float maxAge) {
        this.maxAge = maxAge + 1.0f;
        return this;
    }

    public HandParticle setAnimation(int frames, boolean shouldLoop) {
        this.frames = frames;
        this.loop = shouldLoop;
        return this;
    }

    public HandParticle setLight(int block, int sky) {
        block = Math.max(0, Math.min(15, block));
        sky = Math.max(0, Math.min(15, sky));
        this.light = sky << 20 | block << 4;
        return this;
    }

    public HandParticle setSize(float size) {
        this.size = size;
        return this;
    }

    public HandParticle setRenderLayer(Function<class_2960, class_1921> factory) {
        this.renderLayerFactory = factory;
        return this;
    }

    public HandParticle setColor(Color ... colors) {
        if (colors.length == 0) {
            return this;
        }
        int n = colors.length;
        this.rColors = new float[n];
        this.gColors = new float[n];
        this.bColors = new float[n];
        this.aColors = new float[n];
        for (int i = 0; i < n; ++i) {
            Color c = colors[i];
            this.rColors[i] = (float)c.getRed() / 255.0f;
            this.gColors[i] = (float)c.getGreen() / 255.0f;
            this.bColors[i] = (float)c.getBlue() / 255.0f;
            this.aColors[i] = (float)c.getAlpha() / 255.0f;
        }
        return this;
    }

    public HandParticle setAlpha(float ... alphas) {
        if (alphas.length == 0) {
            return this;
        }
        this.aColors = new float[alphas.length];
        System.arraycopy(alphas, 0, this.aColors, 0, alphas.length);
        return this;
    }
}

