/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.cca;

import dev.doctor4t.trainmurdermystery.TMM;
import dev.doctor4t.trainmurdermystery.cca.GameWorldComponent;
import dev.doctor4t.trainmurdermystery.game.GameConstants;
import dev.doctor4t.trainmurdermystery.game.GameFunctions;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class AutoStartComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    public static final ComponentKey<AutoStartComponent> KEY = ComponentRegistry.getOrCreate((class_2960)TMM.id("autostart"), AutoStartComponent.class);
    public final class_1937 world;
    public int startTime;
    public int time;

    public AutoStartComponent(class_1937 world) {
        this.world = world;
    }

    public void sync() {
        KEY.sync((Object)this.world);
    }

    public void reset() {
        this.setTime(this.startTime);
    }

    public void tick() {
        if (((GameWorldComponent)GameWorldComponent.KEY.get((Object)this.world)).isRunning()) {
            return;
        }
        if (this.startTime <= 0 && this.time <= 0) {
            return;
        }
        if (GameFunctions.getReadyPlayerCount(this.world) >= 6) {
            class_1937 class_19372;
            if (this.time-- <= 0 && (class_19372 = this.world) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                if (((GameWorldComponent)GameWorldComponent.KEY.get((Object)this.world)).getGameStatus() == GameWorldComponent.GameStatus.INACTIVE) {
                    GameWorldComponent.GameMode gameMode = GameWorldComponent.GameMode.MURDER;
                    GameFunctions.startGame(serverWorld, gameMode, GameConstants.getInTicks(gameMode.startTime, 0));
                    return;
                }
            }
            if (this.getTime() % 20 == 0) {
                this.sync();
            }
        } else if (this.world.method_8510() % 20L == 0L) {
            this.setTime(this.startTime);
        }
    }

    public boolean isAutoStartActive() {
        return this.startTime > 0;
    }

    public boolean hasTime() {
        return this.time > 0;
    }

    public int getTime() {
        return this.time;
    }

    public void addTime(int time) {
        this.setTime(this.time + time);
    }

    public void setStartTime(int time) {
        this.startTime = time;
    }

    public void setTime(int time) {
        this.time = time;
        this.sync();
    }

    public void writeToNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10569("startTime", this.startTime);
        tag.method_10569("time", this.time);
    }

    public void readFromNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        this.startTime = tag.method_10550("startTime");
        this.time = tag.method_10550("time");
    }
}

