/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.cca;

import dev.doctor4t.trainmurdermystery.TMM;
import dev.doctor4t.trainmurdermystery.api.TMMRoles;
import dev.doctor4t.trainmurdermystery.cca.GameWorldComponent;
import dev.doctor4t.trainmurdermystery.client.gui.RoleAnnouncementTexts;
import dev.doctor4t.trainmurdermystery.index.TMMItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;

public class ScoreboardRoleSelectorComponent
implements AutoSyncedComponent {
    public static final ComponentKey<ScoreboardRoleSelectorComponent> KEY = ComponentRegistry.getOrCreate((class_2960)TMM.id("rolecounter"), ScoreboardRoleSelectorComponent.class);
    public final class_269 scoreboard;
    public final MinecraftServer server;
    public final Map<UUID, Integer> killerRounds = new HashMap<UUID, Integer>();
    public final Map<UUID, Integer> vigilanteRounds = new HashMap<UUID, Integer>();
    public final List<UUID> forcedKillers = new ArrayList<UUID>();
    public final List<UUID> forcedVigilantes = new ArrayList<UUID>();

    public ScoreboardRoleSelectorComponent(class_269 scoreboard, @Nullable MinecraftServer server) {
        this.scoreboard = scoreboard;
        this.server = server;
    }

    public int reset() {
        this.killerRounds.clear();
        this.vigilanteRounds.clear();
        return 1;
    }

    public void checkWeights(@NotNull class_2168 source) {
        double killerTotal = 0.0;
        double vigilanteTotal = 0.0;
        for (Object player : source.method_9225().method_18456()) {
            killerTotal += Math.exp(-this.killerRounds.getOrDefault(player.method_5667(), 0).intValue() * 4);
            vigilanteTotal += Math.exp(-this.vigilanteRounds.getOrDefault(player.method_5667(), 0).intValue() * 4);
        }
        class_5250 text = class_2561.method_43470((String)"Role Weights:").method_27692(class_124.field_1080);
        for (class_3222 player : source.method_9225().method_18456()) {
            text = text.method_27693("\n").method_10852(player.method_5476());
            Integer killerRounds = this.killerRounds.getOrDefault(player.method_5667(), 0);
            double killerWeight = Math.exp(-killerRounds.intValue() * 4);
            double killerPercent = killerWeight / killerTotal * 100.0;
            Integer vigilanteRounds = this.vigilanteRounds.getOrDefault(player.method_5667(), 0);
            double vigilanteWeight = Math.exp(-vigilanteRounds.intValue() * 4);
            double vigilantePercent = vigilanteWeight / vigilanteTotal * 100.0;
            text.method_10852((class_2561)class_2561.method_43470((String)"\n  Killer (").method_54663(RoleAnnouncementTexts.KILLER.colour).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(killerRounds)).method_54663(0x808080)).method_10852((class_2561)class_2561.method_43470((String)"): ").method_54663(RoleAnnouncementTexts.KILLER.colour)).method_10852((class_2561)class_2561.method_43470((String)"%.2f%%".formatted(killerPercent)).method_54663(0x808080)));
            text.method_10852((class_2561)class_2561.method_43470((String)"\n  Vigilante (").method_54663(RoleAnnouncementTexts.VIGILANTE.colour).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(vigilanteRounds)).method_54663(0x808080)).method_10852((class_2561)class_2561.method_43470((String)"): ").method_54663(RoleAnnouncementTexts.VIGILANTE.colour)).method_10852((class_2561)class_2561.method_43470((String)"%.2f%%".formatted(vigilantePercent)).method_54663(0x808080)));
        }
        class_5250 finalText = text;
        source.method_9226(() -> finalText, false);
    }

    public void setKillerRounds(@NotNull class_2168 source, @NotNull class_3222 player, int times) {
        if (times < 0) {
            times = 0;
        }
        if (times == 0) {
            this.killerRounds.remove(player.method_5667());
        } else {
            this.killerRounds.put(player.method_5667(), times);
        }
        int finalTimes = times;
        source.method_9226(() -> class_2561.method_43470((String)"Set ").method_27692(class_124.field_1080).method_10852((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"'s Killer rounds to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(finalTimes)).method_54663(0x808080)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)), false);
    }

    public void setVigilanteRounds(@NotNull class_2168 source, @NotNull class_3222 player, int times) {
        if (times < 0) {
            times = 0;
        }
        if (times == 0) {
            this.vigilanteRounds.remove(player.method_5667());
        } else {
            this.vigilanteRounds.put(player.method_5667(), times);
        }
        int finalTimes = times;
        source.method_9226(() -> class_2561.method_43470((String)"Set ").method_27692(class_124.field_1080).method_10852((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"'s Vigilante rounds to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(finalTimes)).method_54663(0x808080)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)), false);
    }

    public int assignKillers(class_3218 world, GameWorldComponent gameComponent, @NotNull List<class_3222> players, int killerCount) {
        this.reduceKillers();
        ArrayList<UUID> killers = new ArrayList<UUID>();
        for (UUID uuid : this.forcedKillers) {
            killers.add(uuid);
            --killerCount;
            this.killerRounds.put(uuid, this.killerRounds.getOrDefault(uuid, 1) + 1);
        }
        this.forcedKillers.clear();
        HashMap<class_3222, Float> map = new HashMap<class_3222, Float>();
        float total = 0.0f;
        for (class_3222 player : players) {
            float weight = (float)Math.exp(-this.killerRounds.getOrDefault(player.method_5667(), 0).intValue() * 4);
            if (!((GameWorldComponent)GameWorldComponent.KEY.get((Object)world)).areWeightsEnabled()) {
                weight = 1.0f;
            }
            map.put(player, Float.valueOf(weight));
            total += weight;
        }
        block2: for (int i = 0; i < killerCount; ++i) {
            float random = world.method_8409().method_43057() * total;
            for (Map.Entry entry : map.entrySet()) {
                if (!((random -= ((Float)entry.getValue()).floatValue()) <= 0.0f)) continue;
                killers.add(((class_3222)entry.getKey()).method_5667());
                total -= ((Float)entry.getValue()).floatValue();
                map.remove(entry.getKey());
                this.killerRounds.put(((class_3222)entry.getKey()).method_5667(), this.killerRounds.getOrDefault(((class_3222)entry.getKey()).method_5667(), 1) + 1);
                continue block2;
            }
        }
        for (UUID player : killers) {
            gameComponent.addRole(player, TMMRoles.KILLER);
        }
        return killers.size();
    }

    private void reduceKillers() {
        int minimum = Integer.MAX_VALUE;
        for (Integer n : this.killerRounds.values()) {
            minimum = Math.min(minimum, n);
        }
        for (UUID uUID : this.killerRounds.keySet()) {
            this.killerRounds.put(uUID, this.killerRounds.get(uUID) - minimum);
        }
    }

    public void assignVigilantes(class_3218 world, GameWorldComponent gameComponent, @NotNull List<class_3222> players, int vigilanteCount) {
        this.reduceVigilantes();
        ArrayList<class_3222> vigilantes = new ArrayList<class_3222>();
        for (UUID uuid : this.forcedVigilantes) {
            class_3222 serverPlayer;
            class_1657 player = world.method_18470(uuid);
            if (!(player instanceof class_3222) || !players.contains(serverPlayer = (class_3222)player) || gameComponent.isRole((class_1657)serverPlayer, TMMRoles.KILLER)) continue;
            player.method_7270(new class_1799((class_1935)TMMItems.REVOLVER));
            gameComponent.addRole(player, TMMRoles.VIGILANTE);
            --vigilanteCount;
            this.vigilanteRounds.put(player.method_5667(), this.vigilanteRounds.getOrDefault(player.method_5667(), 1) + 1);
        }
        this.forcedVigilantes.clear();
        HashMap<class_3222, Float> map = new HashMap<class_3222, Float>();
        float total = 0.0f;
        for (class_3222 player : players) {
            if (gameComponent.isRole((class_1657)player, TMMRoles.KILLER)) continue;
            float weight = (float)Math.exp(-this.vigilanteRounds.getOrDefault(player.method_5667(), 0).intValue() * 4);
            if (!((GameWorldComponent)GameWorldComponent.KEY.get((Object)world)).areWeightsEnabled()) {
                weight = 1.0f;
            }
            map.put(player, Float.valueOf(weight));
            total += weight;
        }
        block2: for (int i = 0; i < vigilanteCount; ++i) {
            float random = world.method_8409().method_43057() * total;
            for (Map.Entry entry : map.entrySet()) {
                if (!((random -= ((Float)entry.getValue()).floatValue()) <= 0.0f)) continue;
                vigilantes.add((class_3222)entry.getKey());
                total -= ((Float)entry.getValue()).floatValue();
                map.remove(entry.getKey());
                this.vigilanteRounds.put(((class_3222)entry.getKey()).method_5667(), this.vigilanteRounds.getOrDefault(((class_3222)entry.getKey()).method_5667(), 1) + 1);
                continue block2;
            }
        }
        for (class_3222 player : vigilantes) {
            player.method_7270(new class_1799((class_1935)TMMItems.REVOLVER));
            gameComponent.addRole((class_1657)player, TMMRoles.VIGILANTE);
        }
    }

    private void reduceVigilantes() {
        int minimum = Integer.MAX_VALUE;
        for (Integer n : this.vigilanteRounds.values()) {
            minimum = Math.min(minimum, n);
        }
        for (UUID uUID : this.vigilanteRounds.keySet()) {
            this.vigilanteRounds.put(uUID, this.vigilanteRounds.get(uUID) - minimum);
        }
    }

    public void writeToNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        class_2499 killerRounds = new class_2499();
        for (Map.Entry<UUID, Integer> detail : this.killerRounds.entrySet()) {
            class_2487 compound = new class_2487();
            compound.method_25927("uuid", detail.getKey());
            compound.method_10569("times", detail.getValue().intValue());
            killerRounds.add((Object)compound);
        }
        tag.method_10566("killerRounds", (class_2520)killerRounds);
        class_2499 vigilanteRounds = new class_2499();
        for (Map.Entry<UUID, Integer> detail : this.vigilanteRounds.entrySet()) {
            class_2487 compound = new class_2487();
            compound.method_25927("uuid", detail.getKey());
            compound.method_10569("times", detail.getValue().intValue());
            vigilanteRounds.add((Object)compound);
        }
        tag.method_10566("vigilanteRounds", (class_2520)vigilanteRounds);
    }

    public void readFromNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        class_2487 compound;
        this.killerRounds.clear();
        for (class_2520 element : tag.method_10554("killerRounds", 10)) {
            compound = (class_2487)element;
            if (!compound.method_10545("uuid") || !compound.method_10545("times")) continue;
            this.killerRounds.put(compound.method_25926("uuid"), compound.method_10550("times"));
        }
        this.vigilanteRounds.clear();
        for (class_2520 element : tag.method_10554("vigilanteRounds", 10)) {
            compound = (class_2487)element;
            if (!compound.method_10545("uuid") || !compound.method_10545("times")) continue;
            this.vigilanteRounds.put(compound.method_25926("uuid"), compound.method_10550("times"));
        }
    }
}

