/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.client.gui.screen.ingame;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LimitedHandledScreen<T extends class_1703>
extends class_437
implements class_3936<T> {
    protected int backgroundWidth = 176;
    protected int backgroundHeight = 32;
    protected final T handler;
    @Nullable
    protected class_1735 focusedSlot;
    @Nullable
    private class_1735 touchDragSlotStart;
    @Nullable
    private class_1735 touchDropOriginSlot;
    @Nullable
    private class_1735 touchHoveredSlot;
    @Nullable
    private class_1735 lastClickedSlot;
    protected int x;
    protected int y;
    private boolean touchIsRightClickDrag;
    private class_1799 touchDragStack = class_1799.field_8037;
    private int touchDropX;
    private int touchDropY;
    private long touchDropTime;
    private class_1799 touchDropReturningStack = class_1799.field_8037;
    private long touchDropTimer;
    protected final Set<class_1735> cursorDragSlots = Sets.newHashSet();
    protected boolean cursorDragging;
    private int heldButtonType;
    private int heldButtonCode;
    private boolean cancelNextRelease;
    private int draggedStackRemainder;
    private long lastButtonClickTime;
    private int lastClickedButton;
    private boolean doubleClicking;

    public static int getYOffset() {
        return 134;
    }

    public LimitedHandledScreen(T handler, class_1661 inventory, class_2561 title) {
        super(title);
        this.handler = handler;
        this.cancelNextRelease = true;
    }

    protected void method_25426() {
        this.x = (this.field_22789 - this.backgroundWidth) / 2;
        this.y = (this.field_22790 - this.backgroundHeight) / 2;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        class_1799 itemStack;
        int l;
        int i = this.x;
        int j = this.y - LimitedHandledScreen.getYOffset();
        super.method_25394(context, mouseX, mouseY, delta);
        RenderSystem.disableDepthTest();
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)i, (float)j, 0.0f);
        this.focusedSlot = null;
        for (int k = 0; k < ((class_1703)this.handler).field_7761.size(); ++k) {
            class_1735 slot = (class_1735)((class_1703)this.handler).field_7761.get(k);
            if (!LimitedHandledScreen.isHotbarSlot(slot)) continue;
            this.drawSlot(context, slot);
            if (!this.isPointOverSlot(slot, mouseX, mouseY)) continue;
            this.focusedSlot = slot;
            l = slot.field_7873;
            int m = slot.field_7872;
            if (!this.focusedSlot.method_51306()) continue;
            LimitedHandledScreen.drawSlotHighlight(context, l, m, 0);
        }
        class_1799 class_17992 = itemStack = this.touchDragStack.method_7960() ? this.handler.method_34255() : this.touchDragStack;
        if (!itemStack.method_7960()) {
            int n = 8;
            l = this.touchDragStack.method_7960() ? 8 : 16;
            String string = null;
            if (!this.touchDragStack.method_7960() && this.touchIsRightClickDrag) {
                itemStack = itemStack.method_46651(class_3532.method_15386((float)((float)itemStack.method_7947() / 2.0f)));
            } else if (this.cursorDragging && this.cursorDragSlots.size() > 1 && (itemStack = itemStack.method_46651(this.draggedStackRemainder)).method_7960()) {
                string = String.valueOf(class_124.field_1054) + "0";
            }
            this.drawItem(context, itemStack, mouseX - i - 8, mouseY - j - l, string);
        }
        if (!this.touchDropReturningStack.method_7960()) {
            float f = (float)(class_156.method_658() - this.touchDropTime) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.touchDropReturningStack = class_1799.field_8037;
            }
            l = this.touchDropOriginSlot.field_7873 - this.touchDropX;
            int m = this.touchDropOriginSlot.field_7872 - this.touchDropY;
            int o = this.touchDropX + (int)((float)l * f);
            int p = this.touchDropY + (int)((float)m * f);
            this.drawItem(context, this.touchDropReturningStack, o, p, null);
        }
        context.method_51448().method_22909();
        RenderSystem.enableDepthTest();
    }

    private static boolean isHotbarSlot(class_1735 slot) {
        return slot.field_7874 >= 36 && slot.field_7874 <= 44;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_52752(context);
        this.drawBackground(context, delta, mouseX, mouseY);
    }

    public static void drawSlotHighlight(@NotNull class_332 context, int x, int y, int z) {
        context.method_51740(class_1921.method_51785(), x, y, x + 16, y + 16, -2130706433, -2130706433, z);
    }

    protected void drawMouseoverTooltip(class_332 context, int x, int y) {
        if (!this.handler.method_34255().method_7960() || this.focusedSlot == null || !this.focusedSlot.method_7681()) {
            return;
        }
        this.renderLimitedInventoryTooltip(context, this.focusedSlot.method_7677());
    }

    public void renderLimitedInventoryTooltip(class_332 context, class_1799 itemStack) {
        List<class_2561> tooltips = this.getTooltipFromItem(itemStack);
        ArrayList<class_2561> name = new ArrayList<class_2561>();
        name.add(tooltips.getFirst());
        tooltips.removeFirst();
        int nameWidth = this.field_22793.method_1727(itemStack.method_7964().getString());
        int tooltipWidth = 0;
        for (class_2561 text : tooltips) {
            int newWidth = this.field_22793.method_1727(text.getString());
            if (newWidth <= tooltipWidth) continue;
            tooltipWidth = newWidth;
        }
        context.method_51437(this.field_22793, name, itemStack.method_32347(), this.x + 76 - nameWidth / 2, this.y - 2);
        if (tooltipWidth > 0) {
            context.method_51437(this.field_22793, tooltips, itemStack.method_32347(), this.x + 76 - tooltipWidth / 2, this.y + 50);
        }
    }

    protected List<class_2561> getTooltipFromItem(class_1799 stack) {
        return LimitedHandledScreen.method_25408((class_310)this.field_22787, (class_1799)stack);
    }

    private void drawItem(class_332 context, class_1799 stack, int x, int y, String amountText) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 232.0f);
        context.method_51427(stack, x, y);
        context.method_51432(this.field_22793, stack, x, y - (this.touchDragStack.method_7960() ? 0 : 8), amountText);
        context.method_51448().method_22909();
    }

    protected abstract void drawBackground(class_332 var1, float var2, int var3, int var4);

    protected void drawSlot(class_332 context, class_1735 slot) {
        Pair pair;
        int k;
        int i = slot.field_7873;
        int j = slot.field_7872;
        class_1799 itemStack = slot.method_7677();
        boolean bl = false;
        boolean bl2 = slot == this.touchDragSlotStart && !this.touchDragStack.method_7960() && !this.touchIsRightClickDrag;
        class_1799 itemStack2 = this.handler.method_34255();
        String string = null;
        if (slot == this.touchDragSlotStart && !this.touchDragStack.method_7960() && this.touchIsRightClickDrag && !itemStack.method_7960()) {
            itemStack = itemStack.method_46651(itemStack.method_7947() / 2);
        } else if (this.cursorDragging && this.cursorDragSlots.contains(slot) && !itemStack2.method_7960()) {
            if (this.cursorDragSlots.size() == 1) {
                return;
            }
            if (class_1703.method_7592((class_1735)slot, (class_1799)itemStack2, (boolean)true) && this.handler.method_7615(slot)) {
                bl = true;
                k = Math.min(itemStack2.method_7914(), slot.method_7676(itemStack2));
                int l = slot.method_7677().method_7960() ? 0 : slot.method_7677().method_7947();
                int m = class_1703.method_7617(this.cursorDragSlots, (int)this.heldButtonType, (class_1799)itemStack2) + l;
                if (m > k) {
                    m = k;
                    string = class_124.field_1054.toString() + k;
                }
                itemStack = itemStack2.method_46651(m);
            } else {
                this.cursorDragSlots.remove(slot);
                this.calculateOffset();
            }
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        if (itemStack.method_7960() && LimitedHandledScreen.isHotbarSlot(slot) && (pair = slot.method_7679()) != null) {
            class_1058 sprite = (class_1058)this.field_22787.method_1549((class_2960)pair.getFirst()).apply((class_2960)pair.getSecond());
            context.method_25298(i, j, 0, 16, 16, sprite);
            bl2 = true;
        }
        if (!bl2) {
            if (bl) {
                context.method_25294(i, j, i + 16, j + 16, -2130706433);
            }
            k = slot.field_7873 + slot.field_7872 * this.backgroundWidth;
            if (slot.method_55059()) {
                context.method_55231(itemStack, i, j, k);
            } else {
                context.method_51428(itemStack, i, j, k);
            }
            context.method_51432(this.field_22793, itemStack, i, j, string);
        }
        context.method_51448().method_22909();
    }

    private void calculateOffset() {
        class_1799 itemStack = this.handler.method_34255();
        if (!itemStack.method_7960() && this.cursorDragging) {
            if (this.heldButtonType == 2) {
                this.draggedStackRemainder = itemStack.method_7914();
            } else {
                this.draggedStackRemainder = itemStack.method_7947();
                for (class_1735 slot : this.cursorDragSlots) {
                    class_1799 itemStack2 = slot.method_7677();
                    int i = itemStack2.method_7960() ? 0 : itemStack2.method_7947();
                    int j = Math.min(itemStack.method_7914(), slot.method_7676(itemStack));
                    int k = Math.min(class_1703.method_7617(this.cursorDragSlots, (int)this.heldButtonType, (class_1799)itemStack) + i, j);
                    this.draggedStackRemainder -= k - i;
                }
            }
        }
    }

    @Nullable
    private class_1735 getSlotAt(double x, double y) {
        for (int i = 0; i < ((class_1703)this.handler).field_7761.size(); ++i) {
            class_1735 slot = (class_1735)((class_1703)this.handler).field_7761.get(i);
            if (!this.isPointOverSlot(slot, x, y) || !LimitedHandledScreen.isHotbarSlot(slot)) continue;
            return slot;
        }
        return null;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        boolean bl = this.field_22787.field_1690.field_1871.method_1433(button) && this.field_22787.field_1761.method_2914();
        class_1735 slot = this.getSlotAt(mouseX, mouseY);
        long l = class_156.method_658();
        this.doubleClicking = this.lastClickedSlot == slot && l - this.lastButtonClickTime < 250L && this.lastClickedButton == button;
        this.cancelNextRelease = false;
        if (button != 0 && button != 1 && !bl) {
            this.onMouseClick(button);
        } else {
            int i = this.x;
            int j = this.y;
            boolean bl2 = this.isClickOutsideBounds(mouseX, mouseY, i, j, button);
            int k = -1;
            if (slot != null) {
                k = slot.field_7874;
            }
            if (((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue() && bl2 && this.handler.method_34255().method_7960()) {
                this.method_25419();
                return true;
            }
            if (k != -1) {
                if (((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue()) {
                    if (slot != null && slot.method_7681()) {
                        this.touchDragSlotStart = slot;
                        this.touchDragStack = class_1799.field_8037;
                        this.touchIsRightClickDrag = button == 1;
                    } else {
                        this.touchDragSlotStart = null;
                    }
                } else if (!this.cursorDragging) {
                    if (this.handler.method_34255().method_7960()) {
                        if (bl) {
                            this.onMouseClick(slot, k, button, class_1713.field_7796);
                        } else {
                            class_1713 slotActionType = class_1713.field_7790;
                            this.onMouseClick(slot, k, button, slotActionType);
                        }
                        this.cancelNextRelease = true;
                    } else {
                        this.cursorDragging = true;
                        this.heldButtonCode = button;
                        this.cursorDragSlots.clear();
                        if (button == 0) {
                            this.heldButtonType = 0;
                        } else if (button == 1) {
                            this.heldButtonType = 1;
                        } else if (bl) {
                            this.heldButtonType = 2;
                        }
                    }
                }
            }
        }
        this.lastClickedSlot = slot;
        this.lastButtonClickTime = l;
        this.lastClickedButton = button;
        return true;
    }

    private void onMouseClick(int button) {
        if (this.focusedSlot != null && this.handler.method_34255().method_7960()) {
            if (this.field_22787.field_1690.field_1831.method_1433(button)) {
                this.onMouseClick(this.focusedSlot, this.focusedSlot.field_7874, 40, class_1713.field_7791);
                return;
            }
            for (int i = 0; i < 9; ++i) {
                if (!this.field_22787.field_1690.field_1852[i].method_1433(button)) continue;
                this.onMouseClick(this.focusedSlot, this.focusedSlot.field_7874, i, class_1713.field_7791);
            }
        }
    }

    protected boolean isClickOutsideBounds(double mouseX, double mouseY, int left, int top, int button) {
        return mouseX < (double)left || mouseY < (double)top || mouseX >= (double)(left + this.backgroundWidth) || mouseY >= (double)(top + this.backgroundHeight);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        class_1735 slot = this.getSlotAt(mouseX, mouseY);
        class_1799 itemStack = this.handler.method_34255();
        if (this.touchDragSlotStart != null && ((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue()) {
            if (button == 0 || button == 1) {
                if (this.touchDragStack.method_7960()) {
                    if (slot != this.touchDragSlotStart && !this.touchDragSlotStart.method_7677().method_7960()) {
                        this.touchDragStack = this.touchDragSlotStart.method_7677().method_7972();
                    }
                } else if (this.touchDragStack.method_7947() > 1 && slot != null && class_1703.method_7592((class_1735)slot, (class_1799)this.touchDragStack, (boolean)false)) {
                    long l = class_156.method_658();
                    if (this.touchHoveredSlot == slot) {
                        if (l - this.touchDropTimer > 500L) {
                            this.onMouseClick(this.touchDragSlotStart, this.touchDragSlotStart.field_7874, 0, class_1713.field_7790);
                            this.onMouseClick(slot, slot.field_7874, 1, class_1713.field_7790);
                            this.onMouseClick(this.touchDragSlotStart, this.touchDragSlotStart.field_7874, 0, class_1713.field_7790);
                            this.touchDropTimer = l + 750L;
                            this.touchDragStack.method_7934(1);
                        }
                    } else {
                        this.touchHoveredSlot = slot;
                        this.touchDropTimer = l;
                    }
                }
            }
        } else if (this.cursorDragging && slot != null && !itemStack.method_7960() && (itemStack.method_7947() > this.cursorDragSlots.size() || this.heldButtonType == 2) && class_1703.method_7592((class_1735)slot, (class_1799)itemStack, (boolean)true) && slot.method_7680(itemStack) && this.handler.method_7615(slot)) {
            this.cursorDragSlots.add(slot);
            this.calculateOffset();
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        class_1735 slot = this.getSlotAt(mouseX, mouseY);
        int i = this.x;
        int j = this.y;
        int k = -1;
        if (slot != null) {
            k = slot.field_7874;
        }
        if (this.doubleClicking && slot != null && button == 0 && this.handler.method_7613(class_1799.field_8037, slot)) {
            this.onMouseClick(slot, k, button, class_1713.field_7793);
            this.doubleClicking = false;
            this.lastButtonClickTime = 0L;
        } else {
            if (this.cursorDragging && this.heldButtonCode != button) {
                this.cursorDragging = false;
                this.cursorDragSlots.clear();
                this.cancelNextRelease = true;
                return true;
            }
            if (this.cancelNextRelease) {
                this.cancelNextRelease = false;
                return true;
            }
            if (this.touchDragSlotStart != null && ((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue()) {
                if (button == 0 || button == 1) {
                    if (this.touchDragStack.method_7960() && slot != this.touchDragSlotStart) {
                        this.touchDragStack = this.touchDragSlotStart.method_7677();
                    }
                    boolean bl2 = class_1703.method_7592((class_1735)slot, (class_1799)this.touchDragStack, (boolean)false);
                    if (k != -1 && !this.touchDragStack.method_7960() && bl2) {
                        this.onMouseClick(this.touchDragSlotStart, this.touchDragSlotStart.field_7874, button, class_1713.field_7790);
                        this.onMouseClick(slot, k, 0, class_1713.field_7790);
                        if (this.handler.method_34255().method_7960()) {
                            this.touchDropReturningStack = class_1799.field_8037;
                        } else {
                            this.onMouseClick(this.touchDragSlotStart, this.touchDragSlotStart.field_7874, button, class_1713.field_7790);
                            this.touchDropX = class_3532.method_15357((double)(mouseX - (double)i));
                            this.touchDropY = class_3532.method_15357((double)(mouseY - (double)j));
                            this.touchDropOriginSlot = this.touchDragSlotStart;
                            this.touchDropReturningStack = this.touchDragStack;
                            this.touchDropTime = class_156.method_658();
                        }
                    } else if (!this.touchDragStack.method_7960()) {
                        this.touchDropX = class_3532.method_15357((double)(mouseX - (double)i));
                        this.touchDropY = class_3532.method_15357((double)(mouseY - (double)j));
                        this.touchDropOriginSlot = this.touchDragSlotStart;
                        this.touchDropReturningStack = this.touchDragStack;
                        this.touchDropTime = class_156.method_658();
                    }
                    this.endTouchDrag();
                }
            } else if (this.cursorDragging && !this.cursorDragSlots.isEmpty()) {
                this.onMouseClick(null, -999, class_1703.method_7591((int)0, (int)this.heldButtonType), class_1713.field_7789);
                for (class_1735 slot2x : this.cursorDragSlots) {
                    this.onMouseClick(slot2x, slot2x.field_7874, class_1703.method_7591((int)1, (int)this.heldButtonType), class_1713.field_7789);
                }
                this.onMouseClick(null, -999, class_1703.method_7591((int)2, (int)this.heldButtonType), class_1713.field_7789);
            } else if (!this.handler.method_34255().method_7960()) {
                if (this.field_22787.field_1690.field_1871.method_1433(button)) {
                    this.onMouseClick(slot, k, button, class_1713.field_7796);
                } else {
                    this.onMouseClick(slot, k, button, class_1713.field_7790);
                }
            }
        }
        if (this.handler.method_34255().method_7960()) {
            this.lastButtonClickTime = 0L;
        }
        this.cursorDragging = false;
        return true;
    }

    public void endTouchDrag() {
        this.touchDragStack = class_1799.field_8037;
        this.touchDragSlotStart = null;
    }

    private boolean isPointOverSlot(class_1735 slot, double pointX, double pointY) {
        return this.isPointWithinBounds(slot.field_7873, slot.field_7872, 16, 16, pointX, pointY + (double)LimitedHandledScreen.getYOffset());
    }

    protected boolean isPointWithinBounds(int x, int y, int width, int height, double pointX, double pointY) {
        int i = this.x;
        int j = this.y;
        return (pointX -= (double)i) >= (double)(x - 1) && pointX < (double)(x + width + 1) && (pointY -= (double)j) >= (double)(y - 1) && pointY < (double)(y + height + 1);
    }

    protected void onMouseClick(class_1735 slot, int slotId, int button, class_1713 actionType) {
        if (slot != null) {
            slotId = slot.field_7874;
        }
        this.field_22787.field_1761.method_2906(((class_1703)this.handler).field_7763, slotId, button, actionType, (class_1657)this.field_22787.field_1724);
    }

    protected void onSlotChangedState(int slotId, int handlerId, boolean newState) {
        this.field_22787.field_1761.method_54634(slotId, handlerId, newState);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        this.handleHotbarKeyPressed(keyCode, scanCode);
        if (this.focusedSlot != null && this.focusedSlot.method_7681() && this.field_22787.field_1690.field_1871.method_1417(keyCode, scanCode)) {
            this.onMouseClick(this.focusedSlot, this.focusedSlot.field_7874, 0, class_1713.field_7796);
        }
        return true;
    }

    protected boolean handleHotbarKeyPressed(int keyCode, int scanCode) {
        if (this.handler.method_34255().method_7960() && this.focusedSlot != null) {
            if (this.field_22787.field_1690.field_1831.method_1417(keyCode, scanCode)) {
                this.onMouseClick(this.focusedSlot, this.focusedSlot.field_7874, 40, class_1713.field_7791);
                return true;
            }
            for (int i = 0; i < 9; ++i) {
                if (!this.field_22787.field_1690.field_1852[i].method_1417(keyCode, scanCode)) continue;
                this.onMouseClick(this.focusedSlot, this.focusedSlot.field_7874, i, class_1713.field_7791);
                return true;
            }
        }
        return false;
    }

    public void method_25432() {
        if (this.field_22787.field_1724 != null) {
            this.handler.method_7595((class_1657)this.field_22787.field_1724);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public final void method_25393() {
        super.method_25393();
        if (this.field_22787.field_1724.method_5805() && !this.field_22787.field_1724.method_31481()) {
            this.handledScreenTick();
        } else {
            this.field_22787.field_1724.method_7346();
        }
    }

    protected void handledScreenTick() {
    }

    public T method_17577() {
        return this.handler;
    }

    public void method_25419() {
        this.field_22787.field_1724.method_7346();
        super.method_25419();
    }
}

