/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.game;

import dev.doctor4t.trainmurdermystery.cca.PlayerShopComponent;
import dev.doctor4t.trainmurdermystery.index.TMMItems;
import dev.doctor4t.trainmurdermystery.util.ShopEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public interface GameConstants {
    public static final int FADE_TIME = 40;
    public static final int FADE_PAUSE = 20;
    public static final int MIN_PLAYER_COUNT = 6;
    public static final int DOOR_AUTOCLOSE_TIME = GameConstants.getInTicks(0, 5);
    public static final Map<class_1792, Integer> ITEM_COOLDOWNS = new HashMap<class_1792, Integer>();
    public static final int JAMMED_DOOR_TIME = GameConstants.getInTicks(1, 0);
    public static final int MAX_SPRINTING_TICKS = GameConstants.getInTicks(0, 10);
    public static final int TIME_TO_DECOMPOSITION = GameConstants.getInTicks(1, 0);
    public static final int DECOMPOSING_TIME = GameConstants.getInTicks(4, 0);
    public static final class_243 SPAWN_POS = new class_243(-872.5, 0.0, -323.0);
    public static final class_238 READY_AREA = new class_238(-1017.0, -1.0, -363.5, -813.0, 3.0, -357.5);
    public static final class_243 PLAY_OFFSET = new class_243(963.0, 121.0, -175.0);
    public static final Consumer<class_3222> SPECTATOR_TP = serverPlayerEntity -> serverPlayerEntity.method_14251(serverPlayerEntity.method_51469(), -68.0, 133.0, -535.5, -90.0f, 15.0f);
    public static final class_238 PLAY_AREA = new class_238(-140.0, 118.0, -550.5, 230.0, 200.0, -520.5);
    public static final class_238 BACKUP_TRAIN_LOCATION = new class_238(-57.0, 64.0, -531.0, 177.0, 74.0, -541.0);
    public static final class_238 TRAIN_LOCATION = BACKUP_TRAIN_LOCATION.method_989(0.0, 55.0, 0.0);
    public static final float MOOD_GAIN = 0.5f;
    public static final float MOOD_DRAIN = 1.0f / (float)GameConstants.getInTicks(4, 0);
    public static final int TIME_TO_FIRST_TASK = GameConstants.getInTicks(0, 30);
    public static final int MIN_TASK_COOLDOWN = GameConstants.getInTicks(0, 30);
    public static final int MAX_TASK_COOLDOWN = GameConstants.getInTicks(1, 0);
    public static final int SLEEP_TASK_DURATION = GameConstants.getInTicks(0, 8);
    public static final int OUTSIDE_TASK_DURATION = GameConstants.getInTicks(0, 8);
    public static final float MID_MOOD_THRESHOLD = 0.55f;
    public static final float DEPRESSIVE_MOOD_THRESHOLD = 0.2f;
    public static final float ITEM_PSYCHOSIS_CHANCE = 0.5f;
    public static final int ITEM_PSYCHOSIS_REROLL_TIME = 200;
    public static final List<ShopEntry> SHOP_ENTRIES = List.of(new ShopEntry(TMMItems.KNIFE.method_7854(), 100, ShopEntry.Type.WEAPON), new ShopEntry(TMMItems.REVOLVER.method_7854(), 300, ShopEntry.Type.WEAPON), new ShopEntry(TMMItems.GRENADE.method_7854(), 350, ShopEntry.Type.WEAPON), new ShopEntry(TMMItems.PSYCHO_MODE.method_7854(), 300, ShopEntry.Type.WEAPON){

        @Override
        public boolean onBuy(@NotNull class_1657 player) {
            return PlayerShopComponent.usePsychoMode(player);
        }
    }, new ShopEntry(TMMItems.POISON_VIAL.method_7854(), 100, ShopEntry.Type.POISON), new ShopEntry(TMMItems.SCORPION.method_7854(), 50, ShopEntry.Type.POISON), new ShopEntry(TMMItems.FIRECRACKER.method_7854(), 10, ShopEntry.Type.TOOL), new ShopEntry(TMMItems.LOCKPICK.method_7854(), 50, ShopEntry.Type.TOOL), new ShopEntry(TMMItems.CROWBAR.method_7854(), 25, ShopEntry.Type.TOOL), new ShopEntry(TMMItems.BODY_BAG.method_7854(), 200, ShopEntry.Type.TOOL), new ShopEntry(TMMItems.BLACKOUT.method_7854(), 200, ShopEntry.Type.TOOL){

        @Override
        public boolean onBuy(@NotNull class_1657 player) {
            return PlayerShopComponent.useBlackout(player);
        }
    }, new ShopEntry(new class_1799((class_1935)TMMItems.NOTE, 4), 10, ShopEntry.Type.TOOL));
    public static final int MONEY_START = 100;
    public static final Function<Long, Integer> PASSIVE_MONEY_TICKER = time -> {
        if (time % (long)GameConstants.getInTicks(0, 10) == 0L) {
            return 5;
        }
        return 0;
    };
    public static final int MONEY_PER_KILL = 100;
    public static final int PSYCHO_MODE_ARMOUR = 1;
    public static final int PSYCHO_TIMER = GameConstants.getInTicks(0, 30);
    public static final int FIRECRACKER_TIMER = GameConstants.getInTicks(0, 15);
    public static final int BLACKOUT_MIN_DURATION = GameConstants.getInTicks(0, 15);
    public static final int BLACKOUT_MAX_DURATION = GameConstants.getInTicks(0, 20);
    public static final int TIME_ON_CIVILIAN_KILL = GameConstants.getInTicks(1, 0);

    public static void init() {
        ITEM_COOLDOWNS.put(TMMItems.KNIFE, GameConstants.getInTicks(1, 0));
        ITEM_COOLDOWNS.put(TMMItems.REVOLVER, GameConstants.getInTicks(0, 10));
        ITEM_COOLDOWNS.put(TMMItems.DERRINGER, GameConstants.getInTicks(0, 1));
        ITEM_COOLDOWNS.put(TMMItems.GRENADE, GameConstants.getInTicks(5, 0));
        ITEM_COOLDOWNS.put(TMMItems.LOCKPICK, GameConstants.getInTicks(3, 0));
        ITEM_COOLDOWNS.put(TMMItems.CROWBAR, GameConstants.getInTicks(0, 10));
        ITEM_COOLDOWNS.put(TMMItems.BODY_BAG, GameConstants.getInTicks(5, 0));
        ITEM_COOLDOWNS.put(TMMItems.PSYCHO_MODE, GameConstants.getInTicks(5, 0));
        ITEM_COOLDOWNS.put(TMMItems.BLACKOUT, GameConstants.getInTicks(3, 0));
    }

    public static int getInTicks(int minutes, int seconds) {
        return (minutes * 60 + seconds) * 20;
    }
}

