/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.cca;

import dev.doctor4t.trainmurdermystery.TMM;
import dev.doctor4t.trainmurdermystery.cca.GameWorldComponent;
import dev.doctor4t.trainmurdermystery.client.TMMClient;
import dev.doctor4t.trainmurdermystery.game.GameConstants;
import dev.doctor4t.trainmurdermystery.game.GameFunctions;
import dev.doctor4t.trainmurdermystery.index.tag.TMMItemTags;
import dev.doctor4t.trainmurdermystery.util.TaskCompletePayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ClientTickingComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class PlayerMoodComponent
implements AutoSyncedComponent,
ServerTickingComponent,
ClientTickingComponent {
    public static final ComponentKey<PlayerMoodComponent> KEY = ComponentRegistry.getOrCreate((class_2960)TMM.id("mood"), PlayerMoodComponent.class);
    private final class_1657 player;
    public final Map<Task, TrainTask> tasks = new HashMap<Task, TrainTask>();
    public final Map<Task, Integer> timesGotten = new HashMap<Task, Integer>();
    private int nextTaskTimer = 0;
    private float mood = 1.0f;
    private final HashMap<UUID, class_1799> psychosisItems = new HashMap();
    private static List<class_1792> cachedPsychosisItems = null;

    public PlayerMoodComponent(class_1657 player) {
        this.player = player;
    }

    public void sync() {
        KEY.sync((Object)this.player);
    }

    public void reset() {
        this.tasks.clear();
        this.timesGotten.clear();
        this.nextTaskTimer = GameConstants.TIME_TO_FIRST_TASK;
        this.psychosisItems.clear();
        this.setMood(1.0f);
        this.sync();
    }

    private List<class_1792> getPsychosisItemPool() {
        if (cachedPsychosisItems == null) {
            cachedPsychosisItems = this.player.method_56673().method_46758().method_46751(class_7924.field_41197).method_46733(TMMItemTags.PSYCHOSIS_ITEMS).map(class_6885.class_6887::method_40239).map(stream -> stream.map(class_6880::comp_349).toList()).orElseGet(() -> {
                TMM.LOGGER.error("Server provided empty tag {}", (Object)TMMItemTags.PSYCHOSIS_ITEMS.comp_327());
                return List.of();
            });
        }
        return cachedPsychosisItems;
    }

    public void clientTick() {
        if (!((GameWorldComponent)GameWorldComponent.KEY.get((Object)this.player.method_37908())).isRunning() || !TMMClient.isPlayerAliveAndInSurvival()) {
            return;
        }
        if (!this.tasks.isEmpty()) {
            this.setMood(this.mood - (float)this.tasks.size() * GameConstants.MOOD_DRAIN);
        }
        if (this.isLowerThanMid()) {
            for (class_1657 playerEntity : this.player.method_37908().method_18456()) {
                class_1799 psychosisStack;
                if (playerEntity.equals((Object)this.player) || this.player.method_37908().method_8409().method_43048(200) != 0) continue;
                List<class_1792> taggedItems = this.getPsychosisItemPool();
                if (!taggedItems.isEmpty() && this.player.method_59922().method_43057() < 0.5f) {
                    class_1792 item = (class_1792)class_156.method_32309(taggedItems, (class_5819)this.player.method_59922());
                    psychosisStack = new class_1799((class_1935)item);
                } else {
                    psychosisStack = playerEntity.method_6047();
                }
                this.psychosisItems.put(playerEntity.method_5667(), psychosisStack);
            }
        } else if (!this.psychosisItems.isEmpty()) {
            this.psychosisItems.clear();
        }
    }

    public void serverTick() {
        GameWorldComponent gameWorldComponent = (GameWorldComponent)GameWorldComponent.KEY.get((Object)this.player.method_37908());
        if (!gameWorldComponent.isRunning() || !GameFunctions.isPlayerAliveAndSurvival(this.player)) {
            return;
        }
        if (!this.tasks.isEmpty()) {
            this.setMood(this.mood - (float)this.tasks.size() * GameConstants.MOOD_DRAIN);
        }
        boolean shouldSync = false;
        --this.nextTaskTimer;
        if (this.nextTaskTimer <= 0) {
            TrainTask task = this.generateTask();
            if (task != null) {
                this.tasks.put(task.getType(), task);
                this.timesGotten.putIfAbsent(task.getType(), 1);
                this.timesGotten.put(task.getType(), this.timesGotten.get((Object)task.getType()) + 1);
            }
            this.nextTaskTimer = (int)(this.player.method_59922().method_43057() * (float)(GameConstants.MAX_TASK_COOLDOWN - GameConstants.MIN_TASK_COOLDOWN) + (float)GameConstants.MIN_TASK_COOLDOWN);
            this.nextTaskTimer = Math.max(this.nextTaskTimer, 2);
            shouldSync = true;
        }
        ArrayList<Task> removals = new ArrayList<Task>();
        for (TrainTask trainTask : this.tasks.values()) {
            trainTask.tick(this.player);
            if (!trainTask.isFulfilled(this.player)) continue;
            removals.add(trainTask.getType());
            this.setMood(this.mood + 0.5f);
            class_1657 class_16572 = this.player;
            if (class_16572 instanceof class_3222) {
                class_3222 tempPlayer = (class_3222)class_16572;
                ServerPlayNetworking.send((class_3222)tempPlayer, (class_8710)new TaskCompletePayload());
            }
            shouldSync = true;
        }
        for (Task task : removals) {
            this.tasks.remove((Object)task);
        }
        if (shouldSync) {
            this.sync();
        }
    }

    @Nullable
    private TrainTask generateTask() {
        if (!this.tasks.isEmpty()) {
            return null;
        }
        HashMap<Task, Float> map = new HashMap<Task, Float>();
        float total = 0.0f;
        for (Task task : Task.values()) {
            if (this.tasks.containsKey((Object)task)) continue;
            float weight = 1.0f / (float)this.timesGotten.getOrDefault((Object)task, 1).intValue();
            map.put(task, Float.valueOf(weight));
            total += weight;
        }
        float random = this.player.method_59922().method_43057() * total;
        for (Map.Entry entry : map.entrySet()) {
            if (!((random -= ((Float)entry.getValue()).floatValue()) <= 0.0f)) continue;
            return switch (((Task)((Object)entry.getKey())).ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new SleepTask(GameConstants.SLEEP_TASK_DURATION);
                case 1 -> new OutsideTask(GameConstants.OUTSIDE_TASK_DURATION);
                case 2 -> new EatTask();
                case 3 -> new DrinkTask();
            };
        }
        return null;
    }

    public float getMood() {
        GameWorldComponent gameWorldComponent = (GameWorldComponent)GameWorldComponent.KEY.get((Object)this.player.method_37908());
        return gameWorldComponent.canUseKillerFeatures(this.player) || gameWorldComponent.getGameMode() != GameWorldComponent.GameMode.MURDER ? 1.0f : this.mood;
    }

    public void setMood(float mood) {
        GameWorldComponent gameWorldComponent = (GameWorldComponent)GameWorldComponent.KEY.get((Object)this.player.method_37908());
        this.mood = gameWorldComponent.canUseKillerFeatures(this.player) || gameWorldComponent.getGameMode() != GameWorldComponent.GameMode.MURDER ? 1.0f : Math.clamp(mood, 0.0f, 1.0f);
        this.sync();
    }

    public void eatFood() {
        TrainTask trainTask = this.tasks.get((Object)Task.EAT);
        if (trainTask instanceof EatTask) {
            EatTask eatTask = (EatTask)trainTask;
            eatTask.fulfilled = true;
        }
    }

    public void drinkCocktail() {
        TrainTask trainTask = this.tasks.get((Object)Task.DRINK);
        if (trainTask instanceof DrinkTask) {
            DrinkTask drinkTask = (DrinkTask)trainTask;
            drinkTask.fulfilled = true;
        }
    }

    public boolean isLowerThanMid() {
        return this.getMood() < 0.55f;
    }

    public boolean isLowerThanDepressed() {
        return this.getMood() < 0.2f;
    }

    public HashMap<UUID, class_1799> getPsychosisItems() {
        return this.psychosisItems;
    }

    public void writeToNbt(@NotNull class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registryLookup) {
        tag.method_10548("mood", this.mood);
        class_2499 tasks = new class_2499();
        for (TrainTask task : this.tasks.values()) {
            tasks.add((Object)task.toNbt());
        }
        tag.method_10566("tasks", (class_2520)tasks);
    }

    public void readFromNbt(@NotNull class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registryLookup) {
        this.mood = tag.method_10573("mood", 5) ? tag.method_10583("mood") : 1.0f;
        this.tasks.clear();
        if (tag.method_10573("tasks", 9)) {
            for (class_2520 element : tag.method_10554("tasks", 10)) {
                int type;
                class_2487 compound;
                if (!(element instanceof class_2487) || !(compound = (class_2487)element).method_10545("type") || (type = compound.method_10550("type")) < 0 || type >= Task.values().length) continue;
                Task typeEnum = Task.values()[type];
                this.tasks.put(typeEnum, typeEnum.setFunction.apply(compound));
            }
        }
    }

    public static interface TrainTask {
        default public void tick(@NotNull class_1657 player) {
        }

        public boolean isFulfilled(class_1657 var1);

        public String getName();

        public Task getType();

        public class_2487 toNbt();
    }

    public static enum Task {
        SLEEP(nbt -> new SleepTask(nbt.method_10550("timer"))),
        OUTSIDE(nbt -> new OutsideTask(nbt.method_10550("timer"))),
        EAT(nbt -> new EatTask()),
        DRINK(nbt -> new DrinkTask());

        @NotNull
        public final Function<class_2487, TrainTask> setFunction;

        private Task(Function<class_2487, TrainTask> function) {
            this.setFunction = function;
        }
    }

    public static class SleepTask
    implements TrainTask {
        private int timer;

        public SleepTask(int time) {
            this.timer = time;
        }

        @Override
        public void tick(@NotNull class_1657 player) {
            if (player.method_6113() && this.timer > 0) {
                --this.timer;
            }
        }

        @Override
        public boolean isFulfilled(@NotNull class_1657 player) {
            return this.timer <= 0;
        }

        @Override
        public String getName() {
            return "sleep";
        }

        @Override
        public Task getType() {
            return Task.SLEEP;
        }

        @Override
        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10569("type", Task.SLEEP.ordinal());
            nbt.method_10569("timer", this.timer);
            return nbt;
        }
    }

    public static class OutsideTask
    implements TrainTask {
        private int timer;

        public OutsideTask(int time) {
            this.timer = time;
        }

        @Override
        public void tick(@NotNull class_1657 player) {
            if (TMM.isSkyVisibleAdjacent((class_1297)player) && this.timer > 0) {
                --this.timer;
            }
        }

        @Override
        public boolean isFulfilled(@NotNull class_1657 player) {
            return this.timer <= 0;
        }

        @Override
        public String getName() {
            return "outside";
        }

        @Override
        public Task getType() {
            return Task.OUTSIDE;
        }

        @Override
        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10569("type", Task.OUTSIDE.ordinal());
            nbt.method_10569("timer", this.timer);
            return nbt;
        }
    }

    public static class EatTask
    implements TrainTask {
        public boolean fulfilled = false;

        @Override
        public boolean isFulfilled(@NotNull class_1657 player) {
            return this.fulfilled;
        }

        @Override
        public String getName() {
            return "eat";
        }

        @Override
        public Task getType() {
            return Task.EAT;
        }

        @Override
        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10569("type", Task.EAT.ordinal());
            return nbt;
        }
    }

    public static class DrinkTask
    implements TrainTask {
        public boolean fulfilled = false;

        @Override
        public boolean isFulfilled(@NotNull class_1657 player) {
            return this.fulfilled;
        }

        @Override
        public String getName() {
            return "drink";
        }

        @Override
        public Task getType() {
            return Task.DRINK;
        }

        @Override
        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10569("type", Task.DRINK.ordinal());
            return nbt;
        }
    }
}

