/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.client.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.doctor4t.trainmurdermystery.cca.GameRoundEndComponent;
import dev.doctor4t.trainmurdermystery.cca.GameWorldComponent;
import dev.doctor4t.trainmurdermystery.client.TMMClient;
import dev.doctor4t.trainmurdermystery.client.gui.RoleAnnouncementTexts;
import dev.doctor4t.trainmurdermystery.game.GameFunctions;
import dev.doctor4t.trainmurdermystery.index.TMMSounds;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraft.class_8685;
import org.jetbrains.annotations.NotNull;

public class RoundTextRenderer {
    private static final Map<String, Optional<GameProfile>> failCache = new HashMap<String, Optional<GameProfile>>();
    private static final int WELCOME_DURATION = 280;
    private static final int END_DURATION = 200;
    private static RoleAnnouncementTexts.RoleAnnouncementText role = RoleAnnouncementTexts.CIVILIAN;
    private static int welcomeTime = 0;
    private static int killers = 0;
    private static int targets = 0;
    private static int endTime = 0;

    public static void renderHud(class_327 renderer, class_746 player, @NotNull class_332 context) {
        boolean isLooseEnds;
        boolean bl = isLooseEnds = ((GameWorldComponent)GameWorldComponent.KEY.get((Object)player.method_37908())).getGameMode() == GameWorldComponent.GameMode.LOOSE_ENDS;
        if (welcomeTime > 0) {
            int color;
            context.method_51448().method_22903();
            context.method_51448().method_22904((double)((float)context.method_51421() / 2.0f), (double)((float)context.method_51443() / 2.0f) + 3.5, 0.0);
            context.method_51448().method_22903();
            context.method_51448().method_22905(2.6f, 2.6f, 1.0f);
            int n = color = isLooseEnds ? 0x9F0000 : 0xFFFFFF;
            if (welcomeTime <= 180) {
                class_5250 welcomeText = isLooseEnds ? class_2561.method_43471((String)"announcement.loose_ends.welcome") : RoundTextRenderer.role.welcomeText;
                context.method_27535(renderer, (class_2561)welcomeText, -renderer.method_27525((class_5348)welcomeText) / 2, -12, color);
            }
            context.method_51448().method_22909();
            context.method_51448().method_22903();
            context.method_51448().method_22905(1.2f, 1.2f, 1.0f);
            if (welcomeTime <= 120) {
                class_5250 premiseText = isLooseEnds ? class_2561.method_43471((String)"announcement.loose_ends.premise") : RoundTextRenderer.role.premiseText.apply(killers);
                context.method_27535(renderer, (class_2561)premiseText, -renderer.method_27525((class_5348)premiseText) / 2, 0, color);
            }
            context.method_51448().method_22909();
            context.method_51448().method_22903();
            context.method_51448().method_22905(1.0f, 1.0f, 1.0f);
            if (welcomeTime <= 60) {
                class_5250 goalText = isLooseEnds ? class_2561.method_43471((String)"announcement.loose_ends.goal") : RoundTextRenderer.role.goalText.apply(targets);
                context.method_27535(renderer, (class_2561)goalText, -renderer.method_27525((class_5348)goalText) / 2, 14, color);
            }
            context.method_51448().method_22909();
            context.method_51448().method_22909();
        }
        GameWorldComponent game = (GameWorldComponent)GameWorldComponent.KEY.get((Object)player.method_37908());
        if (endTime > 0 && endTime < 120 && !game.isRunning() && game.getGameMode() != GameWorldComponent.GameMode.DISCOVERY) {
            GameRoundEndComponent roundEnd = (GameRoundEndComponent)GameRoundEndComponent.KEY.get((Object)player.method_37908());
            if (roundEnd.getWinStatus() == GameFunctions.WinStatus.NONE) {
                return;
            }
            class_1657 winner = player.method_37908().method_18470(game.getLooseEndWinner() == null ? UUID.randomUUID() : game.getLooseEndWinner());
            class_2561 endText = role.getEndText(roundEnd.getWinStatus(), (class_2561)(winner == null ? class_2561.method_43473() : winner.method_5476()));
            if (endText == null) {
                return;
            }
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)context.method_51421() / 2.0f, (float)context.method_51443() / 2.0f - 40.0f, 0.0f);
            context.method_51448().method_22903();
            context.method_51448().method_22905(2.6f, 2.6f, 1.0f);
            context.method_27535(renderer, endText, -renderer.method_27525((class_5348)endText) / 2, -12, 0xFFFFFF);
            context.method_51448().method_22909();
            context.method_51448().method_22903();
            context.method_51448().method_22905(1.2f, 1.2f, 1.0f);
            class_5250 winMessage = class_2561.method_43471((String)("game.win." + roundEnd.getWinStatus().name().toLowerCase().toLowerCase()));
            context.method_27535(renderer, (class_2561)winMessage, -renderer.method_27525((class_5348)winMessage) / 2, -4, 0xFFFFFF);
            context.method_51448().method_22909();
            if (isLooseEnds) {
                context.method_27535(renderer, RoleAnnouncementTexts.LOOSE_END.titleText, -renderer.method_27525((class_5348)RoleAnnouncementTexts.LOOSE_END.titleText) / 2, 14, 0xFFFFFF);
                int looseEnds = 0;
                for (GameRoundEndComponent.RoundEndData entry : roundEnd.getPlayers()) {
                    context.method_51448().method_22903();
                    context.method_51448().method_22905(2.0f, 2.0f, 1.0f);
                    context.method_51448().method_22904(((double)(looseEnds % 6) - 3.5) * 12.0, (double)(14 + looseEnds / 6 * 12), 0.0);
                    ++looseEnds;
                    class_640 playerEntry = TMMClient.PLAYER_ENTRIES_CACHE.get(entry.player().getId());
                    if (playerEntry != null && playerEntry.method_52810().comp_1626() != null) {
                        class_2960 texture = playerEntry.method_52810().comp_1626();
                        RenderSystem.enableBlend();
                        context.method_51448().method_22903();
                        context.method_51448().method_46416(8.0f, 0.0f, 0.0f);
                        float offColour = entry.wasDead() ? 0.4f : 1.0f;
                        context.method_48466(texture, 0, 8, 0, 8, 0, 0.125f, 0.25f, 0.125f, 0.25f, 1.0f, offColour, offColour, 1.0f);
                        context.method_51448().method_22904(-0.5, -0.5, 0.0);
                        context.method_51448().method_22905(1.125f, 1.125f, 1.0f);
                        context.method_48466(texture, 0, 8, 0, 8, 0, 0.625f, 0.75f, 0.125f, 0.25f, 1.0f, offColour, offColour, 1.0f);
                        context.method_51448().method_22909();
                    }
                    if (entry.wasDead()) {
                        context.method_51448().method_46416(13.0f, 0.0f, 0.0f);
                        context.method_51448().method_22905(2.0f, 1.0f, 1.0f);
                        context.method_51433(renderer, "x", -renderer.method_1727("x") / 2, 0, 0xE10000, false);
                        context.method_51433(renderer, "x", -renderer.method_1727("x") / 2, 1, 0x550000, false);
                    }
                    context.method_51448().method_22909();
                }
                context.method_51448().method_22909();
            } else {
                int vigilanteTotal = 1;
                for (GameRoundEndComponent.RoundEndData entry : roundEnd.getPlayers()) {
                    if (entry.role() != RoleAnnouncementTexts.VIGILANTE) continue;
                    ++vigilanteTotal;
                }
                context.method_27535(renderer, RoleAnnouncementTexts.CIVILIAN.titleText, -renderer.method_27525((class_5348)RoleAnnouncementTexts.CIVILIAN.titleText) / 2 - 60, 14, 0xFFFFFF);
                context.method_27535(renderer, RoleAnnouncementTexts.VIGILANTE.titleText, -renderer.method_27525((class_5348)RoleAnnouncementTexts.VIGILANTE.titleText) / 2 + 50, 14, 0xFFFFFF);
                context.method_27535(renderer, RoleAnnouncementTexts.KILLER.titleText, -renderer.method_27525((class_5348)RoleAnnouncementTexts.KILLER.titleText) / 2 + 50, 30 + 24 * (vigilanteTotal / 2), 0xFFFFFF);
                int civilians = 0;
                int vigilantes = 0;
                int killers = 0;
                for (GameRoundEndComponent.RoundEndData entry : roundEnd.getPlayers()) {
                    context.method_51448().method_22903();
                    context.method_51448().method_22905(2.0f, 2.0f, 1.0f);
                    if (entry.role() == RoleAnnouncementTexts.CIVILIAN) {
                        context.method_51448().method_46416((float)(-60 + civilians % 4 * 12), (float)(14 + civilians / 4 * 12), 0.0f);
                        ++civilians;
                    } else if (entry.role() == RoleAnnouncementTexts.VIGILANTE) {
                        context.method_51448().method_46416((float)(7 + vigilantes % 2 * 12), (float)(14 + vigilantes / 2 * 12), 0.0f);
                        ++vigilantes;
                    } else if (entry.role() == RoleAnnouncementTexts.KILLER) {
                        context.method_51448().method_46416(0.0f, (float)(8 + vigilanteTotal / 2 * 12), 0.0f);
                        context.method_51448().method_46416((float)(7 + killers % 2 * 12), (float)(14 + killers / 2 * 12), 0.0f);
                        ++killers;
                    }
                    class_640 playerListEntry = TMMClient.PLAYER_ENTRIES_CACHE.get(entry.player().getId());
                    if (playerListEntry != null) {
                        class_2960 texture = playerListEntry.method_52810().comp_1626();
                        if (texture != null) {
                            RenderSystem.enableBlend();
                            context.method_51448().method_22903();
                            context.method_51448().method_46416(8.0f, 0.0f, 0.0f);
                            float offColour = entry.wasDead() ? 0.4f : 1.0f;
                            context.method_48466(texture, 0, 8, 0, 8, 0, 0.125f, 0.25f, 0.125f, 0.25f, 1.0f, offColour, offColour, 1.0f);
                            context.method_51448().method_22904(-0.5, -0.5, 0.0);
                            context.method_51448().method_22905(1.125f, 1.125f, 1.0f);
                            context.method_48466(texture, 0, 8, 0, 8, 0, 0.625f, 0.75f, 0.125f, 0.25f, 1.0f, offColour, offColour, 1.0f);
                            context.method_51448().method_22909();
                        }
                        if (entry.wasDead()) {
                            context.method_51448().method_46416(13.0f, 0.0f, 0.0f);
                            context.method_51448().method_22905(2.0f, 1.0f, 1.0f);
                            context.method_51433(renderer, "x", -renderer.method_1727("x") / 2, 0, 0xE10000, false);
                            context.method_51433(renderer, "x", -renderer.method_1727("x") / 2, 1, 0x550000, false);
                        }
                    }
                    context.method_51448().method_22909();
                }
                context.method_51448().method_22909();
            }
        }
    }

    public static void tick() {
        if (class_310.method_1551().field_1687 != null && ((GameWorldComponent)GameWorldComponent.KEY.get((Object)class_310.method_1551().field_1687)).getGameMode() != GameWorldComponent.GameMode.DISCOVERY) {
            class_315 options;
            class_746 player = class_310.method_1551().field_1724;
            if (welcomeTime > 0) {
                switch (welcomeTime) {
                    case 200: {
                        if (player == null) break;
                        player.method_37908().method_47967((class_1657)player, player.method_23317(), player.method_23318(), player.method_23321(), TMMSounds.UI_RISER, class_3419.field_15250, 10.0f, 1.0f, player.method_59922().method_43055());
                        break;
                    }
                    case 180: {
                        if (player == null) break;
                        player.method_37908().method_47967((class_1657)player, player.method_23317(), player.method_23318(), player.method_23321(), TMMSounds.UI_PIANO, class_3419.field_15250, 10.0f, 1.25f, player.method_59922().method_43055());
                        break;
                    }
                    case 120: {
                        if (player == null) break;
                        player.method_37908().method_47967((class_1657)player, player.method_23317(), player.method_23318(), player.method_23321(), TMMSounds.UI_PIANO, class_3419.field_15250, 10.0f, 1.5f, player.method_59922().method_43055());
                        break;
                    }
                    case 60: {
                        if (player == null) break;
                        player.method_37908().method_47967((class_1657)player, player.method_23317(), player.method_23318(), player.method_23321(), TMMSounds.UI_PIANO, class_3419.field_15250, 10.0f, 1.75f, player.method_59922().method_43055());
                        break;
                    }
                    case 1: {
                        if (player == null) break;
                        player.method_37908().method_47967((class_1657)player, player.method_23317(), player.method_23318(), player.method_23321(), TMMSounds.UI_PIANO_STINGER, class_3419.field_15250, 10.0f, 1.0f, player.method_59922().method_43055());
                    }
                }
                --welcomeTime;
            }
            if (endTime > 0) {
                if (endTime == 120 && player != null) {
                    player.method_37908().method_47967((class_1657)player, player.method_23317(), player.method_23318(), player.method_23321(), ((GameRoundEndComponent)GameRoundEndComponent.KEY.get((Object)player.method_37908())).didWin(player.method_5667()) ? TMMSounds.UI_PIANO_WIN : TMMSounds.UI_PIANO_LOSE, class_3419.field_15250, 10.0f, 1.0f, player.method_59922().method_43055());
                }
                --endTime;
            }
            if ((options = class_310.method_1551().field_1690) != null && options.field_1907.method_1434()) {
                endTime = Math.max(2, endTime);
            }
        }
    }

    public static void startWelcome(RoleAnnouncementTexts.RoleAnnouncementText role, int killers, int targets) {
        RoundTextRenderer.role = role;
        welcomeTime = 280;
        RoundTextRenderer.killers = killers;
        RoundTextRenderer.targets = targets;
    }

    public static void startEnd() {
        welcomeTime = 0;
        endTime = 200;
    }

    public static GameProfile getGameProfile(String disguise) {
        Optional<GameProfile> optional = class_2631.method_52580((String)disguise).getNow(RoundTextRenderer.failCache(disguise));
        return optional.orElse(RoundTextRenderer.failCache(disguise).get());
    }

    public static class_8685 getSkinTextures(String disguise) {
        return class_310.method_1551().method_1582().method_52862(RoundTextRenderer.getGameProfile(disguise));
    }

    public static Optional<GameProfile> failCache(String name) {
        return failCache.computeIfAbsent(name, d -> Optional.of(new GameProfile(UUID.randomUUID(), name)));
    }
}

