/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.cca;

import dev.doctor4t.trainmurdermystery.TMM;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ClientTickingComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class TrainWorldComponent
implements AutoSyncedComponent,
ServerTickingComponent,
ClientTickingComponent {
    public static final ComponentKey<TrainWorldComponent> KEY = ComponentRegistry.getOrCreate((class_2960)TMM.id("train"), TrainWorldComponent.class);
    private final class_1937 world;
    private int speed = 0;
    private int time = 0;
    private boolean snow = true;
    private boolean fog = true;
    private boolean hud = true;
    private TimeOfDay timeOfDay = TimeOfDay.NIGHT;

    public TrainWorldComponent(class_1937 world) {
        this.world = world;
    }

    private void sync() {
        KEY.sync((Object)this.world);
    }

    public void setSpeed(int speed) {
        this.speed = speed;
        this.sync();
    }

    public int getSpeed() {
        return this.speed;
    }

    public float getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
        this.sync();
    }

    public boolean isSnowing() {
        return this.snow;
    }

    public void setSnow(boolean snow) {
        this.snow = snow;
        this.sync();
    }

    public boolean isFoggy() {
        return this.fog;
    }

    public void setFog(boolean fog) {
        this.fog = fog;
        this.sync();
    }

    public boolean hasHud() {
        return this.hud;
    }

    public void setHud(boolean hud) {
        this.hud = hud;
        this.sync();
    }

    public TimeOfDay getTimeOfDay() {
        return this.timeOfDay;
    }

    public void setTimeOfDay(TimeOfDay timeOfDay) {
        this.timeOfDay = timeOfDay;
        this.sync();
    }

    public void readFromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        this.setSpeed(nbtCompound.method_10550("Speed"));
        this.setTime(nbtCompound.method_10550("Time"));
        this.setSnow(nbtCompound.method_10577("Snow"));
        this.setFog(nbtCompound.method_10577("Fog"));
        this.setHud(nbtCompound.method_10577("Hud"));
        this.setTimeOfDay(TimeOfDay.valueOf(nbtCompound.method_10558("TimeOfDay")));
    }

    public void writeToNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        nbtCompound.method_10569("Speed", this.speed);
        nbtCompound.method_10569("Time", this.time);
        nbtCompound.method_10556("Snow", this.snow);
        nbtCompound.method_10556("Fog", this.fog);
        nbtCompound.method_10556("Hud", this.hud);
        nbtCompound.method_10582("TimeOfDay", this.timeOfDay.name());
    }

    public void clientTick() {
        this.tickTime();
    }

    private void tickTime() {
        this.time = this.speed > 0 ? ++this.time : 0;
    }

    public void serverTick() {
        this.tickTime();
        class_3218 serverWorld = (class_3218)this.world;
        serverWorld.method_29199((long)this.timeOfDay.time);
    }

    public void reset() {
        this.snow = true;
        this.fog = true;
        this.hud = true;
        this.speed = 130;
        this.time = 0;
        this.sync();
    }

    public static enum TimeOfDay implements class_3542
    {
        DAY(6000),
        NIGHT(18000),
        SUNDOWN(12800);

        final int time;

        private TimeOfDay(int time) {
            this.time = time;
        }

        public String method_15434() {
            return this.name();
        }
    }
}

