/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.block;

import dev.doctor4t.trainmurdermystery.block.DoorPartBlock;
import dev.doctor4t.trainmurdermystery.block_entity.DoorBlockEntity;
import dev.doctor4t.trainmurdermystery.block_entity.SmallDoorBlockEntity;
import dev.doctor4t.trainmurdermystery.event.AllowPlayerOpenLockedDoor;
import dev.doctor4t.trainmurdermystery.index.TMMItems;
import dev.doctor4t.trainmurdermystery.index.TMMSounds;
import java.util.function.Supplier;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class SmallDoorBlock
extends DoorPartBlock {
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    protected static final class_265 X_SHAPE = class_2248.method_9541((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final class_265 Z_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    private static final class_265[] SHAPES = SmallDoorBlock.createShapes();
    private final Supplier<class_2591<SmallDoorBlockEntity>> typeSupplier;

    public SmallDoorBlock(Supplier<class_2591<SmallDoorBlockEntity>> typeSupplier, class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)super.method_9564().method_11657(HALF, (Comparable)class_2756.field_12607));
        this.typeSupplier = typeSupplier;
    }

    private static class_265[] createShapes() {
        class_265[] shapes = new class_265[16];
        class_265 lowerXShape = class_2248.method_9541((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)32.0, (double)16.0);
        class_265 lowerZShape = class_2248.method_9541((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)32.0, (double)9.0);
        class_265 upperXShape = class_2248.method_9541((double)7.0, (double)-16.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
        class_265 upperZShape = class_2248.method_9541((double)0.0, (double)-16.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            int id = direction.method_10161();
            boolean xAxis = direction.method_10166() == class_2350.class_2351.field_11048;
            shapes[id] = xAxis ? lowerXShape : lowerZShape;
            shapes[id + 4] = xAxis ? upperXShape : upperZShape;
            Vector3f offset = direction.method_10170().method_23955().mul(7.0f);
            class_238 box = new class_238(7.0, 0.0, 7.0, 9.0, 32.0, 9.0).method_60314(offset);
            shapes[id + 8] = class_2248.method_9541((double)box.field_1323, (double)box.field_1322, (double)box.field_1321, (double)box.field_1320, (double)box.field_1325, (double)box.field_1324);
            shapes[id + 12] = class_2248.method_9541((double)box.field_1323, (double)(box.field_1322 - 16.0), (double)box.field_1321, (double)box.field_1320, (double)(box.field_1325 - 16.0), (double)box.field_1324);
        }
        return shapes;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        world.method_8501(pos.method_10084(), (class_2680)state.method_11657(HALF, (Comparable)class_2756.field_12609));
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        class_2756 half = (class_2756)state.method_11654(HALF);
        if (!(direction != half.method_54779() || neighborState.method_27852((class_2248)this) && neighborState.method_11654((class_2769)FACING) == state.method_11654((class_2769)FACING) && neighborState.method_11654(HALF) == half.method_54780())) {
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 placementState = super.method_9605(ctx);
        if (placementState == null) {
            return null;
        }
        class_2338 pos = ctx.method_8037();
        class_1937 world = ctx.method_8045();
        return pos.method_10264() < world.method_31600() - 1 && world.method_8320(pos.method_10084()).method_26166(ctx) ? placementState : null;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (context.equals((Object)class_3726.method_16194())) {
            return this.getShape(state);
        }
        boolean lower = state.method_11654(HALF) == class_2756.field_12607;
        boolean open = (Boolean)state.method_11654((class_2769)OPEN);
        return SHAPES[((class_2350)state.method_11654((class_2769)FACING)).method_10161() + (lower ? 0 : 4) + (open ? 8 : 0)];
    }

    @Override
    protected class_265 getShape(class_2680 state) {
        return ((class_2350)state.method_11654((class_2769)FACING)).method_10166() == class_2350.class_2351.field_11048 ? X_SHAPE : Z_SHAPE;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{HALF});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return state.method_11654(HALF) == class_2756.field_12607 ? this.typeSupplier.get().method_11032(pos, state) : null;
    }

    @Override
    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return state.method_11654(HALF) == class_2756.field_12607 ? super.method_31645(world, state, type) : null;
    }

    @Override
    protected class_2591<? extends DoorBlockEntity> getBlockEntityType() {
        return this.typeSupplier.get();
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2338 lowerPos = state.method_11654(HALF) == class_2756.field_12607 ? pos : pos.method_10074();
        class_2586 class_25862 = world.method_8321(lowerPos);
        if (class_25862 instanceof SmallDoorBlockEntity) {
            SmallDoorBlockEntity entity = (SmallDoorBlockEntity)class_25862;
            if (entity.isBlasted()) {
                return class_1269.field_5811;
            }
            if (player.method_7337() || ((AllowPlayerOpenLockedDoor)AllowPlayerOpenLockedDoor.EVENT.invoker()).allowOpen((class_1297)player)) {
                return SmallDoorBlock.open(state, world, entity, lowerPos);
            }
            boolean requiresKey = !entity.getKeyName().isEmpty();
            boolean hasLockpick = player.method_6047().method_31574(TMMItems.LOCKPICK);
            boolean jammed = entity.isJammed();
            if (entity.isOpen()) {
                return SmallDoorBlock.open(state, world, entity, lowerPos);
            }
            if (requiresKey && !jammed) {
                if (player.method_6047().method_31574(TMMItems.CROWBAR)) {
                    return class_1269.field_5814;
                }
                if (player.method_6047().method_31574(TMMItems.KEY) || hasLockpick) {
                    boolean isRightKey;
                    class_9290 lore = (class_9290)player.method_6047().method_57824(class_9334.field_49632);
                    boolean bl = isRightKey = lore != null && !lore.comp_2400().isEmpty() && ((class_2561)lore.comp_2400().getFirst()).getString().equals(entity.getKeyName());
                    if (isRightKey || hasLockpick) {
                        if (isRightKey) {
                            world.method_43128(null, (double)((float)lowerPos.method_10263() + 0.5f), (double)(lowerPos.method_10264() + 1), (double)((float)lowerPos.method_10260() + 0.5f), TMMSounds.ITEM_KEY_DOOR, class_3419.field_15245, 1.0f, 1.0f);
                        }
                        if (hasLockpick) {
                            world.method_43128(null, (double)((float)lowerPos.method_10263() + 0.5f), (double)(lowerPos.method_10264() + 1), (double)((float)lowerPos.method_10260() + 0.5f), TMMSounds.ITEM_LOCKPICK_DOOR, class_3419.field_15245, 1.0f, 1.0f);
                        }
                        return SmallDoorBlock.open(state, world, entity, lowerPos);
                    }
                    if (!world.field_9236) {
                        world.method_43128(null, (double)((float)lowerPos.method_10263() + 0.5f), (double)(lowerPos.method_10264() + 1), (double)((float)lowerPos.method_10260() + 0.5f), TMMSounds.BLOCK_DOOR_LOCKED, class_3419.field_15245, 1.0f, 1.0f);
                        player.method_7353((class_2561)class_2561.method_43471((String)"tip.door.requires_different_key"), true);
                    }
                    return class_1269.field_5814;
                }
                if (!world.field_9236) {
                    world.method_43128(null, (double)((float)lowerPos.method_10263() + 0.5f), (double)(lowerPos.method_10264() + 1), (double)((float)lowerPos.method_10260() + 0.5f), TMMSounds.BLOCK_DOOR_LOCKED, class_3419.field_15245, 1.0f, 1.0f);
                    player.method_7353((class_2561)class_2561.method_43471((String)"tip.door.requires_key"), true);
                }
                return class_1269.field_5814;
            }
            if (jammed) {
                if (!world.field_9236) {
                    world.method_43128(null, (double)((float)lowerPos.method_10263() + 0.5f), (double)(lowerPos.method_10264() + 1), (double)((float)lowerPos.method_10260() + 0.5f), TMMSounds.BLOCK_DOOR_LOCKED, class_3419.field_15245, 1.0f, 1.0f);
                    player.method_7353((class_2561)class_2561.method_43471((String)"tip.door.jammed"), true);
                }
            } else {
                return SmallDoorBlock.open(state, world, entity, lowerPos);
            }
        }
        return class_1269.field_5811;
    }

    @NotNull
    static class_1269 open(class_2680 state, class_1937 world, SmallDoorBlockEntity entity, class_2338 lowerPos) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        SmallDoorBlock.toggleDoor(state, world, entity, lowerPos);
        return class_1269.field_21466;
    }

    public static void toggleDoor(class_2680 state, class_1937 world, SmallDoorBlockEntity entity, class_2338 lowerPos) {
        class_2586 class_25862;
        entity.toggle(false);
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 neighborPos = lowerPos.method_10093(facing.method_10160());
        class_2680 neighborState = world.method_8320(neighborPos);
        if (neighborState.method_27852(state.method_26204()) && ((class_2350)neighborState.method_11654((class_2769)FACING)).method_10153() == facing && (class_25862 = world.method_8321(neighborPos)) instanceof SmallDoorBlockEntity) {
            SmallDoorBlockEntity neighborEntity = (SmallDoorBlockEntity)class_25862;
            neighborEntity.toggle(true);
        }
    }
}

