/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.cca;

import dev.doctor4t.trainmurdermystery.TMM;
import dev.doctor4t.trainmurdermystery.cca.GameWorldComponent;
import dev.doctor4t.trainmurdermystery.game.GameConstants;
import dev.doctor4t.trainmurdermystery.game.GameFunctions;
import dev.doctor4t.trainmurdermystery.index.TMMItems;
import dev.doctor4t.trainmurdermystery.util.ShopEntry;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ClientTickingComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class PlayerPsychoComponent
implements AutoSyncedComponent,
ServerTickingComponent,
ClientTickingComponent {
    public static final ComponentKey<PlayerPsychoComponent> KEY = ComponentRegistry.getOrCreate((class_2960)TMM.id("psycho"), PlayerPsychoComponent.class);
    private final class_1657 player;
    public int psychoTicks = 0;
    public int armour = 1;

    public PlayerPsychoComponent(class_1657 player) {
        this.player = player;
    }

    public void sync() {
        KEY.sync((Object)this.player);
    }

    public void reset() {
        this.stopPsycho();
        this.sync();
    }

    public void clientTick() {
        if (this.psychoTicks <= 0) {
            return;
        }
        --this.psychoTicks;
        if (this.player.method_6047().method_31574(TMMItems.BAT)) {
            return;
        }
        if (GameFunctions.isPlayerAliveAndSurvival(this.player)) {
            for (int i = 0; i < 9; ++i) {
                if (!this.player.method_31548().method_5438(i).method_31574(TMMItems.BAT)) continue;
                this.player.method_31548().field_7545 = i;
                break;
            }
        }
    }

    public void serverTick() {
        if (this.psychoTicks <= 0) {
            return;
        }
        if (--this.psychoTicks == 0) {
            this.stopPsycho();
        }
        this.sync();
    }

    public boolean startPsycho() {
        if (ShopEntry.insertStackInFreeSlot(this.player, new class_1799((class_1935)TMMItems.BAT))) {
            this.setPsychoTicks(GameConstants.PSYCHO_TIMER);
            this.setArmour(1);
            GameWorldComponent gameWorldComponent = (GameWorldComponent)GameWorldComponent.KEY.get((Object)this.player.method_37908());
            gameWorldComponent.setPsychosActive(gameWorldComponent.getPsychosActive() + 1);
            return true;
        }
        return false;
    }

    public void stopPsycho() {
        if (this.psychoTicks > 0) {
            this.psychoTicks = 0;
            this.player.method_31548().method_29280(itemStack -> itemStack.method_31574(TMMItems.BAT), Integer.MAX_VALUE, (class_1263)this.player.field_7498.method_29281());
            GameWorldComponent gameWorldComponent = (GameWorldComponent)GameWorldComponent.KEY.get((Object)this.player.method_37908());
            gameWorldComponent.setPsychosActive(gameWorldComponent.getPsychosActive() - 1);
        }
    }

    public int getArmour() {
        return this.armour;
    }

    public void setArmour(int armour) {
        this.armour = armour;
        this.sync();
    }

    public int getPsychoTicks() {
        return this.psychoTicks;
    }

    public void setPsychoTicks(int ticks) {
        this.psychoTicks = ticks;
        this.sync();
    }

    public void writeToNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10569("psychoTicks", this.psychoTicks);
        tag.method_10569("armour", this.armour);
    }

    public void readFromNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        this.psychoTicks = tag.method_10545("psychoTicks") ? tag.method_10550("psychoTicks") : 0;
        this.armour = tag.method_10545("armour") ? tag.method_10550("armour") : 1;
    }
}

