/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.cca;

import com.mojang.authlib.GameProfile;
import dev.doctor4t.trainmurdermystery.TMM;
import dev.doctor4t.trainmurdermystery.api.TMMRoles;
import dev.doctor4t.trainmurdermystery.cca.GameWorldComponent;
import dev.doctor4t.trainmurdermystery.client.gui.RoleAnnouncementTexts;
import dev.doctor4t.trainmurdermystery.game.GameFunctions;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;

public class GameRoundEndComponent
implements AutoSyncedComponent {
    public static final ComponentKey<GameRoundEndComponent> KEY = ComponentRegistry.getOrCreate((class_2960)TMM.id("roundend"), GameRoundEndComponent.class);
    private final class_1937 world;
    private final List<RoundEndData> players = new ArrayList<RoundEndData>();
    private GameFunctions.WinStatus winStatus = GameFunctions.WinStatus.NONE;

    public GameRoundEndComponent(class_1937 world) {
        this.world = world;
    }

    public void sync() {
        KEY.sync((Object)this.world);
    }

    public void setRoundEndData(@NotNull List<class_3222> players, GameFunctions.WinStatus winStatus) {
        this.players.clear();
        for (class_3222 player : players) {
            RoleAnnouncementTexts.RoleAnnouncementText role = RoleAnnouncementTexts.BLANK;
            GameWorldComponent game = (GameWorldComponent)GameWorldComponent.KEY.get((Object)this.world);
            role = game.isRole((class_1657)player, TMMRoles.KILLER) ? RoleAnnouncementTexts.KILLER : (game.isRole((class_1657)player, TMMRoles.VIGILANTE) ? RoleAnnouncementTexts.VIGILANTE : RoleAnnouncementTexts.CIVILIAN);
            this.players.add(new RoundEndData(player.method_7334(), role, !GameFunctions.isPlayerAliveAndSurvival((class_1657)player)));
        }
        this.winStatus = winStatus;
        this.sync();
    }

    public boolean didWin(UUID uuid) {
        if (GameFunctions.WinStatus.NONE == this.winStatus) {
            return false;
        }
        for (RoundEndData detail : this.players) {
            if (!detail.player.getId().equals(uuid)) continue;
            return switch (this.winStatus) {
                case GameFunctions.WinStatus.KILLERS -> {
                    if (detail.role == RoleAnnouncementTexts.KILLER) {
                        yield true;
                    }
                    yield false;
                }
                case GameFunctions.WinStatus.PASSENGERS, GameFunctions.WinStatus.TIME -> {
                    if (detail.role != RoleAnnouncementTexts.KILLER) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }

    public List<RoundEndData> getPlayers() {
        return this.players;
    }

    public GameFunctions.WinStatus getWinStatus() {
        return this.winStatus;
    }

    public void writeToNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        class_2499 list = new class_2499();
        for (RoundEndData detail : this.players) {
            list.add((Object)detail.writeToNbt());
        }
        tag.method_10566("players", (class_2520)list);
        tag.method_10569("winstatus", this.winStatus.ordinal());
    }

    public void readFromNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        this.players.clear();
        for (class_2520 element : tag.method_10554("players", 10)) {
            this.players.add(new RoundEndData((class_2487)element));
        }
        this.winStatus = GameFunctions.WinStatus.values()[tag.method_10550("winstatus")];
    }

    public record RoundEndData(GameProfile player, RoleAnnouncementTexts.RoleAnnouncementText role, boolean wasDead) {
        public RoundEndData(@NotNull class_2487 tag) {
            this(new GameProfile(tag.method_25926("uuid"), tag.method_10558("name")), RoleAnnouncementTexts.ROLE_ANNOUNCEMENT_TEXTS.get(tag.method_10550("role")), tag.method_10577("wasDead"));
        }

        @NotNull
        public class_2487 writeToNbt() {
            class_2487 tag = new class_2487();
            tag.method_25927("uuid", this.player.getId());
            tag.method_10582("name", this.player.getName());
            tag.method_10569("role", RoleAnnouncementTexts.ROLE_ANNOUNCEMENT_TEXTS.indexOf(this.role));
            tag.method_10556("wasDead", this.wasDead);
            return tag;
        }
    }
}

