/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.client.gui;

import dev.doctor4t.trainmurdermystery.api.TMMRoles;
import dev.doctor4t.trainmurdermystery.cca.GameTimeComponent;
import dev.doctor4t.trainmurdermystery.cca.GameWorldComponent;
import dev.doctor4t.trainmurdermystery.game.GameConstants;
import dev.doctor4t.trainmurdermystery.game.GameFunctions;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class TimeRenderer {
    public static TimeNumberRenderer view = new TimeNumberRenderer();
    public static float offsetDelta = 0.0f;

    public static void renderHud(class_327 renderer, @NotNull class_746 player, @NotNull class_332 context, float delta) {
        GameWorldComponent gameWorldComponent = (GameWorldComponent)GameWorldComponent.KEY.get((Object)player.method_37908());
        if (gameWorldComponent.isRunning() && (gameWorldComponent.getGameMode() == GameWorldComponent.GameMode.DISCOVERY || gameWorldComponent.isRole((class_1657)player, TMMRoles.KILLER) || GameFunctions.isPlayerSpectatingOrCreative((class_1657)player))) {
            int time = ((GameTimeComponent)GameTimeComponent.KEY.get((Object)player.method_37908())).getTime();
            if (Math.abs(view.getTarget() - (float)time) > 10.0f) {
                offsetDelta = (float)time > view.getTarget() ? 0.6f : -0.6f;
            }
            offsetDelta = time < GameConstants.getInTicks(1, 0) ? -0.9f : class_3532.method_16439((float)(delta / 16.0f), (float)offsetDelta, (float)0.0f);
            view.setTarget(time);
            float r = offsetDelta > 0.0f ? 1.0f - offsetDelta : 1.0f;
            float g = offsetDelta < 0.0f ? 1.0f + offsetDelta : 1.0f;
            float b = 1.0f - Math.abs(offsetDelta);
            int colour = class_3532.method_15353((float)r, (float)g, (float)b) | 0xFF000000;
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)context.method_51421() / 2.0f, 6.0f, 0.0f);
            view.render(renderer, context, 0, 0, colour, delta);
            context.method_51448().method_22909();
        }
    }

    public static void tick() {
        view.update();
    }

    public static class TimeNumberRenderer {
        private final class_3545<ScrollingDigit, ScrollingDigit> minutes = new class_3545((Object)new ScrollingDigit(7200, false), (Object)new ScrollingDigit(720, false));
        private final class_3545<ScrollingDigit, ScrollingDigit> seconds = new class_3545((Object)new ScrollingDigit(120, true), (Object)new ScrollingDigit(12, false));
        private float target;

        public void setTarget(float target) {
            this.target = target;
            float seconds = target / 20.0f;
            float mins = seconds / 60.0f;
            ((ScrollingDigit)this.seconds.method_15442()).setTarget(seconds / 10.0f);
            ((ScrollingDigit)this.seconds.method_15441()).setTarget(seconds);
            ((ScrollingDigit)this.minutes.method_15442()).setTarget(mins / 10.0f);
            ((ScrollingDigit)this.minutes.method_15441()).setTarget(mins);
        }

        public void update() {
            ((ScrollingDigit)this.minutes.method_15442()).update();
            ((ScrollingDigit)this.minutes.method_15441()).update();
            ((ScrollingDigit)this.seconds.method_15442()).update();
            ((ScrollingDigit)this.seconds.method_15441()).update();
        }

        public void render(class_327 renderer, @NotNull class_332 context, int x, int y, int colour, float delta) {
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)x, (float)y, 0.0f);
            context.method_51448().method_46416(16.0f, 0.0f, 0.0f);
            ((ScrollingDigit)this.seconds.method_15441()).render(renderer, context, colour, delta);
            context.method_51448().method_46416(-8.0f, 0.0f, 0.0f);
            ((ScrollingDigit)this.seconds.method_15442()).render(renderer, context, colour, delta);
            context.method_51448().method_46416(-8.0f, 0.0f, 0.0f);
            context.method_25303(renderer, ":", 2, 0, colour);
            context.method_51448().method_46416(-8.0f, 0.0f, 0.0f);
            ((ScrollingDigit)this.minutes.method_15441()).render(renderer, context, colour, delta);
            context.method_51448().method_46416(-8.0f, 0.0f, 0.0f);
            ((ScrollingDigit)this.minutes.method_15442()).render(renderer, context, colour, delta);
            context.method_51448().method_22909();
        }

        public float getTarget() {
            return this.target;
        }
    }

    public static class ScrollingDigit {
        private final int power;
        private final boolean cap6;
        private float target;
        private float value;
        private float lastValue;

        public ScrollingDigit(int power, boolean cap6) {
            this.power = power;
            this.cap6 = cap6;
        }

        public void update() {
            this.lastValue = this.value;
            this.value = class_3532.method_16439((float)0.15f, (float)this.value, (float)this.target);
            if (Math.abs(this.value - this.target) < 0.01f) {
                this.value = this.target;
            }
        }

        public void render(@NotNull class_327 renderer, @NotNull class_332 context, int colour, float delta) {
            float value = class_3532.method_16439((float)delta, (float)this.lastValue, (float)this.value);
            int digit = class_3532.method_15375((float)value) % (this.cap6 ? 6 : 10);
            int digitNext = class_3532.method_15375((float)(value + 1.0f)) % (this.cap6 ? 6 : 10);
            double offset = Math.pow(value % 1.0f, this.power);
            colour &= 0xFFFFFF;
            context.method_51448().method_22903();
            class_4587 class_45872 = context.method_51448();
            double d = -offset;
            Objects.requireNonNull(renderer);
            class_45872.method_22904(0.0, d * (double)(9 + 2), 0.0);
            double alpha = (1.0 - Math.abs(offset)) * 255.0;
            int baseColour = colour | (int)alpha << 24;
            int nextColour = colour | (int)(Math.abs(offset) * 255.0) << 24;
            if ((baseColour & 0xFC000000) != 0) {
                context.method_25303(renderer, String.valueOf(digit), 0, 0, baseColour);
            }
            if ((nextColour & 0xFC000000) != 0) {
                String string = String.valueOf(digitNext);
                Objects.requireNonNull(renderer);
                context.method_25303(renderer, string, 0, 9 + 2, nextColour);
            }
            context.method_51448().method_22909();
        }

        public void setTarget(float target) {
            this.target = target;
        }
    }
}

