/*
 * Decompiled with CFR 0.152.
 */
package net.tlotd.roads_n_vehicles.networking;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2540;

public class TextureSyncPacket {
    public final Map<UUID, Entry> textures;

    public TextureSyncPacket(Map<UUID, Entry> textures) {
        this.textures = textures;
    }

    public void write(class_2540 buf) {
        buf.method_10804(this.textures.size());
        this.textures.forEach((uuid, entry) -> {
            buf.method_10797(uuid);
            buf.method_10804(entry.textureId);
            buf.method_10814(entry.playerName);
        });
    }

    public static TextureSyncPacket read(class_2540 buf) {
        int size = buf.method_10816();
        HashMap<UUID, Entry> textures = new HashMap<UUID, Entry>();
        for (int i = 0; i < size; ++i) {
            UUID uuid = buf.method_10790();
            int tex = buf.method_10816();
            String name = buf.method_10800(Short.MAX_VALUE);
            textures.put(uuid, new Entry(tex, name));
        }
        return new TextureSyncPacket(textures);
    }

    public static class Entry {
        public final int textureId;
        public final String playerName;

        public Entry(int textureId, String playerName) {
            this.textureId = textureId;
            this.playerName = playerName;
        }
    }
}

