/*
 * Decompiled with CFR 0.152.
 */
package net.tlotd.roads_n_vehicles.util;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class CapeManager {
    private static final class_310 MC = class_310.method_1551();
    private static final Map<String, class_2960> CAPE_CACHE = new ConcurrentHashMap<String, class_2960>();
    private static final Map<String, Long> CAPE_CACHE_TIMESTAMPS = new ConcurrentHashMap<String, Long>();
    private static final long CACHE_EXPIRATION_MS = TimeUnit.MINUTES.toMillis(10L);
    private static final class_2960 NO_CAPE = new class_2960("tlotd", "no_cape");
    private static final String CAPE_BASE_URL = "https://tlotd.net/minecraft/capes/";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static class_2960 getCape(String uuid) {
        if (uuid == null) return null;
        if (uuid.isEmpty()) {
            return null;
        }
        long now = Instant.now().toEpochMilli();
        if (CAPE_CACHE.containsKey(uuid)) {
            if (now - CAPE_CACHE_TIMESTAMPS.getOrDefault(uuid, 0L) < CACHE_EXPIRATION_MS) {
                class_2960 cached = CAPE_CACHE.get(uuid);
                if (cached == NO_CAPE) {
                    return null;
                }
                class_2960 class_29602 = cached;
                return class_29602;
            }
            CAPE_CACHE.remove(uuid);
            CAPE_CACHE_TIMESTAMPS.remove(uuid);
        }
        String capeUrl = CAPE_BASE_URL + uuid + ".png";
        try {
            HttpURLConnection head = (HttpURLConnection)new URL(capeUrl).openConnection();
            head.setRequestMethod("HEAD");
            head.setConnectTimeout(1500);
            head.setReadTimeout(1500);
            int responseCode = head.getResponseCode();
            if (responseCode != 200) {
                CAPE_CACHE.put(uuid, NO_CAPE);
                CAPE_CACHE_TIMESTAMPS.put(uuid, now);
                return null;
            }
            HttpURLConnection conn = (HttpURLConnection)new URL(capeUrl).openConnection();
            conn.setConnectTimeout(1500);
            conn.setReadTimeout(1500);
            try (InputStream stream = conn.getInputStream();){
                class_1011 image = class_1011.method_4309((InputStream)stream);
                class_1043 texture = new class_1043(image);
                class_2960 id = new class_2960("tlotd", "cape/" + uuid.replace("-", ""));
                CountDownLatch latch = new CountDownLatch(1);
                AtomicReference result = new AtomicReference();
                MC.execute(() -> {
                    try {
                        if (MC.method_1531() != null) {
                            MC.method_1531().method_4616(id, (class_1044)texture);
                            CAPE_CACHE.put(uuid, id);
                            CAPE_CACHE_TIMESTAMPS.put(uuid, Instant.now().toEpochMilli());
                            result.set(id);
                        } else {
                            System.err.println("[TLOTD] TextureManager is null for " + uuid);
                            CAPE_CACHE.put(uuid, NO_CAPE);
                            CAPE_CACHE_TIMESTAMPS.put(uuid, now);
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                });
                if (!latch.await(1L, TimeUnit.SECONDS)) {
                    System.err.println("[TLOTD] Timeout registering custom cape texture for " + uuid);
                    class_2960 class_29603 = null;
                    return class_29603;
                }
                class_2960 class_29602 = (class_2960)result.get();
                return class_29602;
            }
        }
        catch (Exception e) {
            CAPE_CACHE.put(uuid, NO_CAPE);
            CAPE_CACHE_TIMESTAMPS.put(uuid, now);
            return null;
        }
    }

    public static void clearCache() {
        CAPE_CACHE.clear();
        CAPE_CACHE_TIMESTAMPS.clear();
    }
}

