/*
 * Decompiled with CFR 0.152.
 */
package net.tlotd.roads_n_vehicles.util;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.tlotd.roads_n_vehicles.compat.CompatModsCheck;
import net.tlotd.roads_n_vehicles.networking.ServerTextureSync;
import net.tlotd.roads_n_vehicles.world.CustomTextureManager;

public class ModCommands {
    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            if (!CompatModsCheck.TLOTD) {
                dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"roads_n_vehicles").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"textureID").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").executes(ctx -> {
                    class_2168 source = (class_2168)ctx.getSource();
                    class_3222 player = source.method_44023();
                    if (player == null) {
                        source.method_9213((class_2561)class_2561.method_43470((String)"You must be a player to use this without arguments."));
                        return 0;
                    }
                    CustomTextureManager manager = CustomTextureManager.get(source.method_9211());
                    int id = manager.getTexture(player.method_5667());
                    if (id >= 0) {
                        source.method_9226(() -> class_2561.method_43470((String)"Your custom texture ID is ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(id)).method_27692(class_124.field_1075)), false);
                    } else {
                        source.method_9226(() -> class_2561.method_43470((String)"You don\u2019t have a custom texture ID assigned."), false);
                    }
                    return 1;
                })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(ctx -> {
                    class_2168 source = (class_2168)ctx.getSource();
                    Collection profiles = class_2191.method_9330((CommandContext)ctx, (String)"player");
                    CustomTextureManager manager = CustomTextureManager.get(source.method_9211());
                    for (GameProfile profile : profiles) {
                        int id = manager.getTexture(profile.getId());
                        if (id >= 0) {
                            source.method_9226(() -> class_2561.method_43470((String)"\ud83c\udfa8 ").method_10852((class_2561)class_2561.method_43470((String)(profile.getName() + " \u2192 ID " + id)).method_27692(class_124.field_1075)), false);
                            continue;
                        }
                        source.method_9226(() -> class_2561.method_43470((String)(profile.getName() + " has no assigned texture ID.")), false);
                    }
                    return 1;
                })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0, (int)127)).executes(ctx -> {
                    class_2168 source = (class_2168)ctx.getSource();
                    Collection profiles = class_2191.method_9330((CommandContext)ctx, (String)"player");
                    int id = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id");
                    CustomTextureManager manager = CustomTextureManager.get(source.method_9211());
                    for (GameProfile profile : profiles) {
                        manager.setTexture(profile.getId(), id);
                    }
                    ServerTextureSync.syncAll(((class_2168)ctx.getSource()).method_9225());
                    source.method_9226(() -> class_2561.method_43470((String)("Set custom texture ID to " + id + " for " + profiles.size() + " player(s).")), true);
                    return 1;
                }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(source -> source.method_9259(2))).executes(ctx -> {
                    class_2168 source = (class_2168)ctx.getSource();
                    CustomTextureManager manager = CustomTextureManager.get(source.method_9211());
                    Map<UUID, Integer> skins = manager.getAll();
                    if (skins.isEmpty()) {
                        source.method_9226(() -> class_2561.method_43470((String)"No custom texture IDs have been assigned yet."), false);
                        return 1;
                    }
                    source.method_9226(() -> class_2561.method_43470((String)"Assigned custom texture IDs:").method_27692(class_124.field_1065), false);
                    MinecraftServer server = source.method_9211();
                    for (Map.Entry<UUID, Integer> entry : skins.entrySet()) {
                        String name = server.method_3793().method_14512(entry.getKey()).map(GameProfile::getName).orElse(entry.getKey().toString());
                        source.method_9226(() -> class_2561.method_43470((String)("- " + name + ": ")).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(entry.getValue())).method_27692(class_124.field_1075)), false);
                    }
                    return 1;
                }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(ctx -> {
                    class_2168 source = (class_2168)ctx.getSource();
                    Collection profiles = class_2191.method_9330((CommandContext)ctx, (String)"player");
                    CustomTextureManager manager = CustomTextureManager.get(source.method_9211());
                    int[] removedCount = new int[]{0};
                    for (GameProfile profile : profiles) {
                        if (manager.removeTexture(profile.getId())) {
                            removedCount[0] = removedCount[0] + 1;
                            source.method_9226(() -> class_2561.method_43470((String)("Removed custom texture ID for " + profile.getName() + ".")), true);
                            continue;
                        }
                        source.method_9226(() -> class_2561.method_43470((String)(profile.getName() + " had no custom texture ID assigned.")), false);
                    }
                    if (removedCount[0] == 0) {
                        source.method_9226(() -> class_2561.method_43470((String)"No entries were removed."), false);
                    } else if (removedCount[0] > 1) {
                        int finalCount = removedCount[0];
                        source.method_9226(() -> class_2561.method_43470((String)("Removed " + finalCount + " player entries.")), true);
                    }
                    return 1;
                })))));
            }
        });
    }
}

