/*
 * Decompiled with CFR 0.152.
 */
package net.tlotd.roads_n_vehicles.world;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class CustomTextureManager
extends class_18 {
    private final Map<UUID, Integer> textureMap = new HashMap<UUID, Integer>();

    public static CustomTextureManager get(MinecraftServer server) {
        class_3218 overworld = server.method_30002();
        return (CustomTextureManager)overworld.method_17983().method_17924(CustomTextureManager::fromNbt, CustomTextureManager::new, "TLOTD_RnV_Textures");
    }

    public static CustomTextureManager fromNbt(class_2487 tag) {
        CustomTextureManager manager = new CustomTextureManager();
        class_2499 list = tag.method_10554("Textures", 10);
        for (class_2520 e : list) {
            class_2487 nbt = (class_2487)e;
            manager.textureMap.put(nbt.method_25926("Player"), nbt.method_10550("Texture"));
        }
        return manager;
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (Map.Entry<UUID, Integer> entry : this.textureMap.entrySet()) {
            class_2487 textureData = new class_2487();
            textureData.method_25927("Player", entry.getKey());
            textureData.method_10569("Texture", entry.getValue().intValue());
            list.add((Object)textureData);
        }
        nbt.method_10566("Textures", (class_2520)list);
        return nbt;
    }

    public void setTexture(UUID player, int textureId) {
        this.textureMap.put(player, textureId);
        this.method_80();
    }

    public int getTexture(UUID player) {
        return this.textureMap.getOrDefault(player, -1);
    }

    public Map<UUID, Integer> getAll() {
        return Collections.unmodifiableMap(this.textureMap);
    }

    public boolean removeTexture(UUID player) {
        if (this.textureMap.remove(player) != null) {
            this.method_80();
            return true;
        }
        return false;
    }

    public boolean hasTexture(UUID player) {
        return this.textureMap.containsKey(player);
    }
}

