/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.repurposedend.item.custom;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;

public class SmithingTemplateScale
extends Item {
    private static final ChatFormatting TITLE_FORMAT = ChatFormatting.GRAY;
    private static final ChatFormatting DESCRIPTION_FORMAT = ChatFormatting.BLUE;
    private static final Component INGREDIENTS_TITLE = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"smithing_template.ingredients"))).withStyle(TITLE_FORMAT);
    private static final Component APPLIES_TO_TITLE = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"smithing_template.applies_to"))).withStyle(TITLE_FORMAT);
    private static final Component SMITHING_TEMPLATE_SUFFIX = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"smithing_template"))).withStyle(TITLE_FORMAT);
    private static final Component NETHERITE_UPGRADE_APPLIES_TO = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"repurposedend", (String)"smithing_scale.applies_to"))).withStyle(DESCRIPTION_FORMAT);
    private static final Component NETHERITE_UPGRADE_INGREDIENTS = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"repurposedend", (String)"smithing_scale.ingredients"))).withStyle(DESCRIPTION_FORMAT);
    private static final Component NETHERITE_UPGRADE_BASE_SLOT_DESCRIPTION = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"repurposedend", (String)"smithing_scale.base_slot_description")));
    private static final Component NETHERITE_UPGRADE_ADDITIONS_SLOT_DESCRIPTION = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"repurposedend", (String)"smithing_scale.additions_slot_description")));
    private static final ResourceLocation EMPTY_SLOT_HELMET = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_helmet");
    private static final ResourceLocation EMPTY_SLOT_CHESTPLATE = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_chestplate");
    private static final ResourceLocation EMPTY_SLOT_LEGGINGS = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_leggings");
    private static final ResourceLocation EMPTY_SLOT_BOOTS = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_boots");
    private static final ResourceLocation EMPTY_SLOT_HOE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_hoe");
    private static final ResourceLocation EMPTY_SLOT_AXE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_axe");
    private static final ResourceLocation EMPTY_SLOT_SWORD = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_sword");
    private static final ResourceLocation EMPTY_SLOT_SHOVEL = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_shovel");
    private static final ResourceLocation EMPTY_SLOT_PICKAXE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_pickaxe");
    private static final ResourceLocation EMPTY_SLOT_INGOT = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_ingot");
    private final Component appliesTo;
    private final Component ingredients;

    public SmithingTemplateScale(Component pAppliesTo, Component pIngredients, FeatureFlag ... pRequiredFeatures) {
        super(new Item.Properties().requiredFeatures(pRequiredFeatures));
        this.appliesTo = pAppliesTo;
        this.ingredients = pIngredients;
    }

    public static SmithingTemplateItem createNetheriteUpgradeTemplate(Item.Properties p_368215_) {
        return new SmithingTemplateItem(NETHERITE_UPGRADE_APPLIES_TO, NETHERITE_UPGRADE_INGREDIENTS, NETHERITE_UPGRADE_BASE_SLOT_DESCRIPTION, NETHERITE_UPGRADE_ADDITIONS_SLOT_DESCRIPTION, SmithingTemplateScale.createNetheriteUpgradeIconList(), SmithingTemplateScale.createNetheriteUpgradeMaterialList(), p_368215_);
    }

    private static List<ResourceLocation> createNetheriteUpgradeIconList() {
        return List.of(EMPTY_SLOT_HELMET, EMPTY_SLOT_SWORD, EMPTY_SLOT_CHESTPLATE, EMPTY_SLOT_PICKAXE, EMPTY_SLOT_LEGGINGS, EMPTY_SLOT_AXE, EMPTY_SLOT_BOOTS, EMPTY_SLOT_HOE, EMPTY_SLOT_SHOVEL);
    }

    private static List<ResourceLocation> createNetheriteUpgradeMaterialList() {
        return List.of(EMPTY_SLOT_INGOT);
    }

    public void appendHoverText(ItemStack p_267313_, Item.TooltipContext p_331023_, TooltipDisplay p_393075_, Consumer<Component> p_394742_, TooltipFlag p_266857_) {
        p_394742_.accept(SMITHING_TEMPLATE_SUFFIX);
        p_394742_.accept(CommonComponents.EMPTY);
        p_394742_.accept(APPLIES_TO_TITLE);
        p_394742_.accept((Component)CommonComponents.space().append(this.appliesTo));
        p_394742_.accept(INGREDIENTS_TITLE);
        p_394742_.accept((Component)CommonComponents.space().append(this.ingredients));
    }
}

