/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.repurposedend.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.baffledbanana87.repurposedend.entity.custom.CryingWither;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.WitherBossModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.WitherArmorLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.WitherRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CryingWitherRenderer
extends MobRenderer<CryingWither, WitherRenderState, WitherBossModel> {
    private static final ResourceLocation WITHER_INVULNERABLE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/wither/wither_invulnerable.png");
    private static final ResourceLocation WITHER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"repurposedend", (String)"textures/entity/cryingwither.png");

    public CryingWitherRenderer(EntityRendererProvider.Context p_174445_) {
        super(p_174445_, (EntityModel)new WitherBossModel(p_174445_.bakeLayer(ModelLayers.WITHER)), 1.0f);
        this.addLayer((RenderLayer)new WitherArmorLayer((RenderLayerParent)this, p_174445_.getModelSet()));
    }

    protected int getBlockLightLevel(CryingWither p_116443_, BlockPos p_116444_) {
        return 15;
    }

    public ResourceLocation getTextureLocation(WitherRenderState p_368277_) {
        int i = Mth.floor((float)p_368277_.invulnerableTicks);
        return i > 0 && (i > 80 || i / 5 % 2 != 1) ? WITHER_INVULNERABLE_LOCATION : WITHER_LOCATION;
    }

    public WitherRenderState createRenderState() {
        return new WitherRenderState();
    }

    protected void scale(WitherRenderState p_370233_, PoseStack p_116434_) {
        float f = 2.0f;
        if (p_370233_.invulnerableTicks > 0.0f) {
            f -= p_370233_.invulnerableTicks / 220.0f * 0.5f;
        }
        p_116434_.scale(f, f, f);
    }

    public void extractRenderState(CryingWither p_369559_, WitherRenderState p_363159_, float p_363731_) {
        super.extractRenderState((LivingEntity)p_369559_, (LivingEntityRenderState)p_363159_, p_363731_);
        int i = p_369559_.getInvulnerableTicks();
        p_363159_.invulnerableTicks = i > 0 ? (float)i - p_363731_ : 0.0f;
        System.arraycopy(p_369559_.getHeadXRots(), 0, p_363159_.xHeadRots, 0, p_363159_.xHeadRots.length);
        System.arraycopy(p_369559_.getHeadYRots(), 0, p_363159_.yHeadRots, 0, p_363159_.yHeadRots.length);
        p_363159_.isPowered = p_369559_.isPowered();
    }
}

