package dev.kikugie.elytratrims.mixin.render;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.kikugie.elytratrims.api.item.ETItemFlag;
import dev.kikugie.elytratrims.render.ETRendererKt;
import dev.kikugie.elytratrims.render.SmithingTableRenderData;
import dev.kikugie.elytratrims.resource.ETTags;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_4895;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@MixinEnvironment(type = MixinEnvironment.Env.CLIENT)
@Mixin(class_4895.class)
public class SmithingScreenMixin {
	@Shadow
	private @Nullable class_1531 armorStandPreview;

	@Unique
	private final SmithingTableRenderData renderData = new SmithingTableRenderData();

	@Inject(method = "containerTick", at = @At("TAIL"))
	private void tickArmorStand(CallbackInfo ci) {
		if (armorStandPreview != null)
			armorStandPreview.method_5773();
	}

	@ModifyExpressionValue(method = "updateArmorStandPreview", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;copy()Lnet/minecraft/world/item/ItemStack;"))
	private class_1799 rotateIfHasElytra(class_1799 stack) {
		renderData.update(stack.method_31573(ETTags.ELYTRA_DECORATABLE));
		ETItemFlag.DEBUG.set(stack, true);
		return stack;
	}

	@WrapOperation(method = "renderBg", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/inventory/InventoryScreen;renderEntityInInventory(Lnet/minecraft/client/gui/GuiGraphics;IIIIFLorg/joml/Vector3f;Lorg/joml/Quaternionf;Lorg/joml/Quaternionf;Lnet/minecraft/world/entity/LivingEntity;)V"))
	private void renderArmorStand(class_332 gui, int x1, int y1, int x2, int y2, float scale, Vector3f translation, Quaternionf angle, @Nullable Quaternionf ignored, class_1309 stand, Operation<Void> original, @Local(argsOnly = true) float partial, @Local(argsOnly = true, ordinal = 0) int mouseX, @Local(argsOnly = true, ordinal = 1) int mouseY) {
		renderData.tick(partial);
		ETRendererKt.renderEntityInInventoryFollowsMouse(gui, x1, y1, x2, y2, (int) scale, 0F, mouseX, mouseY, stand, renderData.getRotation());
	}
}
