package dev.kikugie.elytratrims.mixin.resource;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.kikugie.elytratrims.resource.pack.ETRuntimePack;
import dev.kikugie.elytratrims.resource.pack.ETRuntimePackUtilsKt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_6861;

@Mixin(class_6861.class)
public class MultiPackResourceManagerMixin {

    @Inject(method = "<init>", at = @At(value = "INVOKE", target = "Ljava/util/List;copyOf(Ljava/util/Collection;)Ljava/util/List;"))
    private void injectElytraTrimsPacks(class_3264 type, List<class_3262> packs, CallbackInfo ci, @Local(argsOnly = true) LocalRef<List<class_3262>> packsRef) {
        if (ETRuntimePackUtilsKt.isWrapped(packs) || !ETRuntimePackUtilsKt.hasElytraTrimsPack(packs))
            return;

        ETRuntimePack injected = ETRuntimePack.of(type, new class_6861(type, ETRuntimePackUtilsKt.wrap(packs)));
        if (injected == null)
            return;

        List<class_3262> copy = new ArrayList<>(packs);
        copy.add(injected);
        packsRef.set(copy);
    }
}
