package dev.kikugie.elytratrims.mixin;

import dev.kikugie.elytratrims.item.ItemFlagTooltipProvider;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_9323;

@Mixin(class_1799.class)
public abstract class ItemStackMixin {
    @Shadow
    public abstract class_9323 getComponents();

    @Inject(
        method = "addDetailsToTooltip",
        at = @At(
            value = "INVOKE",
            ordinal = 19,
            target = "Lnet/minecraft/world/item/ItemStack;addToTooltip(Lnet/minecraft/core/component/DataComponentType;Lnet/minecraft/world/item/Item$TooltipContext;Lnet/minecraft/world/item/component/TooltipDisplay;Ljava/util/function/Consumer;Lnet/minecraft/world/item/TooltipFlag;)V"))
    private void injectETTooltips(class_1792.class_9635 context, class_10712 display, @Nullable class_1657 player, class_1836 flag, Consumer<class_2561> adder, CallbackInfo ci) {
        ItemFlagTooltipProvider.GLOW.addToTooltip(context, adder, flag, getComponents());
        ItemFlagTooltipProvider.COSMIC.addToTooltip(context, adder, flag, getComponents());
        ItemFlagTooltipProvider.BAD_APPLE.addToTooltip(context, adder, flag, getComponents());
    }
}
