package dev.kikugie.elytratrims.mixin.resource;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.kikugie.elytratrims.resource.pack.ETRuntimePack;
import dev.kikugie.elytratrims.resource.pack.ETRuntimePackUtilsKt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_6861;

@Mixin(value = class_6861.class, priority = 900)
public class MultiPackResourceManagerMixin {
    @ModifyVariable(method = "<init>", at = @At(value = "HEAD"), argsOnly = true)
    private static List<class_3262> injectElytraTrimsPacks(List<class_3262> packs, @Local(argsOnly = true) class_3264 type) {
        if (ETRuntimePackUtilsKt.isWrapped(packs) || !ETRuntimePackUtilsKt.hasElytraTrimsPack(packs))
            return packs;

        ETRuntimePack injected = ETRuntimePack.of(type, new class_6861(type, ETRuntimePackUtilsKt.wrap(packs)));
        if (injected == null)
            return packs;

        List<class_3262> copy = new ArrayList<>(packs);
        copy.add(injected);
        return copy;
    }
}
