package dev.kikugie.elytratrims.render.impl

import dev.kikugie.elytratrims.*
import dev.kikugie.elytratrims.api.impl.copy
import dev.kikugie.elytratrims.api.impl.getEffectiveLight
import dev.kikugie.elytratrims.api.impl.submitToCollector
import dev.kikugie.elytratrims.api.item.ETItemFlag
import dev.kikugie.elytratrims.api.render.ETDecorator
import dev.kikugie.elytratrims.api.render.ETRenderMethod
import dev.kikugie.elytratrims.api.render.ETRenderParameters
import dev.kikugie.elytratrims.api.render.ETRendererID
import dev.kikugie.elytratrims.item.PatternsAccess.Companion.patterns
import dev.kikugie.elytratrims.item.invoke
import dev.kikugie.elytratrims.render.RENDER_LOGGER
import dev.kikugie.elytratrims.render.getSprite
import dev.kikugie.elytratrims.render.isMissing
import dev.kikugie.elytratrims.resource.image.Color4i
import dev.kikugie.elytratrims.resource.reload.ElytraTrimsAtlas
import net.minecraft.client.renderer.texture.TextureAtlasSprite
import net.minecraft.core.Holder
import net.minecraft.world.level.block.entity.BannerPattern

object ETPatternsRenderer : ETDecorator {
    @JvmField val type: ETRendererID = ETRendererID(elytratrims("patterns"), ETRenderMethod.POST)

    private val reported = mutableSetOf<Identifier>()
    private val patterns: Memoizer<Pair<Holder<BannerPattern>, Boolean>, TextureAtlasSprite> = memoize { (pattern, banner) ->
        ElytraTrimsAtlas./*? if >=1.21.9 {*//*ATLAS_ID*//*?} else*/ATLAS_SHEET
            .getSprite(texture(pattern.value().assetId, banner), ::report)
    }

    //? if <1.21.9 {
    private val converterImpl: ETRenderParameters.VertexConsumerFactory = ETRenderParameters.VertexConsumerFactory { prm, src ->
        val sprite = checkNotNull(prm.sprite) { "Sprite should be set for pattern rendering" }
        net.minecraft.client.renderer.entity.ItemRenderer.getArmorFoilBuffer(src, prm.render, prm.stack.hasFoil()).let(sprite::wrap)
    }
    //?}

    override fun getType(): ETRendererID = type

    override fun prepare(parameters: ETRenderParameters): ETRenderParameters = with(parameters) {
        if (stack.patterns()?.layers.isNullOrEmpty()) return@with parameters
        copy(
            light = getEffectiveLight(),
            /*? if <1.21.9*/argument = converterImpl
        )
    }

    override fun render(parameters: ETRenderParameters, collector: RenderConsumer): Boolean = with(parameters) {
        val banner = ETItemFlag.BANNER[stack]
        for (it in stack.patterns) {
            val sprite = patterns(it.pattern to banner)
            if (sprite.isMissing && !ETItemFlag.DEBUG[stack]) continue

            val blend = Color4i(color).blend(Color4i(it.color))
            copy(sprite = sprite, color = blend.value, render = ElytraTrimsAtlas.elytraTrimsSheet(false)).submitToCollector(collector)
        }

        stack.patterns.isNotEmpty()
    }

    fun report(id: Identifier) {
        if (reported.add(id)) RENDER_LOGGER.warn("Missing pattern texture: $id")
    }

    override fun reset() {
        reported.clear()
        patterns.clear()
    }

    private fun texture(asset: Identifier, banner: Boolean) = asset.withPrefix(if (banner) "entity/wings/banner/" else "entity/wings/shield/")
}