package dev.kikugie.elytratrims.api;

import dev.kikugie.elytratrims.client.ETClient;
import dev.kikugie.elytratrims.client.config.ETClientConfig;
import dev.kikugie.elytratrims.client.config.RenderType;
import dev.kikugie.elytratrims.client.render.ETRenderer;
import dev.kikugie.elytratrims.client.resource.ETAtlasHolder;
import dev.kikugie.elytratrims.common.util.ColorKt;
import dev.kikugie.elytratrims.common.util.UtilKt;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1770;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("unused")
public class ElytraTrimsAPI {
	/**
	 * Provides feature rendering access for custom elytras.
	 *
	 * @param model Elytra model
	 * @param matrices Transformation matrices
	 * @param provider Vertex consumer provider duh
	 * @param entity Elytra wearer or null
	 * @param stack Elytra item stack
	 * @param light Lightmap coordinates
	 * @param red Red color value
	 * @param green Green color value
	 * @param blue Blue color value
	 * @param alpha Alpha value
	 */
	public static void renderFeatures(
			@NotNull class_3879 model,
			@NotNull class_4587 matrices,
			@NotNull class_4597 provider,
			@Nullable class_1309 entity,
			@NotNull class_1799 stack,
			int light,
			float red,
			float green,
			float blue,
			float alpha) {
		int color = ColorKt.toARGB(red, green, blue, alpha);
		renderFeatures(model, matrices, provider, entity, stack, light, color);
	}

	/**
	 * Provides feature rendering access for custom elytras.
	 *
	 * @param model Elytra model
	 * @param matrices Transformation matrices
	 * @param provider Vertex consumer provider duh
	 * @param entity Elytra wearer or null
	 * @param stack Elytra item stack
	 * @param light Lightmap coordinates
	 * @param color ARGB color integer
	 */
	public static void renderFeatures(
			@NotNull class_3879 model,
			@NotNull class_4587 matrices,
			@NotNull class_4597 provider,
			@Nullable class_1309 entity,
			@NotNull class_1799 stack,
			int light,
			int color) {
		ETRenderer.render(model, matrices, provider, entity, stack, light, color);
	}

	/**
	 * Checks if the player has elytra cape rendering enabled in their config.
	 *
	 * @param entity Entity to be rendered
	 * @return False if cape rendering is disabled in config
	 */
	public static boolean shouldShowCape(@NotNull class_1309 entity) {
		return ETRenderer.shouldRender(RenderType.CAPE, entity);
	}

	/**
	 * Checks if the item is supposed to be an elytra.
	 * <br>
	 * Implementations are quite inconsistent across mods, so it checks the following criterias:
	 * <li>Item extends {@link class_1770}.</li>
	 * <li>Item implements <a href="https://github.com/FabricMC/fabric/blob/1.21/fabric-entity-events-v1/src/main/java/net/fabricmc/fabric/api/entity/event/v1/FabricElytraItem.java">FabricElytraItem</a>.</li>
	 * <li>Item extends {@link class_1738} and contains "elytra" in its id.</li>
	 * @param stack Item stack to check
	 * @return True if this item should be an elytra
	 */
	public static boolean isProbablyElytra(@NotNull class_1799 stack) {
		return isProbablyElytra(stack.method_7909());
	}

	/**
	 * Checks if the item is supposed to be an elytra.
	 * <br>
	 * Implementations are quite inconsistent across mods, so it checks the following criterias:
	 * <li>Item extends {@link class_1770}.</li>
	 * <li>Item implements <a href="https://github.com/FabricMC/fabric/blob/1.21/fabric-entity-events-v1/src/main/java/net/fabricmc/fabric/api/entity/event/v1/FabricElytraItem.java">FabricElytraItem</a>.</li>
	 * <li>Item extends {@link class_1738} and contains "elytra" in its id.</li>
	 *
	 * @param item Item to check
	 * @return True if this item should be an elytra
	 */
	public static boolean isProbablyElytra(@NotNull class_1792 item) {
		return UtilKt.isProbablyElytra(item);
	}

	/**
	 * @return Elytra render layer for the default trim atlas texture
	 */
	public static @NotNull class_1921 getElytraLayer() {
		return ETRenderer.layer.invoke(ETAtlasHolder.INSTANCE.getId());
	}

	/**
	 * @return The configuration instance for the mod
	 */
	public static @NotNull ETClientConfig getConfig() {
		return ETClient.INSTANCE.getConfig();
	}
}