package dev.kikugie.elytratrims.mixin.compat.render;

import com.bawnorton.mixinsquared.TargetHandler;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.kikugie.elytratrims.api.ElytraTrimsAPI;
import dev.kikugie.elytratrims.mixin.constants.Targets;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_563;
import net.minecraft.class_979;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;

@Pseudo
@SuppressWarnings("UnresolvedMixinReference")
@Restriction(require = {@Condition("minecraftcapes")})
@Mixin(value = class_979.class, priority = 1500)
public class MinecraftCapesMixin {
	@TargetHandler(mixin = "net.minecraftcapes.mixin.MixinElytraLayer", name = "render")
	@ModifyExpressionValue(method = "@MixinSquared:Handler", at = @At(value = "INVOKE", target = Targets.isPartVisible))
	private boolean minecraftcapes$cancelCapeRender(boolean original, @Local(argsOnly = true) class_1309 entity) {
		return ElytraTrimsAPI.shouldShowCape(entity) && original;
	}

	@TargetHandler(mixin = "net.minecraftcapes.mixin.MixinElytraLayer", name = "render")
	@ModifyExpressionValue(method = "@MixinSquared:Handler", at = @At(value = "INVOKE", target = "Lnet/minecraftcapes/config/MinecraftCapesConfig;isCapeVisible()Z"))
	private boolean minecraftcapes$cancelCapeRender2(boolean original, @Local(argsOnly = true) class_1309 entity) {
		return ElytraTrimsAPI.shouldShowCape(entity) && original;
	}

	@TargetHandler(mixin = "net.minecraftcapes.mixin.MixinElytraLayer", name = "render")
	@WrapOperation(method = "@MixinSquared:Handler", at = @At(value = "INVOKE", target = Targets.renderModel))
	private void minecraftcapes$elytraPostRender(
			class_563<?> model,
			class_4587 matrices,
			class_4588 vertices,
			int light,
			int overlay,
			//? if <1.21 {
			float red,
			float green,
			float blue,
			float alpha,
			//?}
			Operation<Void> operation,
			@Local(argsOnly = true) class_4597 provider,
			@Local(argsOnly = true) class_1309 entity) {
		class_1799 stack = entity.method_6118(class_1304.field_6174);
		//$ render_call {
        operation.call(model, matrices, vertices, light, overlay, red, green, blue, alpha);
        ElytraTrimsAPI.renderFeatures(model, matrices, provider, entity, stack, light, red, green, blue, alpha);//$}
	}
}