package dev.kikugie.elytratrims.mixin.compat.render;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.kikugie.elytratrims.api.ElytraTrimsAPI;
import dev.kikugie.elytratrims.mixin.constants.Targets;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;

@Pseudo
@SuppressWarnings({"UnresolvedMixinReference", "rawtypes", "LocalMayBeArgsOnly"})
@Restriction(require = {@Condition("elytra_trinket")})
@Mixin(targets = "pw.lakuna.elytra_trinket.ElytraTrinketFeatureRenderer")
public abstract class ElytraTrinketMixin extends RenderLayer {
    public ElytraTrinketMixin(RenderLayerParent context) {
        super(context);
    }

    @ModifyExpressionValue(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/AbstractClientPlayerEntity;isPartVisible(Lnet/minecraft/client/render/entity/PlayerModelPart;)Z"))
    private boolean elytra_trinket$cancelCapeRender(boolean original, @Local(argsOnly = true) LivingEntity entity) {
        return ElytraTrimsAPI.shouldShowCape(entity) && original;
    }

    @WrapOperation(method = "render", at = @At(value = "INVOKE", target = Targets.renderModel))
    private void elytra_trinket$elytraPostRender(
            ElytraModel<?> model,
            PoseStack matrices,
            VertexConsumer vertices,
            int light,
            int overlay,
            //? if <1.21 {
            /*float red,
            float green,
            float blue,
            float alpha,
            *///?}
            Operation<Void> operation,
            @Local(argsOnly = true) MultiBufferSource provider,
            @Local(argsOnly = true) LivingEntity entity,
            @Local ItemStack stack) {
        //$ render_call {
        operation.call(model, matrices, vertices, light, overlay);
        ElytraTrimsAPI.renderFeatures(model, matrices, provider, entity, stack, light, -1);//$}
    }
}