package dev.kikugie.elytratrims.mixin.compat.render;

import com.bawnorton.mixinsquared.TargetHandler;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.kikugie.elytratrims.api.ElytraTrimsAPI;
import dev.kikugie.elytratrims.mixin.constants.Targets;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;

@Pseudo
@SuppressWarnings("UnresolvedMixinReference")
@Restriction(require = {@Condition("minecraftcapes")})
@Mixin(value = ElytraLayer.class, priority = 1500)
public class MinecraftCapesMixin {
	@TargetHandler(mixin = "net.minecraftcapes.mixin.MixinElytraLayer", name = "render")
	@ModifyExpressionValue(method = "@MixinSquared:Handler", at = @At(value = "INVOKE", target = Targets.isPartVisible))
	private boolean minecraftcapes$cancelCapeRender(boolean original, @Local(argsOnly = true) LivingEntity entity) {
		return ElytraTrimsAPI.shouldShowCape(entity) && original;
	}

	@TargetHandler(mixin = "net.minecraftcapes.mixin.MixinElytraLayer", name = "render")
	@ModifyExpressionValue(method = "@MixinSquared:Handler", at = @At(value = "INVOKE", target = "Lnet/minecraftcapes/config/MinecraftCapesConfig;isCapeVisible()Z"))
	private boolean minecraftcapes$cancelCapeRender2(boolean original, @Local(argsOnly = true) LivingEntity entity) {
		return ElytraTrimsAPI.shouldShowCape(entity) && original;
	}

	@TargetHandler(mixin = "net.minecraftcapes.mixin.MixinElytraLayer", name = "render")
	@WrapOperation(method = "@MixinSquared:Handler", at = @At(value = "INVOKE", target = Targets.renderModel))
	private void minecraftcapes$elytraPostRender(
			ElytraModel<?> model,
			PoseStack matrices,
			VertexConsumer vertices,
			int light,
			int overlay,
			//? if <1.21 {
			/*float red,
			float green,
			float blue,
			float alpha,
			*///?}
			Operation<Void> operation,
			@Local(argsOnly = true) MultiBufferSource provider,
			@Local(argsOnly = true) LivingEntity entity) {
		ItemStack stack = entity.getItemBySlot(EquipmentSlot.CHEST);
		//$ render_call {
        operation.call(model, matrices, vertices, light, overlay);
        ElytraTrimsAPI.renderFeatures(model, matrices, provider, entity, stack, light, -1);//$}
	}
}