package dev.kikugie.elytratrims.mixin.common;

import com.llamalad7.mixinextras.sugar.Local;
import dev.kikugie.elytratrims.common.ETCommon;
import dev.kikugie.elytratrims.common.util.UtilKt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;

@Mixin(ReloadableServerResources.class)
public abstract class DataPackContentsMixin {
	@Unique
	private static final ResourceLocation key = UtilKt.identifier("item");

	@ModifyArg(method = "repopulateTags", at = @At(value = "INVOKE", target = "Lnet/minecraft/registry/Registry;populateTags(Ljava/util/Map;)V"))
	private static Map<TagKey<?>, List<Holder<?>>> insertElytraTags(Map<TagKey<?>, List<Holder<?>>> tagEntries, @Local(argsOnly = true) TagManager.LoadResult<?> tags) {
		ETCommon.postInit();
		return key.equals(tags.f_203928_().m_135782_()) ? UtilKt.populateTags(tagEntries) : tagEntries;
	}
}