/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.api;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.kikugie.elytratrims.client.ETClient;
import dev.kikugie.elytratrims.client.config.ETClientConfig;
import dev.kikugie.elytratrims.client.render.ETRenderer;
import dev.kikugie.elytratrims.client.resource.ETAtlasHolder;
import dev.kikugie.elytratrims.common.util.ColorKt;
import dev.kikugie.elytratrims.common.util.UtilKt;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElytraTrimsAPI {
    public static void renderFeatures(@NotNull Model model, @NotNull PoseStack matrices, @NotNull MultiBufferSource provider, @Nullable LivingEntity entity, @NotNull ItemStack stack, int light, float red, float green, float blue, float alpha) {
        int color = ColorKt.toARGB(red, green, blue, alpha);
        ElytraTrimsAPI.renderFeatures(model, matrices, provider, entity, stack, light, color);
    }

    public static void renderFeatures(@NotNull Model model, @NotNull PoseStack matrices, @NotNull MultiBufferSource provider, @Nullable LivingEntity entity, @NotNull ItemStack stack, int light, int color) {
        ETRenderer.render(model, matrices, provider, entity, stack, light, color);
    }

    public static boolean shouldShowCape(@NotNull LivingEntity entity) {
        return ETRenderer.shouldRender(dev.kikugie.elytratrims.client.config.RenderType.CAPE, entity);
    }

    public static boolean isProbablyElytra(@NotNull ItemStack stack) {
        return ElytraTrimsAPI.isProbablyElytra(stack.m_41720_());
    }

    public static boolean isProbablyElytra(@NotNull Item item) {
        return UtilKt.isProbablyElytra(item);
    }

    @NotNull
    public static RenderType getElytraLayer() {
        return (RenderType)ETRenderer.layer.invoke((Object)ETAtlasHolder.INSTANCE.getId());
    }

    @NotNull
    public static ETClientConfig getConfig() {
        return ETClient.INSTANCE.getConfig();
    }
}

