/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.common.compat;

import com.bawnorton.allthetrims.client.util.PaletteHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.kikugie.elytratrims.client.render.ETRenderer;
import dev.kikugie.elytratrims.client.render.FeatureRendererKt;
import dev.kikugie.elytratrims.client.render.TrimOverlayRenderer;
import dev.kikugie.elytratrims.client.resource.ImageUtilsKt;
import dev.kikugie.elytratrims.common.util.ColorKt;
import dev.kikugie.elytratrims.platform.ModStatus;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jk\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00040\u0015\u00a2\u0006\u0004\b\u0019\u0010\u001aJi\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\n\u0010\u001c\u001a\u00060\u0012j\u0002`\u001b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00040\u0015H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJY\u0010 \u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b#\u0010$R\u0017\u0010%\u001a\u00020\"8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b%\u0010'\u00a8\u0006("}, d2={"Ldev/kikugie/elytratrims/common/compat/AllTheTrimsCompat;", "", "<init>", "()V", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "sprite", "Lnet/minecraft/client/model/Model;", "model", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/client/renderer/MultiBufferSource;", "provider", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/item/armortrim/ArmorTrim;", "trim", "", "light", "colour", "Lkotlin/Function1;", "Ldev/kikugie/elytratrims/client/render/TrimOverlayRenderer$TrimInfo;", "func", "", "renderTrimAtt", "(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lnet/minecraft/client/model/Model;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/armortrim/ArmorTrim;IILkotlin/jvm/functions/Function1;)V", "Ldev/kikugie/elytratrims/common/util/ARGB;", "color", "cache", "renderTrimExtendedLegacy", "(Lnet/minecraft/client/model/Model;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/armortrim/ArmorTrim;IILkotlin/jvm/functions/Function1;)V", "renderTrimExtended", "(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lnet/minecraft/client/model/Model;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/armortrim/ArmorTrim;II)V", "", "isSpriteDynamic", "(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)Z", "isLegacyATT", "Z", "()Z", "elytratrims-forge"})
public final class AllTheTrimsCompat {
    @NotNull
    public static final AllTheTrimsCompat INSTANCE = new AllTheTrimsCompat();
    private static final boolean isLegacyATT;

    private AllTheTrimsCompat() {
    }

    public final boolean isLegacyATT() {
        return isLegacyATT;
    }

    public final void renderTrimAtt(@NotNull TextureAtlasSprite sprite, @NotNull Model model, @NotNull PoseStack matrices, @NotNull MultiBufferSource provider, @Nullable LivingEntity entity, @NotNull ItemStack stack, @NotNull ArmorTrim trim, int light, int colour, @NotNull Function1<? super TrimOverlayRenderer.TrimInfo, ? extends TextureAtlasSprite> func) {
        Intrinsics.checkNotNullParameter((Object)sprite, (String)"sprite");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)trim, (String)"trim");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        if (isLegacyATT && ImageUtilsKt.getMissing(sprite)) {
            this.renderTrimExtendedLegacy(model, matrices, provider, entity, stack, trim, light, colour, func);
        } else if (this.isSpriteDynamic(sprite)) {
            this.renderTrimExtended(sprite, model, matrices, provider, entity, stack, trim, light, colour);
        }
    }

    private final void renderTrimExtendedLegacy(Model model, PoseStack matrices, MultiBufferSource provider, LivingEntity entity, ItemStack stack, ArmorTrim trim, int light, int color, Function1<? super TrimOverlayRenderer.TrimInfo, ? extends TextureAtlasSprite> cache) {
        List palette = PaletteHelper.getPalette((Item)((Item)((TrimMaterial)trim.m_266210_().m_203334_()).f_265970_().m_203334_()));
        for (int i = 0; i < 8; ++i) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)cache.invoke((Object)new TrimOverlayRenderer.TrimInfo(trim, i));
            if (ImageUtilsKt.getMissing(sprite) && entity != null && !ETRenderer.renderAlways(entity)) continue;
            FeatureRendererKt.render(model, sprite, matrices, provider, stack, light, ColorKt.withAlpha(((Color)palette.get(i)).getRGB(), ColorKt.alpha(color)));
        }
    }

    private final void renderTrimExtended(TextureAtlasSprite sprite, Model model, PoseStack matrices, MultiBufferSource provider, LivingEntity entity, ItemStack stack, ArmorTrim trim, int light, int colour) {
    }

    private final boolean isSpriteDynamic(TextureAtlasSprite sprite) {
        return false;
    }

    static {
        String string = ModStatus.INSTANCE.getVersion("allthetrims");
        isLegacyATT = string != null ? StringsKt.startsWith$default((CharSequence)string, (char)'3', (boolean)false, (int)2, null) : false;
    }
}

